/*
 * Copyright (C) 2006 uguu@users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.tokenizer;

import java.util.regex.Pattern;

/**
 * <p>
 * {@link Tokenizer}クラスが文字列から切り出すトークンの情報を持ちます。{@link Tokenizer}クラスは、{@link #getTokenPattern()}メソッドが返すパターンで入力文字列から部分文字列を切り出し、{@link #createToken(String, int, int)}メソッドを呼び出して{@link Token}インスタンスを生成します。
 * </p>
 * 
 * @author uguu@users.sourceforge.jp
 */
public interface TokenInfo {

    /**
     * <p>
     * 切り出すトークンの正規表現を返してください。{@link Tokenizer}クラスは、この正規表現を用いてトークンを識別します。
     * </p>
     * 
     * @return 切り出すトークンの正規表現。nullを返した場合、{@link Tokenizer}クラスは{@link NullPointerException}例外をスローします。
     */
    Pattern getTokenPattern();

    /**
     * <p>
     * トークンを切り出したときに、{@link Tokenizer}クラスによって呼び出されます。切り出した文字列、行番号、列番号の情報が渡されるので、その情報を元に{@link Token}インスタンスを生成して返してください。
     * </p>
     * 
     * @param token
     *            切り出した文字列。
     * @param line
     *            行番号。0から始まる。
     * @param column
     *            列番号。0から始まる。
     * @return 引数の情報を元に生成した{@link Token}インスタンス。
     */
    Token createToken(String token, int line, int column);
}
