/*
 * Copyright (C) 2006 uguu@users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.rpn_computer.test;

import jp.sourceforge.rpn_computer.RpnCommand;
import jp.sourceforge.rpn_computer.RpnCommandList;
import jp.sourceforge.rpn_computer.RpnCompiler;
import jp.sourceforge.rpn_computer.RpnNode;
import jp.sourceforge.rpn_computer.RpnParser;
import jp.sourceforge.rpn_computer.command.AddCommand;
import jp.sourceforge.rpn_computer.command.DivideCommand;
import jp.sourceforge.rpn_computer.command.MultiplyCommand;
import jp.sourceforge.rpn_computer.command.PushStackCommand;
import jp.sourceforge.rpn_computer.command.SubtractCommand;
import junit.framework.TestCase;

/**
 * コンパイルのテストを行います。
 * 
 * @author uguu@users.sourceforge.jp
 */
public class RpnCompilerTest extends TestCase {

    /**
     * インスタンスを初期化します。
     * 
     * @param name
     *            テストの名前。
     */
    public RpnCompilerTest(String name) {
        super(name);
    }

    /**
     * 正常系テスト1。
     */
    public void testNormal1() {
        String exp = "(1.2 + 3.4) * (5.6 - 7.8 / (9.0 + 0.1))";

        RpnParser parser = new RpnParser();
        RpnNode node = parser.parse(exp);

        RpnCompiler compiler = new RpnCompiler();
        RpnCommandList cl = compiler.compile(node);
        RpnCommand[] commands = cl.getCommands();

        assertEquals(11, commands.length);

        RpnCommand c = commands[0];
        assertTrue(c instanceof PushStackCommand);
        assertEquals("push_stack[1.2]", c.toString());

        c = commands[1];
        assertTrue(c instanceof PushStackCommand);
        assertEquals("push_stack[3.4]", c.toString());

        c = commands[2];
        assertTrue(c instanceof AddCommand);
        assertEquals("add", c.toString());

        c = commands[3];
        assertTrue(c instanceof PushStackCommand);
        assertEquals("push_stack[5.6]", c.toString());

        c = commands[4];
        assertTrue(c instanceof PushStackCommand);
        assertEquals("push_stack[7.8]", c.toString());

        c = commands[5];
        assertTrue(c instanceof PushStackCommand);
        assertEquals("push_stack[9.0]", c.toString());

        c = commands[6];
        assertTrue(c instanceof PushStackCommand);
        assertEquals("push_stack[0.1]", c.toString());

        c = commands[7];
        assertTrue(c instanceof AddCommand);
        assertEquals("add", c.toString());

        c = commands[8];
        assertTrue(c instanceof DivideCommand);
        assertEquals("divide", c.toString());

        c = commands[9];
        assertTrue(c instanceof SubtractCommand);
        assertEquals("subtract", c.toString());

        c = commands[10];
        assertTrue(c instanceof MultiplyCommand);
        assertEquals("multiply", c.toString());
    }

    /**
     * 異常系テスト1。{@link RpnCompiler#compile(RpnNode)}メソッドのnodeがnullのとき、{@link NullPointerException}例外がスローされることを確認します。
     */
    public void testFail1() {
        RpnCompiler compiler = new RpnCompiler();
        try {
            compiler.compile(null);
            fail();
        } catch (NullPointerException e) {
            assertEquals("nodeがnullです。", e.getMessage());
        }
    }
}
