#!/usr/bin/env perl -w

#
# rss2imap_useragent - rss2imap http access module.
#
# Copyright (C) 2005 Yoshinari Takaoka <mumumu@mumumu.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of the
# GPL2, GNU General Public License version 2.
#
# $Id: UserAgent.pm,v 1.1 2005/10/01 06:51:34 mumumu-org Exp $
#

use strict;
use RSS2IMAPLIB::Config;
use RSS2IMAPLIB::Common;
use Data::Dumper;

package RSS2IMAPLIB::UserAgent;
{

    our $config = undef;
    our $common = undef;

    #    extends LWP::UserAgent
    use LWP::UserAgent;
    our @ISA = qw ( LWP::UserAgent );

    sub new {
        my $pkg_name = shift;
        my $ua = LWP::UserAgent->new(@_);
        $config = RSS2IMAPLIB::Config->new()->get_global_configall();
        $common = RSS2IMAPLIB::Common->new();
        $ua->agent("rss2imap/".$config->{'version'});
        bless $ua, $pkg_name;
    }


    #    for proxy or basic authentication.
    sub get_basic_credentials {

        my $this       = shift;
        my $realm      = shift;
        my $uri        = shift;
        my $isproxy    = shift;
        my @abort_list = ();

        if( $isproxy ) {

            if ( $config->{'proxy-user'} && $config->{'proxy-pass'} ) {
                return ( $config->{'proxy-user'},
                         $config->{'proxy-pass'}
                );
            }
            if ( $config->{'proxy-user'})  {
                return ( $config->{'proxy-user'},
                         $common->getPass("Your proxy Password: ", 1)
                );
            } else {
                print "Your Proxy Server Requires Authentication.\n";
                return &__get_UserAndPass(undef,undef,1);
            }

        }

        #    basic auth(401) is ignored, because you cannot input
        #    auth information in daemon mode!!!!
        return @abort_list;
    }


    sub __get_UserAndPass {

        my $userprompt = shift;
        my $passprompt = shift;
        my $isproxy    = shift;

        return ( $common->getUser($userprompt,$isproxy),
                 $common->getPass($passprompt,$isproxy)
        );
    }

}

1;
