/**
 * @file export.c
 * @brief implement of process operation
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "nes_posix_access.h"
#include "nes_posix_file.h"
#include "nes_posix_pipe.h"
#include "nes_posix_sched.h"
#include "nes_posix_stricmp.h"
#include "nes_posix_unistd.h"
#include "nes_posix_isatty.h"
#include "nes_posix_proc.h"
#include "nes_posix_timeb.h"
#include "nes_posix_setpriority.h"
#include "nes_posix_stdlib.h"
#include "nes_posix_time.h"

////////////////// nes_posix_access.h ////////////////////////
int access(const char* pathname, int mode)
{
	return nes_posix_access(pathname, mode);
}

////////////////// nes_posix_file.h ////////////////////////
void flockfile(FILE *filehandle)
{
	  nes_posix_flockfile(filehandle);
}

////////////////// nes_posix_file.h ////////////////////////
void funlockfile(FILE *filehandle)
{
	  nes_posix_funlockfile(filehandle);
}

////////////////// nes_posix_pipe.h ////////////////////////
int pipe(int filedes[2])
{
	return nes_posix_pipe(filedes);
}

////////////////// nes_posix_pipe.h ////////////////////////
int pread(int flag, int cid, B* buf, int size)
{
	return nes_posix_pread(flag, cid, buf, size);
}

////////////////// nes_posix_pipe.h ////////////////////////
int pwrite(int flag, int cid, B* buf, int size)
{
	return nes_posix_pwrite(flag, cid, buf, size);
}

////////////////// nes_posix_pipe.h ////////////////////////
int delpipe(int fd)
{
	return nes_posix_delpipe(fd);
}

////////////////// nes_posix_pipe.h ////////////////////////
int getpipe(void)
{
	return nes_posix_getpipe();
}

////////////////// nes_posix_sched.h ////////////////////////
int sched_get_priority_max(int policy)
{
	return nes_posix_sched_get_priority_max (policy);
}

////////////////// nes_posix_sched.h ////////////////////////
int sched_get_priority_min(int policy)
{
	return nes_posix_sched_get_priority_min (policy);
}

////////////////// nes_posix_sched.h ////////////////////////
int sched_rr_get_interval(pid_t pid, struct timespec* tp)
{
	return  nes_posix_sched_rr_get_interval(pid, tp);
}

////////////////// nes_posix_sched.h ////////////////////////
int sched_yield(void)
{
	return nes_posix_sched_yield();
}

////////////////// nes_posix_stricmp.h ////////////////////////
int stricmp(const char *str1,const char *str2)
{
  return nes_posix_stricmp(str1,str2);
}

////////////////// nes_posix_unistd.h ////////////////////////
int usleep(useconds_t usec)
{
	return nes_posix_usleep(usec);
}

////////////////// nes_posix_isatty.h ////////////////////////
int isatty(int fd)
{
	return nes_posix_isatty(fd);
}

////////////////// nes_posix_proc.h ////////////////////////
void _exit(int status)
{
	nes_posix_exit(status);
}

////////////////// nes_posix_proc.h ////////////////////////
unsigned int sleep(unsigned int seconds)
{
	return nes_posix_sleep(seconds);
}

////////////////// nes_posix_proc.h ////////////////////////
int t_cre_prc(W pri, const char* path)
{
	return nes_posix_t_cre_prc(pri, path);
}

////////////////// nes_posix_proc.h ////////////////////////
pid_t wait(int* status)
{
	return nes_posix_wait(status);
}

////////////////// nes_posix_proc.h ////////////////////////
pid_t waitpid(pid_t pid, int* status, int options)
{
	return nes_posix_waitpid(pid, status, options);
}

////////////////// nes_posix_proc.h ////////////////////////
int nanosleep(const struct timespec* req,struct timespec* rem)
{
	return nes_posix_nanosleep(req, rem);
}
////////////////// nes_posix_timeb.h ////////////////////////
int ftime(struct timeb* __timebuf)
{
	return nes_posix_ftime(__timebuf);
}

////////////////// nes_posix_setpriority.h ////////////////////////
int setpriority(int which, int who, int prio)
{
	return nes_posix_setpriority(which, who, prio);
}

////////////////// nes_posix_stdlib.h ////////////////////////
int posix_system(const char *command)
{
	return nes_posix_system(command);
}

////////////////// nes_posix_time.h ////////////////////////
int clock_gettime(clockid_t clock_id, struct timespec *tp)
{
	return nes_posix_clock_gettime(clock_id, tp);
}

////////////////// nes_posix_time.h ////////////////////////
int gettimeofday(struct timeval *tv, struct timezone *tz)
{
	  return nes_posix_gettimeofday(tv, tz);
}
