// -*- C++ -*-
/*!
 * @file  SampleGPSDataOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleGPSDataOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* samplegpsdataout_spec[] =
  {
    "implementation_id", "SampleGPSDataOut",
    "type_name",         "SampleGPSDataOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleGPSDataOut::SampleGPSDataOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_gpsdataOut("gpsdata", m_gpsdata)

    // </rtc-template>
{
}

SampleGPSDataOut::~SampleGPSDataOut()
{
}


RTC::ReturnCode_t SampleGPSDataOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("gpsdata", m_gpsdataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleGPSDataOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleGPSDataOut::onExecute(RTC::UniqueId ec_id)
{
  
  // GPSData
  m_gpsdata.latitude = 30.2;
  m_gpsdata.longitude = 50.4;
  m_gpsdata.altitude = 60.8;
  m_gpsdata.horizontalError = -1;
  m_gpsdata.verticalError = -2;
  m_gpsdata.heading = 40.12;
  m_gpsdata.horizontalSpeed = 30.12;
  m_gpsdata.verticalSpeed = 40.12;
  m_gpsdata.numSatellites = 10;
  m_gpsdata.fixType = GPS_FIX_NONE;
#ifndef __T_KERNEL__  
  m_gpsdataOut.write();
#endif
  std::cout << "GPSData write" << std::endl;
  std::cout << "latitude:" << m_gpsdata.latitude << std::endl;
  std::cout << "longitude:" << m_gpsdata.longitude << std::endl;
  std::cout << "altitude:" << m_gpsdata.altitude << std::endl;
  std::cout << "horizontalError:" << m_gpsdata.horizontalError << std::endl;
  std::cout << "verticalError:" << m_gpsdata.verticalError << std::endl;
  std::cout << "heading:" << m_gpsdata.heading << std::endl;
  std::cout << "horizontalSpeed:" << m_gpsdata.horizontalSpeed << std::endl;
  std::cout << "verticalSpeed:" << m_gpsdata.verticalSpeed << std::endl;
  std::cout << "numSatellites:" << m_gpsdata.numSatellites << std::endl;
  std::cout << "fixType:" << m_gpsdata.fixType << std::endl;
  std::cout << std::endl;
#ifdef __T_KERNEL__
  m_gpsdataOut.write();
  sleep(5);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleGPSDataOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleGPSDataOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleGPSDataOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(samplegpsdataout_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleGPSDataOut>,
                             RTC::Delete<SampleGPSDataOut>);
  }
  
};



