#ifdef __T_KERNEL__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <coil/uuid_gen.h>
#include <nes_posix_time.h>

#define TIME_OFFSET_HIGH 0x01B21DD2
#define TIME_OFFSET_LOW  0x13814000
#define MAX_ADJUSTMENT 10
/*
 * prototypes
 */
static void get_random_bytes(void *buf, int nbytes);
static int get_clock(unsigned int *clock_high, unsigned int *clock_low, unsigned short *ret_clock_seq)
{
	int			adjustment = 0;
	struct timeval		last = {0, 0};
	unsigned short			clock_seq;
	struct timeval			tv;
	unsigned long long		clock_reg;

try_again:
	nes_posix_gettimeofday(&tv, 0);
	if ((last.tv_sec == 0) && (last.tv_usec == 0)) {
		get_random_bytes(&clock_seq, sizeof(clock_seq));
		clock_seq &= 0x3FFF;
		last = tv;
		last.tv_sec--;
	}
	if ((tv.tv_sec < last.tv_sec) ||
	    ((tv.tv_sec == last.tv_sec) &&
	     (tv.tv_usec < last.tv_usec))) {
		clock_seq = (clock_seq+1) & 0x3FFF;
		adjustment = 0;
		last = tv;
	} else if ((tv.tv_sec == last.tv_sec) &&
	    (tv.tv_usec == last.tv_usec)) {
		if (adjustment >= MAX_ADJUSTMENT)
			goto try_again;
		adjustment++;
	} else {
		adjustment = 0;
		last = tv;
	}

	clock_reg = tv.tv_usec*10 + adjustment;
	clock_reg += ((unsigned long long) tv.tv_sec)*10000000;
	clock_reg += (((unsigned long long) 0x01B21DD2) << 32) + 0x13814000;

	*clock_high = clock_reg >> 32;
	*clock_low = clock_reg;
	*ret_clock_seq = clock_seq;
	return 0;
}
static void get_random_bytes(void *buf, int nbytes)
{
        int i=0;
        unsigned char *cp = (unsigned char *) buf;
        for ( i = 0; i < nbytes; i++)
                *cp++ ^= (rand() >> 7) & 0xFF;
        return;
}
void uuid_generate_time(struct uuid *uu)
{
     
        unsigned char node_id[6]={0};
	unsigned int	clock_mid;
        if(!uu)
            return;
        get_random_bytes(node_id,6);
	get_clock(&clock_mid, &(uu->time_low), &(uu->clock_seq));
	uu->clock_seq |= 0x8000;
	uu->time_mid = (unsigned short) clock_mid;
	uu->time_hi_and_version = ((clock_mid >> 16) & 0x0FFF) | 0x1000;
	memcpy(uu->node, node_id, 6);
}

#endif
