#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <btron/errcode.h>

#include "pmc_sock.h"

#define RETURN_ERROR {; }
EXPORT int socket(int domain, int type, int protocol)
{
	int iRet = 0;
	iRet = so_socket(domain, type, protocol);
	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_NOBUFS:
			errno = ENOBUFS;
			break;
		case EX_PROTONOSUPPORT:
			errno =  EPROTONOSUPPORT;
			break;
		default:
			errno = EAFNOSUPPORT;   		
			break;    		
	}

	return -1;    	
exit1:
	return iRet;
}


EXPORT int bind(int sockfd, struct sockaddr *addr, int addrlen)
{
	int iRet;
	iRet = so_bind(sockfd, addr, addrlen);

	if(iRet == 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR :
			errno = EACCES;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		case EX_ADDRNOTAVAIL:
			errno = EADDRNOTAVAIL;
			break;

		case EX_ADDRINUSE:
			errno = EADDRINUSE;
			break;

		default:
			errno = EINVAL;
			break; 			 	

	}
        iRet=1;
exit1:
	return iRet;
}

EXPORT int listen(int sockfd, int queue_len)
{
	int iRet;
	iRet = so_listen(sockfd, queue_len);
	if(iRet == 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;    		

		default:
			errno = EINVAL;
			break;

	}
	return -1;
exit1:
	return iRet;
}

EXPORT int accept(int sockfd, struct sockaddr *addr, int *addr_len)
{
	int iRet;
	iRet = so_accept(sockfd, addr, addr_len);
	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR :
			errno = EACCES;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		case EX_WOULDBLOCK:
			errno = EWOULDBLOCK;
			break;

		case EX_NOBUFS:
			errno = ENOMEM;
			break;

		default:
			errno = EINVAL;
			break; 			 	

	}
	return -1;
exit1:
	return iRet;
}

EXPORT int connect(int sockfd, struct sockaddr *addr, int addr_len)
{
	int iRet;
	iRet = so_connect(sockfd, addr, addr_len);

	if(iRet == 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR :
			errno = EACCES;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		case EX_HOSTUNREACH:
			errno = ENETUNREACH;
			break;

		case EX_INPROGRESS:
			errno = EINPROGRESS;
			break;

		case EX_TIMEDOUT     :
			errno = ETIMEDOUT;
			break;

		case EX_CONNABORTED:
			errno = ECONNREFUSED;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}
	return -1;

exit1:
	return iRet;
}

EXPORT int send(int sockfd, void *buffer, int msg_len, int options)
{
	int iRet;
	iRet = so_send(sockfd, buffer, msg_len, options);

	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR :
			errno = EACCES;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		case EX_SHUTDOWN:
			errno = ECONNREFUSED;
			break;

		case EX_MSGSIZE :
			errno = EMSGSIZE;
			break;

		case EX_TIMEDOUT:
			errno = ETIMEDOUT;
			break;

		case EX_CONNABORTED:
			errno = ECONNREFUSED;
			break;

		case EX_NOBUFS:
			errno = ENOBUFS;
			break;

		case EX_WOULDBLOCK:
			errno = EWOULDBLOCK;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}
	return -1;

exit1:
	return iRet;
}

EXPORT int sendto(int sockfd, void *msg, int len, int options, struct sockaddr *addr, int addr_len)
{
	int iRet;
	iRet = so_sendto(sockfd, (char *)msg, len, options, (SOCKADDR *)addr, addr_len);

	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR :
			errno = EACCES;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		case EX_SHUTDOWN:
			errno = ECONNREFUSED;
			break;

		case EX_MSGSIZE:
			errno = EMSGSIZE;
			break;

		case EX_TIMEDOUT:
			errno = ETIMEDOUT;
			break;

		case EX_CONNABORTED:
			errno = ECONNREFUSED;
			break;

		case EX_NOBUFS:
			errno = ENOBUFS;
			break;

		case EX_WOULDBLOCK:
			errno = EWOULDBLOCK;
			break;

		case EX_HOSTUNREACH:
			errno = EHOSTUNREACH;
			break;

		case EX_DESTADDRREQ:
			errno = EDESTADDRREQ;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}
	return -1;
exit1:
	return iRet;
}

EXPORT int recv(int sockfd, void *buf, int maxbuf, int options)
{
	int iRet;
	iRet = so_recv(sockfd, buf, maxbuf, options);
	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	return -1;
	switch(iRet)
	{
		case EX_ADR :
			errno = EACCES;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		case EX_TIMEDOUT:
			errno = ETIMEDOUT;
			break;

		case EX_CONNABORTED:
			errno = EINTR;
			break;

		case EX_OPNOTSUPP:
			errno = EOPNOTSUPP;
			break;

		case EX_WOULDBLOCK:
			errno = EWOULDBLOCK;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}
	return -1;
exit1:
	return iRet;  

}

EXPORT int recvfrom(int sockfd, void *buf, int buf_len, int options, struct sockaddr *adr, int *addr_len)
{
	int iRet;
	iRet = so_recvfrom(sockfd, buf, buf_len, options, adr, addr_len);
	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR :
			errno = EACCES;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		case EX_TIMEDOUT:
			errno = ETIMEDOUT;
			break;

		case EX_CONNABORTED:
			errno = EINTR;
			break;

		case EX_OPNOTSUPP:
			errno = EOPNOTSUPP;
			break;

		case EX_WOULDBLOCK:
			errno = EWOULDBLOCK;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}
	return -1;

exit1:
	return iRet; 

}


EXPORT int shutdown(int sockfd, int how)
{
	int iRet;
	iRet = so_shutdown(sockfd, how);
	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_NOBUFS :
			errno = ENOBUFS;
			break;

		case EX_PAR :
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}
	return -1;
exit1:
	return iRet;  
}


EXPORT int setsockopt(int sd, int level, int optname, const void *optval, int optlen)
{
	int iRet = 0;
	iRet = so_setsockopt(sd, level, optname, (char *)optval, optlen);
	if(iRet == 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR:
			errno = ENOPROTOOPT;
			break;

		case EX_PAR :
			errno = EACCES;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}	
	return -1;
exit1:
	return iRet; 		
}

EXPORT int select(int hi_fd, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout)
{
	int iRet;
	iRet = so_select(hi_fd, readfds, writefds, exceptfds, timeout);

	if(iRet >= 0)
		goto exit1;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR:
			errno = ENOPROTOOPT;
			break;

		default:
			errno = EINVAL;
			break;		 	
	}	
	return -1;
exit1:
	return iRet;     
}


EXPORT int closesocket(int fd)
{
	int iRet;
	iRet = so_close(fd);
	if(iRet == 0)
		return iRet;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_PAR:
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		default:
			iRet = EINVAL;
			break;   
	}
	return -1;
}


int gethostname(char *nam, int len)
{
	int iRet = so_gethostname(nam, len);
	if(iRet == EX_ADR)
	{
		errno= ENOPROTOOPT;
		return -1;
	}
	return iRet;
}

struct hostent * gethostbyname(const char  * name)
{
	int iRet;
	char tmpBuf[HBUFLEN] = {0};

	struct hostent *tmpHostent=(struct hostent *)malloc(sizeof(struct hostent));
	if(!tmpHostent) {
		return NULL;
	}

	iRet= so_gethostbyname((B *)name, tmpHostent, tmpBuf);
	switch(iRet)	
	{
		case EX_ADR:
			errno = ENOPROTOOPT;
			break;
		case EX_HOSTUNREACH:
			errno = ESOCKTNOSUPPORT;
			break;
		case EX_TIMEDOUT:
			errno = ETIMEDOUT;
			break;
		default:
			errno = EINVAL;
			break;    	   	     		   
	}

	if((iRet==EX_ADR)||(iRet== EX_HOSTUNREACH)||(iRet== EX_TIMEDOUT)) {
		free(tmpHostent);
		tmpHostent=NULL;
	}

	return tmpHostent;
}

EXPORT int gethostbyaddr(char *addr, int len, int type, HOSTENT *hp, char *buf)
{
	int iRet = gethostbyaddr(addr, len, type, hp, buf);
	if(iRet == 0)
		return iRet;
	else
		RETURN_ERROR;
	if(iRet == EX_ADR)
	        errno= ENOPROTOOPT;

	if(iRet == EX_HOSTUNREACH)	
		errno= HOST_NOT_FOUND;
	return -1;

}

EXPORT int getpeername(int s, SOCKADDR *nam, int *namlen)
{
	int iRet = so_getpeername(s, nam, namlen);
	if(iRet == 0)
		return iRet;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR:
			errno = ESOCKTNOSUPPORT;
			break;

		case EX_PAR:
			errno = EINVAL;
			break;

		case EX_BADF:
			errno = EBADF;
			break;

		default:
			errno = EINVAL;
			break;  

	}
	return -1;
}


EXPORT int getsockname(int s, SOCKADDR *nam, int *namlen)
{
	int iRet = so_getsockname(s, nam, namlen);
	if(iRet == 0)
		return iRet;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR:
			errno = ESOCKTNOSUPPORT;
			break;

		case EX_PAR:
			errno = EINVAL;
			break;

		case EX_BADF     :
			errno = EBADF;
			break;

		default:
			errno = EINVAL;
			break;  

	}
	return -1;
}
EXPORT int getsockopt(int s, int level, int optnam, char *optval, int *optlen)
{
	int iRet = so_getsockopt(s, level, optnam, optval, optlen);
	if(iRet == 0)
		return iRet;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR:
			errno = ESOCKTNOSUPPORT;
			break;

		case EX_PAR:
			errno = EINVAL;
			break;

		case EX_BADF     :
			errno = EBADF;
			break;

		case EX_NOPROTOOPT:
			errno = ENOPROTOOPT;
			break;	   
		default:
			errno = EINVAL;
			break;  

	}
	return -1;
}
/* End added */

/* Added by Han Zenghui @ NES(JiNan). 2006/07/31 */
EXPORT int fcntl(int s, int cmd, int arg)
{
	int iRet = so_fcntl(s, cmd, arg);
	if(iRet == 0)
		return iRet;
	else
		RETURN_ERROR;
	switch(iRet)
	{
		case EX_ADR:
			errno = ESOCKTNOSUPPORT;
			break;

		case EX_PAR:
			errno = EINVAL;
			break;

		case EX_BADF     :
			errno = EBADF;
			break;

		case EX_NOPROTOOPT:
			errno = ENOPROTOOPT;
			break;	   
		default:
			errno = EINVAL;
			break;  

	}
	return -1;
}
/*End added */
