#!/usr/bin/ruby
#
# CaseSensitiveEscape
#
# Copyright (c) 2003- Kazuhiro NISHIYAMA.
# You can redistribute it and/or modify it under the same terms as Ruby.
#
# $Id: case_sensitive_escape.rb,v 1.3 2003/02/08 20:58:11 znz Exp $

module CaseSensitiveEscape
  module_function
  def escape(str)
    str.gsub(/./n){
      case $&[0]
      when ?A .. ?Z
        "^#$&"
      when ?a .. ?z, ?0 .. ?9, ?_, ?-
        "_#$&"
      else
        sprintf("%02X", $&.unpack("C")[0])
      end
    }
  end

  def unescape(str)
    str.tr('+', ' ').gsub(/[0-9a-fA-F]{2}|\^[A-Z]|_[a-z0-9_-]/n) do
      case $&[0]
      when ?_
        $&[1,1].downcase # make sure downcase
      when ?^
        $&[1,1].upcase # make sure upcase
      when ?0 .. ?9, ?a .. ?f, ?A .. ?F
        [$&].pack('H*')
      else
        $& # not reached(?)
      end
    end
  end
end

if __FILE__ == $0
  eval DATA.read, nil, $0, __LINE__+4
end

__END__
require 'runit/testcase'
require 'runit/cui/testrunner'

class CaseSensitiveEscape_Test < RUNIT::TestCase
  include CaseSensitiveEscape

  E = [
    ['abc', '_a_b_c'],
    ['ABC', '^A^B^C'],
    ['.', '2E'],
    ['/', '2F'],
    ['^', '5E'],
    ['_', '__'],
    ['foo.rd', '_f_o_o2E_r_d'],
    ['(^_^)', '285E__5E29'],
  ]

  def test_escape
    assert_equal('_a_b_c', CaseSensitiveEscape.escape('abc'))
    assert_equal('_a_b_c', escape('abc'))
    E.each do |unescaped, escaped|
      assert_equal(escaped, escape(unescaped))
    end
  end
  def test_unescape
    assert_equal('abc', CaseSensitiveEscape.unescape('_a_b_c'))
    assert_equal('abc', unescape('_a_b_c'))
    E.each do |unescaped, escaped|
      assert_equal(unescaped, unescape(escaped))
    end
  end
  def test_turnaround
    E.each do |unescaped, escaped|
      assert_equal(escaped, unescape(escape(escaped)))
      assert_equal(unescaped, unescape(escape(unescaped)))
    end
  end
end

RUNIT::CUI::TestRunner.run(CaseSensitiveEscape_Test.suite)
