
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


separate( cube )

procedure getKeyInputs( mainWin : access GLFWwindow ) is
--movement requires discrete arrow-key responses.
--But, due to the use of pollevents in "main", we must wait until
--receiving a key up to avoid multiple responses to a key press.

	deltaTime,
	nowTime : gldouble;
	xpos,ypos : aliased gldouble;

	zmin : constant gldouble := zoomwheel.zmin;
	zmax : constant gldouble := zoomwheel.zmax;
	sel,dir: character;
begin

	nowTime := glfwGetTime;
	deltaTime := nowTime - oldTimeKb;



-- First, we process continuous key-press responses:-----------------

if glfwgetkey( mainWin, glfw_key_escape ) = Glfw_Press then
		userexit:=true;
		return;

elsif glfwgetkey( mainWin, glfw_key_q ) = Glfw_Press then
		userexit:=true;
		return;

--Nearer : zoom In
elsif glfwgetkey( mainWin, glfw_key_i ) = Glfw_Press then
			zoomwheel.zdist:=0.99*zoomwheel.zdist;
			if zoomwheel.zdist<zmin then zoomwheel.zdist:=zmin; end if;

--Further : zoom Out
elsif glfwgetkey( mainWin, glfw_key_o ) = Glfw_Press then
			zoomwheel.zdist:=1.01*zoomwheel.zdist;
			if zoomwheel.zdist>zmax then zoomwheel.zdist:=zmax; end if;



-- Second, we process discrete key-press events -----------------------

elsif deltaTime > keydlay then 

	nowTime := glfwGetTime;

	-- +Y
	if glfwgetkey( mainWin, glfw_key_up ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		moveYp;
		oldTimeKb := nowTime;

	-- -Y
	elsif glfwgetkey( mainWin, glfw_key_down ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		moveYm;
		oldTimeKb := nowTime;

	-- -X
	elsif glfwgetkey( mainWin, glfw_key_left ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		moveXm;
		oldTimeKb := nowTime;

	-- +X
	elsif glfwgetkey( mainWin, glfw_key_right ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		moveXp;
		oldTimeKb := nowTime;

	-- -Z, Backward
	elsif glfwgetkey( mainWin, glfw_key_b ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		moveZm;
		oldTimeKb := nowTime;

	-- +Z, Forward
	elsif glfwgetkey( mainWin, glfw_key_f ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		moveZp;
		oldTimeKb := nowTime;

	-- Restart
	elsif glfwgetkey( mainWin, glfw_key_r ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		restart;
		oldTimeKb := nowTime;


	elsif glfwgetkey( mainWin, glfw_key_m ) = Glfw_Press then
		mute:=not mute;
		oldTimeKb := nowTime;


	elsif glfwgetkey( mainWin, glfw_key_1 ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		shuffle(1);
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_2 ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		shuffle(2);
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_3 ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		shuffle(3);
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_4 ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		shuffle(4);
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_5 ) = Glfw_Press then
		haveSolution:=0;
		nsol:=0;
		shuffle(5);
		oldTimeKb := nowTime;


	elsif glfwgetkey( mainWin, glfw_key_h ) = Glfw_Press then
		help:=not help;
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_a ) = Glfw_Press then
		show_axes:=not show_axes;
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_space ) = Glfw_Press then
		hint:=not hint;
		oldTimeKb := nowTime;

	elsif glfwgetkey( mainWin, glfw_key_x ) = Glfw_Press then
		details:=not details;
		oldTimeKb := nowTime;


	elsif glfwgetkey( mainWin, glfw_key_c ) = Glfw_Press then

		-- Cycle thru 4 alternate skins AND resets to initial config

		haveSolution:=0;
		nsol:=0;

		if cskin then --go to gskin
			gskin:=true; 
			cskin:=false;  yskin:=false; rskin:=false;
			jaapsetgreen; --reset
			glfwsetwindowtitle(mainwin,new_string(ititle));

		elsif gskin then --go to yskin
			yskin:=true;
			cskin:=false; gskin:=false; rskin:=false;
			jaapsetYellowG; --reset
			glfwsetwindowtitle(mainwin,new_string(ititle));

		elsif yskin then --go to rskin
			rskin:=true;
			cskin:=false; gskin:=false; yskin:=false;
			jaapsetYellowR; --reset
			glfwsetwindowtitle(mainwin,new_string(ititle));

		elsif rskin then -- go to cskin: rufascube
			cskin:=true;
			gskin:=false; yskin:=false; rskin:=false;

			firstcallcubic:=true;
			initperm;
			cubic(1.0,perm);
			glfwsetwindowtitle(mainwin,new_string(otitle));

		else -- choose one:
			gskin:=true;
			cskin:=false;  yskin:=false; rskin:=false;
			jaapsetgreen; --reset
			glfwsetwindowtitle(mainwin,new_string(ititle));

		end if;

		oldTimeKb := nowTime;




	elsif glfwgetkey( mainWin, glfw_key_t ) = Glfw_Press then

		-- toggle 2 primary Skins (no reset of cube)

		rgbskin:=not rgbskin;

		if rgbskin then --rgbcube
			glfwsetwindowtitle(mainwin,new_string(rtitle));
		elsif cskin then --rufascube
			glfwsetwindowtitle(mainwin,new_string(otitle));
		else --iqube
			glfwsetwindowtitle(mainwin,new_string(ititle));
		end if;

		oldTimeKb := nowTime;


	elsif 

		(glfwgetkey( mainWin, glfw_key_equal ) = Glfw_Press) -- true Solver

	then

		oldTimeKb := nowTime;

		-- solve one step at a time:
		if haveSolution>0 then

			nsol:=0; --disable shuffle-undo

			sel:=element(solutionPath,1); --possibly not needed?
			dir:=element(solutionPath,3);
			delete(solutionPath,1,3);
			haveSolution := length(solutionPath);

			if dir='l' then
				moveXm; --moveleft;
			elsif dir='r' then
				moveXp; --moveright;
			elsif dir='u' then --inverted due to screen Y vs OGL
				moveYm; --moveup;
			elsif dir='d' then -- inverted due to screen Y vs OGL
				moveYp; --movedown;
			elsif dir='b' then
				moveZm; --movenear;
			elsif dir='f' then
				moveZp; --moveaway;
			else
				--raise program_error;
				haveSolution:=0;
			end if;

		else -- initiate solver

			failureNotice:=false;

			permdump("26.blok"); --experiment 27feb21

			--note: currently limited depth of search (2M~10sec)
			bfs26.bfs(to_unbounded_string("26.blok"),solutionPath);
			haveSolution := length(solutionPath);

			if haveSolution<1 then 
				timedout:=true;
				--put_line("T O set");
			end if;

		end if;




	elsif 
		(glfwgetkey( mainWin, glfw_key_u ) = Glfw_Press) -- UNDO shuffle
	then

		oldTimeKb := nowTime;
		haveSolution:=0; --cancel solver

		-- solve one step at a time:
		if nsol>0 then

			put_line(integer'image(nsol)&" steps to solution.");

			s:=sol(nsol); nsol:=nsol-1;
			if s=lf then
				moveXm; --moveleft;
			elsif s=rt then
				moveXp; --moveright;
			elsif s=up then -- inverted due to screen Y vs OGL
				moveYm; --moveup;
			elsif s=dn then -- inverted due to screen Y vs OGL
				moveYp; --movedown;
			elsif s=nr then
				moveZm; --movenear;
			elsif s=aw then
				moveZp; --moveaway;
			else
				raise program_error;
			end if;

		end if;




	elsif glfwgetkey( mainWin, glfw_key_enter ) = Glfw_Press then
		oldTimeKb := nowTime;
		glfwgetcursorpos(mainWin,xpos'access,ypos'access);
		clickRight(xpos,ypos,gldouble(winwidth),gldouble(winheight));

	end if;

end if;

end getKeyInputs;




