require 'gtk2'
require 'parsedate'
require 'rexml/document'
require 'ruggregator/rss'

$config
$cached_items

ACCEPTED_WINDOW_CONFIG = ["x","y","width","height","hpos","vpos"]
ACCEPTED_ACTION = ["Quit","Preferences","About"]

def write_default_configuration
  f = open(configfile,"w")

  default = <<DEFAULT_CONFIG
<?xml version='1.0' encoding='UTF-8'?>
<configuration version='1.0'>
<rssfeeds>
    <rss>
      <title>CNET Japan</title>
      <url>http://japan.cnet.com/rss/index.rdf</url>
    </rss>
    <rss>
      <title>＠IT</title>
      <url>http://www.atmarkit.co.jp/rss/rss2dc.xml</url>
    </rss>
    <rss>
      <title>スラッシュドット ジャパン</title>
      <url>http://slashdot.jp/slashdotjp.rss</url>
    </rss>
    <rss>
      <title>ZDNet Japan ニュース</title>
      <url>http://japan.zdnet.com/rss/news/index.rdf</url>
    </rss>
  </rssfeeds>
  <filters>
    <filter>
      <name>スラッシュドット ジャパン</name>
      <rss-url>http://slashdot.jp/slashdotjp.rss</rss-url>
      <key>date</key>
      <rule>descending</rule>
    </filter>
    <filter>
      <name>ITニュースなど</name>
      <rss-url>http://japan.cnet.com/rss/index.rdf;http://www.atmarkit.co.jp/rss/rss2dc.xml;http://japan.zdnet.com/rss/news/index.rdf</rss-url>
      <key>date</key>
      <rule>descending</rule>
    </filter>
  </filters>
  <url-handler>firefox -remote &apos;openURL(%s, new-tab)&apos;</url-handler>
  <date-format>%x %H:%M:%S</date-format>
  <accel-key>
    <action>Quit</action>
    <key>Q</key>
    <ctrl-mask>true</ctrl-mask>
  </accel-key>
  <accel-key>
    <action>Preferences</action>
    <key>P</key>
    <ctrl-mask>true</ctrl-mask>
  </accel-key>
  <accel-key>
    <action>About</action>
    <key>A</key>
    <ctrl-mask>true</ctrl-mask>
  </accel-key>
  <window>
    <x>36</x>
    <y>32</y>
    <width>740</width>
    <height>528</height>
    <hpos>148</hpos>
    <vpos>205</vpos>
  </window>
</configuration>
DEFAULT_CONFIG
   
  f.puts default
    
  f.close
end

def check_configure_directory_existence
  home = ENV["HOME"]
  dir = home + "/.ruggregator"
  if FileTest.exist?(dir) && FileTest.directory?(dir)
    return true
  else
    Dir.mkdir(dir)
    return false
  end
end

def configfile
  home = ENV["HOME"]
  return home + "/.ruggregator/configure.xml"
end

def readitemsfile
  home = ENV["HOME"]
  return home + "/.ruggregator/readitems.xml"
end

def cacheditemsfile
  home = ENV["HOME"]
  return home + "/.ruggregator/cacheditems.xml"
end

def tmplogofile
  home = ENV["HOME"]
  return home + "/.ruggregator/tmplogo.png"
end

def output_configuration
  doc = REXML::Document.new '<?xml version="1.0" encoding="utf-8"?>
<configuration version="1.0">
</configuration>'

  root = doc.root
  feeds_node = root.add_element("rssfeeds")
  $rssfeeds.each{|feed|
    feed_node = feeds_node.add_element("rss")
    node = feed_node.add_element("title")
    node.text = feed.title
    node = feed_node.add_element("url")
    node.text = feed.url
  }

  filters_node = root.add_element("filters")
  $filters.each{ |filter|
    filter_node = filters_node.add_element("filter")
    node = filter_node.add_element("name")
    node.text = filter.name
    node = filter_node.add_element("rss-url")
    node.text = filter.rss_urls.join(';')
    node = filter_node.add_element("key")
    node.text = filter.key
    node = filter_node.add_element("rule")
    node.text = filter.rule
  }

  node = root.add_element("url-handler")
  node.text = $config["url-handler"]

  node = root.add_element("date-format")
  node.text = $config["date-format"]

  ACCEPTED_ACTION.each{|action|
    node = root.add_element("accel-key")
    node.add_element("action").text = action
    node.add_element("key").text = Gdk::Keyval.to_name($config["accel-key/#{action}"]["keyval"])
    case($config["accel-key/#{action}"]["mask"])
    when Gdk::Window::CONTROL_MASK
      node.add_element("ctrl-mask").text = "true"
    else
      node.add_element("ctrl-mask").text = "false"
    end
  }

  node = root.add_element("window")
  ACCEPTED_WINDOW_CONFIG.each{ |e|
    node.add_element(e).text = $config["window/#{e}"]
  }

  f = open(configfile,"w")
  o = ''
  doc.write REXML::Output.new(o,"UTF-8"),0
  f.puts o
  f.close
end

def parse_configuration
  unless check_configure_directory_existence && FileTest.file?(configfile)
    write_default_configuration
  end

  $config = Hash.new

  file = File.new(configfile)
  doc = REXML::Document.new file

  # RSS feeds configuration
  doc.elements.each("configuration/rssfeeds/rss"){ |element|
    title = element.elements["title"].text
    url = element.elements["url"].text
    feed = RSSFeed.new(url,title)
    $rssfeeds.add_rss(feed)
  }
  
  # filter configuration
  doc.elements.each("configuration/filters/filter"){ |element|
    name = element.elements["name"].text
    rss_urls = element.elements["rss-url"].text.split(";")
    key = element.elements["key"].text
    rule = element.elements["rule"].text
    filter = Filter.new(name,rss_urls,key,rule)
    
    add_filter(filter)
  }

  # other properties
  $config["url-handler"] = doc.elements["configuration"].elements["url-handler"].text
  $config["date-format"] = doc.elements["configuration"].elements["date-format"].text

  # accel keys configuration
  doc.elements.each("configuration/accel-key"){ |element|
    action = element.elements["action"].text
    key = element.elements["key"].text
    keyval = Gdk::Keyval.from_name(key)
    mask = 0
    mask = Gdk::Window::CONTROL_MASK if element.elements["ctrl-mask"].text == "true"
    $config["accel-key/#{action}"] = {"keyval" => keyval, "mask" => mask}
  }

  # window configuration
  ACCEPTED_WINDOW_CONFIG.each{ |e|
    $config["window/#{e}"] =  doc.elements["configuration"].elements["window"].elements[e].text.to_i
  }
end

def output_read_items
  doc = REXML::Document.new '<?xml version="1.0" encoding="utf-8"?>
<readitems>
</readitems>'

  root = doc.root
  $read_items.each{ |hash|
    node = root.add_element("hash")
    node.text = hash
  }

  f = open(readitemsfile,"w")
  o = ''
  doc.write REXML::Output.new(o,"UTF-8"),0
  f.puts o
  f.close
end

def load_read_items
  if check_configure_directory_existence && FileTest.file?(readitemsfile)
    file = File.new(readitemsfile)
    doc = REXML::Document.new file
    
    doc.elements.each("readitems/hash"){ |element|
      $read_items.push(element.text)
    }
  end
end

def output_cached_items
  doc = REXML::Document.new '<?xml version="1.0" encoding="utf-8"?>
<cacheditems>
</cacheditems>'

  root = doc.root
  $cached_items.each{ |url,items|
    items_node = root.add_element("items")
    node = items_node.add_element("url")
    node.text = url
    items.each{ |item|
      node = items_node.add_element("item")
      node.add_element("title").text = item.title
      node.add_element("link").text = item.link
      node.add_element("dc_date").text = item.dc_date.iso8601
      node.add_element("description").text = item.description if item.description
      node.add_element("content_encoded").text = item.content_encoded if item.content_encoded
    }
  }

  f = open(cacheditemsfile,"w")
  o = ''
  doc.write REXML::Output.new(o,"UTF-8"),0
  f.puts o
  f.close
end

def cache_item(url,item)
  $cached_items[url] = Array.new unless $cached_items[url]
  $cached_items[url].each{ |cached_item|
    return if cached_item.title == item.title && cached_item.dc_date == item.dc_date
  }
  $cached_items[url].push(item)
end

def cached_items(url)
  return $cached_items[url]
end

def load_cached_items
  $cached_items = Hash.new

  if check_configure_directory_existence && FileTest.file?(cacheditemsfile)
    file = File.new(cacheditemsfile)
    doc = REXML::Document.new file
    
    doc.elements.each("cacheditems/items"){ |element|
      url = element.elements["url"].text
      $cached_items[url] = Array.new
      element.elements.each("item"){ |item|
        title = item.elements["title"].text
        link = item.elements["link"].text
        dc_date = Time.iso8601(item.elements["dc_date"].text)
        description = nil
        description = item.elements["description"].text if item.elements["description"]
        content_encoded = nil
        content_encoded = item.elements["content_encoded"].text if item.elements["content_encoded"]
        new_item = RSSItem.new(title,link,dc_date,description,content_encoded)
        $cached_items[url].push(new_item)
      }
    }
  end
end
