require 'gtk2'
require 'ruggregator/rss'

# global variable definition
$filters = Array.new
$filter_list = Gtk::ListStore.new(String)
$filter_selection = Gtk::TreeSelection.new

# $filters$filter_listνƱ
  
def add_filter(filter)
  $filters.push(filter)
  iter = $filter_list.append
  $filter_list.set_value(iter,0,filter.name)
end

def remove_filter_by_index(index)
  $filters.delete_at(index)
  path = Gtk::TreePath.new("#{index}")
  iter = $filter_list.get_iter(path)
  $filter_list.remove(iter)
end

def remove_filter_by_name(name)
  $filters.each_index{ |i|
    if $filters[i].name == name
      remove_filter_by_index(i)
    end
  }
end

def get_filter_by_name(name)
  $filters.each{ |filter|
    if filter.name == name
      return filter
    end
  }
  return nil
end

def selected_filter_name()
  if $filter_selection.selected != nil
    name = $filter_list.get_value($filter_selection.selected,0)
  else
    name = nil
  end
  return name
end

def selected_filter()
  name = selected_filter_name()
  return get_filter_by_name(name)
end

class Filter
  @name
  @rss_urls
  @key
  @rule
  @need_rearrangement
  @item_order

  ORDER_BY_TITLE = "title"
  ORDER_BY_DATE = "date"

  ASCENDING = "ascending"
  DESCENDING = "descending"
  
  def initialize(a_name, a_rss_urls = Array.new, a_key = ORDER_BY_DATE, a_rule = ASCENDING)
    @need_rearrangement = false
    if a_name == nil
      raise "Filter name must be set when instantiation of filter."
    end
    self.name = a_name
    @rss_urls = Array.new
    @item_order = Array.new
    a_rss_urls.each{ |url|
      self.add_rss(url)
    }
    self.key = a_key
    self.rule = a_rule
  end

  def add_rss(rss_url)
    @rss_urls.push(rss_url)
    @rss_urls.uniq!
    @need_rearrangement = true
  end

  def remove_rss(rss_url)
    @rss_urls.delete(rss_url)
    @need_rearrangement = true
  end

  def clear_rss()
    @rss_urls.clear
    @need_rearrangement = true
  end

  def rearrangement
    @item_order.clear
    @rss_urls.each{ |url|
      items = $rssfeeds.get_rss_by_url(url).items
      items.each_index{ |item_index|
        @item_order.push({"url" => url, "item_index" => item_index, ORDER_BY_TITLE => items[item_index].title, ORDER_BY_DATE => items[item_index].dc_date})
      }
    }
    @item_order.sort!{ |x,y|
      if @rule == ASCENDING
        x[@key] <=> y[@key]
      elsif @rule == DESCENDING
        y[@key] <=> x[@key]
      else
        x[@key] <=> y[@key]
      end
    }
    @need_rearrangement = false
  end
  private :rearrangement

  def rss_urls
    @rss_urls
  end

  def n_item
    rearrangement if @need_rearrangement
    
    return @item_order.size
  end

  def item index
    rearrangement if @need_rearrangement
    
    tmp = @item_order[index]
    url = tmp["url"]
    item_index = tmp["item_index"]
    return $rssfeeds.get_rss_by_url(url).items[item_index]
  end

  def channel index
    rearrangement if @need_rearrangement

    tmp = @item_order[index]
    url = tmp["url"]
    return $rssfeeds.get_rss_by_url(url).channel
  end

  def name
    return @name
  end

  def name=(a_name)
    raise "filter name is empty" if a_name.empty?

    if @name == a_name
      return @name
    end

    $filters.each{ |filter|
      if filter.name == a_name
        raise "#{a_name} exist. Duplication of the filter is forbidden."
      end
    }
    
    @name = a_name

    # update filter list
    index = $filters.index(self)
    if index
      path = Gtk::TreePath.new("#{index}")
      iter = $filter_list.get_iter(path)
      $filter_list.set_value(iter,0,@name)
    end
    return @name
  end

  def key
    return @key
  end

  def key=(a_key)
    return if @key == a_key

    @need_rearrangement = true
    case a_key
    when ORDER_BY_TITLE, ORDER_BY_DATE
      @key = a_key
    else
      raise "#{a_key} is an invalid key for ordering"
    end
    return @key
  end

  def rule
    return @rule
  end

  def rule=(a_rule)
    return if @rule == a_rule

    @need_rearrangement = true
    @rule = a_rule
    case a_rule
    when ASCENDING, DESCENDING
      @rule =a_rule
    else
      raise "#{a_rule} is an invalid order rule"
    end
    return @rule
  end
end
