require 'gtk2'
require 'ruggregator/filter'

include GetText
bindtextdomain("ruggregator")
GetText.charset = "UTF-8"

CHECK_COLUMN = 0
FILTER_TITLE_COLUMN = 1
URL_COLUMN = 2

class FilterDialog < Gtk::Dialog
  L10NED_ORDER_BY_TITLE = _("Title")
  L10NED_ORDER_BY_DATE = _("Date")

  L10NED_ASCENDING = _("Ascending")
  L10NED_DESCENDING = _("Descending")

  @name_entry
  @key_combo
  @rule_combo
  @filter_list

  def initialize
    super _("Filter"), nil, Gtk::Dialog::MODAL,
      [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT],
      [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT]

    hbox = Gtk::HBox.new
    label = Gtk::Label.new(_("Filter name") + ": ")
    hbox.pack_start(label,false,false,0)
    @name_entry = Gtk::Entry.new
    hbox.pack_start(@name_entry,true,true,0)
    vbox.pack_start(hbox,true,true,3)

    hbox = Gtk::HBox.new
    label = Gtk::Label.new(_("RSS") + ": ")
    hbox.pack_start(label,false,false,0)

    scrolled_window = Gtk::ScrolledWindow.new
    scrolled_window.set_policy(Gtk::POLICY_AUTOMATIC,Gtk::POLICY_AUTOMATIC);

    @filter_list = Gtk::ListStore.new(TrueClass,String,String)

    $rssfeeds.each{ |rssfeed|
      iter = @filter_list.append
      @filter_list.set_value(iter,CHECK_COLUMN,false)
      @filter_list.set_value(iter,FILTER_TITLE_COLUMN,rssfeed.title)
      @filter_list.set_value(iter,URL_COLUMN,rssfeed.url)
    }

    filter_list_view = Gtk::TreeView.new(@filter_list)
    filter_list_view.selection.mode = Gtk::SELECTION_SINGLE
    renderer = Gtk::CellRendererToggle.new
    renderer.signal_connect('toggled'){ |cell, path_str|
      # handle toggling check box
      path = Gtk::TreePath.new(path_str)
      iter = @filter_list.get_iter(path)
      pre = @filter_list.get_value(iter,CHECK_COLUMN)
      @filter_list.set_value(iter,CHECK_COLUMN,!pre)
    }
    column = Gtk::TreeViewColumn.new("", renderer, :active => CHECK_COLUMN)
    filter_list_view.append_column(column)

    renderer = Gtk::CellRendererText.new
    column = Gtk::TreeViewColumn.new(_("RSS Title"), renderer, :text => FILTER_TITLE_COLUMN)
    filter_list_view.append_column(column)

    renderer = Gtk::CellRendererText.new
    column = Gtk::TreeViewColumn.new(_("URL"), renderer, :text => URL_COLUMN)
    filter_list_view.append_column(column)

    scrolled_window.add_with_viewport(filter_list_view)
    scrolled_window.set_size_request(200,100)
    hbox.pack_start(scrolled_window,true,true,0)
    vbox.pack_start(hbox,true,true,3)

    hbox = Gtk::HBox.new
    label = Gtk::Label.new(_("Key for ordering") + ": ")
    hbox.pack_start(label,false,false,0)
    @key_combo = Gtk::Combo.new([L10NED_ORDER_BY_TITLE,L10NED_ORDER_BY_DATE])
    @key_combo.entry.text = L10NED_ORDER_BY_DATE
    @key_combo.entry.editable = false
    hbox.pack_start(@key_combo,true,true,0)
    vbox.pack_start(hbox,true,true,3)

    hbox = Gtk::HBox.new
    label = Gtk::Label.new(_("Order rule") + ": ")
    hbox.pack_start(label,false,false,0)
    @rule_combo = Gtk::Combo.new([L10NED_ASCENDING,L10NED_DESCENDING])
    @rule_combo.entry.text = L10NED_DESCENDING
    @rule_combo.entry.editable = false
    hbox.pack_start(@rule_combo,true,true,0)
    vbox.pack_start(hbox,true,true,3)

    show_all
  end

  def name
    return @name_entry.text
  end

  def name=(new_name)
    @name_entry.text = new_name
    return @name_entry.text
  end

  def key
    case @key_combo.entry.text
    when L10NED_ORDER_BY_TITLE
      return Filter::ORDER_BY_TITLE
    when L10NED_ORDER_BY_DATE
      return Filter::ORDER_BY_DATE
    end
    return Filter::ORDER_BY_DATE
  end

  def key=(new_key)
    case new_key
    when Filter::ORDER_BY_TITLE
      @key_combo.entry.text = L10NED_ORDER_BY_TITLE
    when Filter::ORDER_BY_DATE
      @key_combo.entry.text = L10NED_ORDER_BY_DATE
    else
      raise "Key for ordering must be #{ORDER_BY_TITLE} or #{ORDER_BY_DATE}"
    end
    return @key_combo.entry.text
  end

  def rule
    case @rule_combo.entry.text
    when L10NED_ASCENDING
      return Filter::ASCENDING
    when L10NED_DESCENDING
      return Filter::DESCENDING
    end
    return Filter::ASCENDING
  end

  def rule=(new_rule)
    case new_rule
    when Filter::ASCENDING
      @rule_combo.entry.text = L10NED_ASCENDING
    when Filter::DESCENDING
      @rule_combo.entry.text = L10NED_DESCENDING
    else
      raise "Order rule must be #{ASCENDING} or #{DESCENDING}"
    end
    return @rule_combo.entry.text
  end

  def selected_rss_urls
    ret = Array.new
    iter = @filter_list.iter_first
    return ret unless iter

    begin
      selected = @filter_list.get_value(iter,CHECK_COLUMN)
      url = @filter_list.get_value(iter,URL_COLUMN)
      ret.push(url) if selected
    end while iter.next!
    return ret
  end

  def select_rsses urls
    iter = @filter_list.iter_first
    return unless iter

    begin
      url = @filter_list.get_value(iter,URL_COLUMN)
      if urls.include?(url)
        @filter_list.set_value(iter,CHECK_COLUMN,true)
      else
        @filter_list.set_value(iter,CHECK_COLUMN,false)
      end
    end while iter.next!
  end
end
