require 'gtk2'

include GetText
bindtextdomain("ruggregator")
GetText.charset = "UTF-8"

class PreferencesDialog < Gtk::Dialog

  @url_handler_entry
  @date_format_entry

  def initialize
    super _("Preferences"), nil, Gtk::Dialog::MODAL,
      [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT],
      [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_REJECT]
    
    hbox = Gtk::HBox.new
    label = Gtk::Label.new(_("Command for link") + ": ")
    hbox.pack_start(label,false,false,0)
    @url_handler_entry = Gtk::Entry.new
    @url_handler_entry.text = $config["url-handler"]
    hbox.pack_start(@url_handler_entry,true,true,0)
    vbox.pack_start(hbox,true,true,3)

    hbox = Gtk::HBox.new
    label = Gtk::Label.new(_("Date format (see manpage of \"strftime(3)\")") + ": ")
    hbox.pack_start(label,false,false,0)
    @date_format_entry = Gtk::Entry.new
    @date_format_entry.text = $config["date-format"]
    hbox.pack_start(@date_format_entry,true,true,0)
    vbox.pack_start(hbox,true,true,3)

    show_all
  end

  def update_config
    $config["url-handler"] = @url_handler_entry.text
    $config["date-format"] = @date_format_entry.text
  end

end
