require 'rss/1.0'
require 'rss/2.0'
require 'rss/dublincore'
require 'rss/content'
require 'rss/maker'
require 'open-uri'
require 'ruggregator/window'

class RSSFeeds
  @feeds
  
  def initialize
    @feeds = Array.new
  end

  def add_rss new_feed
    return if new_feed == nil

    # check exclusivity of URL
    @feeds.each{ |feed|
      if feed.url == new_feed.url
        raise "#{new_feed.url} has been registered as another rsses."
      end
    }

    
    @feeds.push(new_feed)
  end

  def each
    @feeds.each{ |feed|
      yield feed
    }
  end

  def get_rss_by_url url
    @feeds.each{ |feed|
      if feed.url == url
        return feed
      end
    }

    # return nil if the specified URL has not been registered yet
    return nil
  end

  def remove_rss_by_url url
    @feeds.delete_if{ |feed|
      feed.url == url
    }

    $filters.each{ |filter|
      filter.remove_rss(url)
    }
  end
end # class RSSFeeds

$rssfeeds = RSSFeeds.new

class RSSItem
  @title
  @link
  @dc_date
  @description
  @content_encoded

  def initialize(a_title,a_link,a_dc_date,a_description,a_content_encoded)
    @title = a_title
    @link = a_link
    @dc_date = a_dc_date
    @description = a_description
    @content_encoded = a_content_encoded
  end

  attr_accessor :title, :link, :dc_date, :description, :content_encoded
end

class RSSFeed
  @rss
  @url
  @title
  @items
  
  def initialize(a_url, a_title = nil)
    if a_url == nil
      raise "URL must be set when instantiation of RSSFeed."
    end
    
    @url = a_url
    @title = a_title
    @rss = nil
    @items = nil
  end

  def url
    return @url
  end

  def title
    return @title if @title

    return rss.channel.title
  end

  def rss
    if @rss == nil
      rss_source = ""
      open(url){|f|
        rss_source = f.gets(nil)
      }

      # parse the rss file
      begin
        @rss = RSS::Parser.parse(rss_source,true)
      rescue RSS::InvalidRSSError
        @rss = RSS::Parser.parse(rss_source,false)
      end
    end

    return @rss
  end # def rss

  def items
    if @items == nil
      @items = Array.new
      rss.items.each{ |item|
        new_item = RSSItem.new(item.title,item.link,item.dc_date,item.description,item.content_encoded)
        cache_item(self.url,new_item)
      }
      
      cached_items(url).each{ |item|
        @items.push(item)
      }
    end

    return @items
  end # def items

  def channel
    return self.rss.channel
  end
end # class Filter
