require 'gtk2'
require 'rss/rss'
require 'ruggregator/rss_new_dialog'
require 'ruggregator/filter'

include GetText
bindtextdomain("ruggregator")
GetText.charset = "UTF-8"

RSS_TITLE_COLUMN = 0
RSS_URL_COLUMN = 1

class RSSDialog < Gtk::Dialog

  @rsslist
  
  def initialize
    super "RSS", nil, Gtk::Dialog::MODAL,
      [Gtk::Stock::OK, Gtk::Dialog::RESPONSE_ACCEPT]
      
    hbox = Gtk::HBox.new
    vbox.pack_start(hbox,true,true,0)
    
    scrolled_window = Gtk::ScrolledWindow.new
    scrolled_window.set_policy(Gtk::POLICY_AUTOMATIC,Gtk::POLICY_AUTOMATIC);

    @rsslist = Gtk::ListStore.new(String,String)
    $rssfeeds.each{ |feed|
      iter = @rsslist.append
      @rsslist.set_value(iter,RSS_TITLE_COLUMN,feed.title)
      @rsslist.set_value(iter,RSS_URL_COLUMN,feed.url)
    }

    rsslist_view = Gtk::TreeView.new(@rsslist)
    rsslist_view.selection.mode = Gtk::SELECTION_SINGLE

    renderer = Gtk::CellRendererText.new
    column = Gtk::TreeViewColumn.new(_("RSS Title"),renderer, :text => RSS_TITLE_COLUMN)
    rsslist_view.append_column(column)

    renderer = Gtk::CellRendererText.new
    column = Gtk::TreeViewColumn.new(_("URL"),renderer, :text => RSS_URL_COLUMN)
    rsslist_view.append_column(column)

    scrolled_window.add_with_viewport(rsslist_view)
    scrolled_window.set_size_request(300,200)
    hbox.pack_start(scrolled_window,true,true,5)

    bvbox = Gtk::VButtonBox.new
    bvbox.layout_style = Gtk::ButtonBox::START
    bvbox.spacing = 10
    hbox.pack_start(bvbox,false,false,5)

    button = Gtk::Button.new(_("New"))
    button.signal_connect("clicked"){
      dialog = RSSNewDialog.new
      dialog.run{ |response|
        if response == Gtk::Dialog::RESPONSE_ACCEPT
          new_rss = RSSFeed.new(dialog.url)
          $rssfeeds.add_rss(new_rss)
          iter = @rsslist.append
          @rsslist.set_value(iter,RSS_TITLE_COLUMN,new_rss.title)
          @rsslist.set_value(iter,RSS_URL_COLUMN,new_rss.url)

          if dialog.create_filter?
            new_filter = Filter.new(new_rss.title,
                                    [new_rss.url])
            add_filter(new_filter)
          end
        end
        dialog.destroy
      }
    }
    bvbox.pack_start_defaults(button)

    button = Gtk::Button.new(_("Remove"))
    selection = rsslist_view.selection
    button.signal_connect("clicked"){
      iter = selection.selected
      if iter
        url = @rsslist.get_value(iter,RSS_URL_COLUMN)
        $rssfeeds.remove_rss_by_url(url)
        @rsslist.remove(iter)
      end
    }
    bvbox.pack_start_defaults(button)

    show_all
  end
end
