#!/bin/sh
#
# 酢昆布 - SaMMA document CONVersion script
#
# $Revision: 1.4 $ 
# $Date: 2013/01/21 02:26:48 $

if [ $# -ne 5 ]; then
    echo "Usage: $0 basedir destdir Y M D"
    echo "(平成Y年M月D日)"
    exit 1
fi

# 変数
basedir="$1"     # コピー元
destdir="$2"     # コピー先
heisei="$3"      # 平成
month="$4"       # 月
day="$5"         # 日
write_flag="OFF" # 本文部分を示すフラグ 

# コピー先が存在したら終了
if [ -d "$destdir" ]; then
    echo "$destdir: exists."
    exit 2
else
    mkdir "$destdir"
fi

# ヘッダ/フッタファイルのチェック
if [ ! -r ./header ]
then
    echo "Cannot read header data."
    exit 3
fi 
if [ ! -r ./footer ]
then
    echo "Cannot read footer data."
    exit 3
fi 

# HTML以外をコピー
tar cf - -C "$basedir" . | tar xfp - -C "$destdir"
find "$destdir" -type f -name \*.html -exec rm -f {} \;

# 環境変数の設定
IFS=$'\n'

# HTMLをPHPにする
(cd "$basedir"; find . -type f -name \*.html) | while read file; do

    # PHPファイル名
    phpfile=`echo "$destdir/$file" | sed 's/\.html$/.php/'`

    #ヘッダを書き込み
    cat ./header > $phpfile

    # 本文を書き込み
    cat "$basedir/$file" | while read line
    do
        case $line in
        "<BODY >")
            write_flag="ON"
            continue;;
        "</BODY>")
            write_flag="OFF"
            ;;
        esac

        if [ $write_flag = "ON" ]
        then
            echo $line >> $phpfile
        fi
    done

    # フッタを書き込み
    cat ./footer >> $phpfile

    # 文字コード変換
    nkf -w --overwrite $phpfile

    # .htmlを.phpに変換/日付の追加
    sed -i -e "s/\.html/\.php/g;
               s/__DATE__/平成${heisei}年${month}月${day}日/;
               s/^<P>翻訳は.*実行されました。//;
               s/ NAME=/ ID=/g" $phpfile

done

exit 0
