#!/bin/sh
unset LANG

PROG=samma
TMPFILE=testmail
HOMEDIR=`pwd`
CONFDIR=/usr/local/etc/samma
PORT=25
HOST=localhost
RCPTDBTXT=${CONFDIR}/rcptdb.txt
RCPTDB=${CONFDIR}/rcpt.db
SENDDBTXT=${CONFDIR}/senderdb.txt
SENDDB=${CONFDIR}/sender.db
DBTYPE=hash
TMPLFILE=${CONFDIR}/samma.tmpl
TMPDIR=${HOMEDIR}/tmp/policytest/attach
TMPDIR2=${HOMEDIR}/tmp/policytest/source
PARSEMAIL=${HOMEDIR}/parsemail
XENCHEADER="X-SaMMA-Enc"
ADDRPASS1="address"
DOMPASS1="domain"
SUBPASS1="sub"
LDAPADDRPASS1="ldap-address"
LDAPDOMPASS1="ldap-domain"
LDAPSUBPASS1="ldap-sub"

debug()
{
    if [ $DEBUG == "ON" ];
    then
	echo "$1"
    fi
}

debug_command()
{
    if [ $DEBUG == "ON" ];
    then
	echo "COMMAND"
        echo $1
        echo "RESULT"
        echo "---------------------------------------------------------"
        echo "$2"
        echo "---------------------------------------------------------"
    fi
}

debug_exit()
{
    if [ $DEBUG == "ON" ];
    then
        exit
    fi
}

help()
{
less << EOM
usage: policy.sh [-d | -h] -f [pattern file]
       -d: debug mode
       -h: print help

================= Postfix setting =================
myhostname = samma.designet.co.jp
mydomain = designet.co.jp
inet_interfaces = all
mydestination = $myhostname,
                localhost.$mydomain,
                localhost,
                send1.designet.co.jp,
                send2.designet.co.jp,
                send3.designet.co.jp,
                send4.designet.co.jp,
                send5.designet.co.jp,
                send6.designet.co.jp,
                send7.designet.co.jp,
                rcpt1.designet.co.jp,
                rcpt2.designet.co.jp,
                rcpt3.designet.co.jp,
                rcpt4.designet.co.jp,
                rcpt5.designet.co.jp,
                rcpt6.designet.co.jp,
                sub.rcpt7.designet.co.jp,
                sub.rcpt8.designet.co.jp,
                sub.rcpt9.designet.co.jp,
                rcpt10.designet.co.jp,
                rcpt11.designet.co.jp,
                rcpt12.designet.co.jp,
                rcpt13.designet.co.jp,
                rcpt14.designet.co.jp,
                rcpt15.designet.co.jp,
                rcpt16.designet.co.jp,
                sub.rcpt17.designet.co.jp,
                sub.rcpt18.designet.co.jp,
                sub.rcpt19.designet.co.jp,
                samma.designet.co.jp
mynetworks = 192.168.0.0/16, 127.0.0.0/8
home_mailbox = Maildir/
smtpd_milters=inet:127.0.0.1:20026
milter_default_action = tempfail
milter_connect_timeout = 30s
milter_content_timeout = 300s
===================================================
EOM
}

usage()
{
    echo "usage: policy.sh [-d] -f [pattern file]"
    echo "       -d: debug mode"
}

set_sender()
{
    # set sender
    case $1 in
        [1-7])
            SENDER="send0$1@send$1.designet.co.jp"
            SUSER="send0$1"
        ;;
        2[1-7])
            LEARGE=`expr $1 - 20`
            SENDER="SEND0$LEARGE@SEND$LEARGE.DESIGNET.CO.JP"
            SUSER="send0$LEARGE"
        ;;
        4[1-7])
            MIX=`expr $1 - 40`
            SENDER="Send0$MIX@Send$MIX.DesigNET.co.jp"
            SUSER="send0$MIX"
        ;;
        *)
            echo "not found SENDER($1)"
        ;;
        esac
}

set_rcpt()
{
    # set rcpt
    case $1 in
        0)
            TMPRCPT=""
            TMPRUSER=""
        ;;
        # only small character
        [1-6])
            TMPRCPT="rcpt0$1@rcpt$1.designet.co.jp"
            TMPRUSER="rcpt0$1"
	;;
        [7-9])
            TMPRCPT="rcpt0$1@sub.rcpt$1.designet.co.jp"
            TMPRUSER="rcpt0$1"
        ;;
        10)
            TMPRCPT="rcpt10@rcpt10.designet.co.jp"
            TMPRUSER="rcpt10"
        ;;
        1[1-6])
            TMPRCPT="rcpt$1@rcpt$1.designet.co.jp"
            TMPRUSER="rcpt$1"
        ;;
        1[7-9])
            TMPRCPT="rcpt$1@sub.rcpt$1.designet.co.jp"
            TMPRUSER="rcpt$1"
        ;;
        # only learge character
        2[1-6])
            LEARGE_NUM=`expr $1 - 20`
            TMPRCPT="RCPT0$LEARGE_NUM@RCPT$LEARGE_NUM.DESIGNET.CO.JP"
            TMPRUSER="rcpt0$LEARGE_NUM"
        ;;
        2[7-9])
            LEARGE_NUM=`expr $1 - 20`
            TMPRCPT="RCPT0$LEARGE_NUM@SUB.RCPT$LEARGE_NUM.DESIGNET.CO.JP"
            TMPRUSER="rcpt0$LEARGE_NUM"
        ;;
        30)
            TMPRCPT="RCPT10@RCPT10.DESIGNET.CO.JP"
            TMPRUSER="rcpt10"
        ;;
        3[1-6])
            LEARGE_NUM=`expr $1 - 20`
            TMPRCPT="RCPT$LEARGE_NUM@RCPT$LEARGE_NUM.DESIGNET.CO.JP"
            TMPRUSER="rcpt$LEARGE_NUM"
        ;;
        3[7-9])
            LEARGE_NUM=`expr $1 - 20`
            TMPRCPT="RCPT$LEARGE_NUM@SUB.RCPT$LEARGE_NUM.DESIGNET.CO.JP"
            TMPRUSER="rcpt$LEARGE_NUM"
        ;;
        # mix character
        4[1-6])
            MIX_NUM=`expr $1 - 40`
            TMPRCPT="Rcpt0$MIX_NUM@Rcpt$MIX_NUM.DesigNET.co.jp"
            TMPRUSER="rcpt0$MIX_NUM"
        ;;
        4[7-9])
            MIX_NUM=`expr $1 - 40`
            TMPRCPT="Rcpt0$MIX_NUM@sub.Rcpt$MIX_NUM.DesigNET.co.jp"
            TMPRUSER="rcpt0$MIX_NUM"
        ;;
        50)
            TMPRCPT="Rcpt10@Rcpt10.DesigNET.co.jp"
            TMPRUSER="rcpt10"
        ;;
        5[1-6])
            MIX_NUM=`expr $1 - 40`
            TMPRCPT="Rcpt$MIX_NUM@Rcpt$MIX_NUM.DesigNET.co.jp"
            TMPRUSER="rcpt$MIX_NUM"
        ;;
        5[7-9])
            MIX_NUM=`expr $1 - 40`
            TMPRCPT="Rcpt$MIX_NUM@sub.Rcpt$MIX_NUM.DesigNET.co.jp"
            TMPRUSER="rcpt$MIX_NUM"
        ;;
        *)
            echo "not found RCPT($1)"
        ;;
        esac
}

make_mail()
{
    cat header > ${TMPFILE}

    if [ $1 -eq 0 ] && [ $2 -eq 0 ] && [ $3 -eq 0 ];
    then
        echo "" >> ${TMPFILE}
        cat body >> ${TMPFILE}
    else
        cat multiheader >> ${TMPFILE}
        echo "" >> ${TMPFILE}
        cat multibody >> ${TMPFILE}
    fi

    set_file $1
    set_file $2
    set_file $3

    if [ $1 -eq 0 -a $2 -eq 0 -a $3 -eq 0 ];
    then
        echo "." >> ${TMPFILE}
    else
        cat multifooter >> ${TMPFILE}
        echo "." >> ${TMPFILE}
    fi
}

set_file()
{
    # set attach file
    case $1 in
        0)
        ;;
        1)
            cat ${HOMEDIR}/PMSG/test1.txt >> ${TMPFILE}
        ;;
        2)
            cat ${HOMEDIR}/PMSG/test2.txt >> ${TMPFILE}
        ;;
        *)
            echo "not found FILE($1)"
	    #exit
        ;;
        esac
}

sender_check_mail()
{
    case $1 in
        0)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -eq 0 ];
            then
                echo "sender check error"
                echo "==============RETRY================"
                sleep 1
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -eq 0 ];
            then
                echo "sender check error123"
            fi
            fi
        ;;
        1)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                echo "sender check error"
                echo "=================???RETRY???==================="
                sleep 1
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                echo "sender check error"
            fi
            fi
            ONETIMEPASS=`/bin/grep PassWord: /home/$2/Maildir/new/* | cut -d " " -f 2`
        ;;
        *)
            echo "not found SENDER RETCODE($1)"
        ;;
        esac
}

rcpt_check_mail()
{
    case $1 in
        0)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -eq 0 ];
            then
                echo "rcpt check error(1)"
                echo "==========++retry++============="
                sleep 1
                /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
                if [ $? -eq 0 ];
                then
                    echo "rcpt check error(1)"
                fi
            fi
        ;;
        1)
            check_enc_mail $2 ${ADDRPASS1} $3 $4 $5
        ;;
        2)
            check_enc_mail $2 ${DOMPASS1} $3 $4 $5
        ;;
        3)
            check_enc_mail $2 ${SUBPASS1} $3 $4 $5
        ;;
        4)
            check_enc_mail $2 ${ONETIMEPASS} $3 $4 $5
        ;;
        5)
            /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                echo "rcpt check error(1)"
                echo "==========**retry**============="
                sleep 1
                /bin/ls /home/$2/Maildir/new/* > /dev/null 2>&1
                if [ $? -ne 0 ];
                then
                    echo "rcpt check error(1)"
                fi
            fi
        ;;
        6)
            check_enc_mail $2 ${LDAPADDRPASS1} $3 $4 $5
        ;;
        7)
            check_enc_mail $2 ${LDAPDOMPASS1} $3 $4 $5
        ;;
        8)
            check_enc_mail $2 ${LDAPSUBPASS1} $3 $4 $5
        ;;
        *)
            echo "not found RCPT RETCODE($1)"
            exit
        ;;
        esac
}

check_enc_mail()
{
    MAILPATH=`/bin/ls /home/$1/Maildir/new/*` 2>&1
    if [ $? -ne 0 ];
    then
        echo "rcpt check error(1: mail error)"
        sleep 1
        echo "====================!!!!!RETRY!!!!!======================"

        MAILPATH=`/bin/ls /home/$1/Maildir/new/*` 2>&1
        if [ $? -ne 0 ];
        then
            echo "rcpt check error(1: mail error)"
            sleep 1

        fi
    fi

    /bin/grep ${XENCHEADER} ${MAILPATH} > /dev/null 2>&1
    if [ $? -ne 0 ];
    then
        echo "rcpt check error(2: header error)"
    fi

    ${PARSEMAIL} ${MAILPATH} ${TMPDIR} > /dev/null 2>&1
    ATTACHFILE=`/bin/ls ${TMPDIR}/*` 2>&1
    if [ $? -ne 0 ];
    then
        echo "rcpt check error(2: attach file error)"
    fi

    MSG=`/usr/bin/unzip -P $2 -d ${TMPDIR2} ${ATTACHFILE} 2>&1`
    RETNO=$?
    debug_command "/usr/bin/unzip -P $2 -d ${TMPDIR2} ${ATTACHFILE}" "$MSG"
    if [ $RETNO -ne 0 ];
    then
        echo "rcpt check error(Cannot unzip attache file: $1)"
	debug_exit
    fi

    TMPNUM=0
    ATTNUM=`/bin/ls ${TMPDIR2} | wc -l` 2>&1
    if [ $3 -ne 0 ];
    then
        TMPNUM=1
    fi
    if [ $4 -ne 0 ];
    then
        TMPNUM=`expr ${TMPNUM} + 1` 2>&1
    fi
    if [ $5 -ne 0 ];
    then
        TMPNUM=`expr ${TMPNUM} + 1` 2>&1
    fi
    if [ ${ATTNUM} -ne ${TMPNUM} ];
    then
        echo "rcpt check error(3: attac file num error)"
    fi

    check_file $3
    check_file $4
    check_file $5

    /bin/rm -f ${TMPDIR}/*
    /bin/rm -f ${TMPDIR2}/*
}

check_file()
{
    FILE1=${HOMEDIR}/ORG/test1.txt
    FILE2=${HOMEDIR}/ORG/test2.txt
    case $1 in
        0)
        ;;
        1)
            /usr/bin/diff ${FILE1} ${TMPDIR2}/test1.txt > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                /usr/bin/diff ${FILE1} ${TMPDIR2}/test1\(1\).txt > /dev/null 2>&1
                if [ $? -ne 0 ];
                then
                    /usr/bin/diff ${FILE1} ${TMPDIR2}/test1\(2\).txt > /dev/null 2>&1
                    if [ $? -ne 0 ];
                    then
            		/usr/bin/diff ${FILE1} ${TMPDIR2}/test1\(3\).txt > /dev/null 2>&1
            		if [ $? -ne 0 ];
            		then
			    echo "check file error"
            		fi
		    fi
		fi
	    fi
        ;;
        2)
            /usr/bin/diff ${FILE2} ${TMPDIR2}/test2.txt > /dev/null 2>&1
            if [ $? -ne 0 ];
            then
                /usr/bin/diff ${FILE2} ${TMPDIR2}/test2\(1\).txt > /dev/null 2>&1
                if [ $? -ne 0 ];
                then
                    /usr/bin/diff ${FILE2} ${TMPDIR2}/test2\(2\).txt > /dev/null 2>&1
                    if [ $? -ne 0 ];
                    then
            		/usr/bin/diff ${FILE2} ${TMPDIR2}/test2\(3\).txt > /dev/null 2>&1
            		if [ $? -ne 0 ];
            		then
			    echo "check file error"
            		fi
		    fi
		fi
	    fi
        ;;
        *)
            echo "not found FILE($1)"
        ;;
        esac
}

##########################################################################
# init
##########################################################################
DEBUG=OFF
PTNFILE=""
while getopts dhf: opt
do
    case ${opt} in
    d)
	DEBUG=ON
    ;;
    f)
	PTNFILE=$OPTARG
    ;;
    h)
	help
	exit
    ;;
    \?)
	usage
	exit 1
    ;;
    esac
done

if [ `/usr/bin/id -u` -ne 0 ];
then
    echo "Please execute by \"root\" user."
    exit
fi

if [ ! -f $PARSEMAIL ];
then
    echo "Cannot found parsemail.($PARSEMAIL)"
    exit 
fi

$PARSEMAIL > /dev/null 2>&1
if [ $? -ne 0 ];
then
    echo "Cannot exec parsemail.($PARSEMAIL)"
    exit 
fi

if [ a$PTNFILE == "a" ];
then
    usage
    exit
fi

if [ ! -f $PTNFILE ];
then
    echo "invalid pattern file($PTNFILE)"
    exit
fi

# 桼Ѱ
for USER in send01 send02 send03 send04 send05 send06 send07 rcpt01 rcpt02 rcpt03 rcpt04 rcpt05 rcpt06 rcpt07 rcpt08 rcpt09 rcpt10 rcpt11 rcpt12 rcpt13 rcpt14 rcpt15 rcpt16 rcpt17 rcpt18 rcpt19
do
    /bin/grep $USER: /etc/passwd > /dev/null 2>&1
    if [ $? -ne 0 ];
    then
        /usr/sbin/useradd $USER > /dev/null 2>&1
    fi
done

echo "send01@send1.designet.co.jp" > ${SENDDBTXT}
echo "!send02@send2.designet.co.jp" >> ${SENDDBTXT}
echo "@send3.designet.co.jp" >> ${SENDDBTXT}
echo "!@send4.designet.co.jp" >> ${SENDDBTXT}
echo "send5.designet.co.jp" >> ${SENDDBTXT}
echo "!send6.designet.co.jp" >> ${SENDDBTXT}
if [ -f ${SENDDB} ];
then
    /bin/mv ${SENDDB} ${SENDDB}.bak
fi
/usr/sbin/makemap -e ${DBTYPE} ${SENDDB} < ${SENDDBTXT}
if [ $? -ne 0 ];
then
    echo "make sender db faild"
    exit 1
fi

echo "rcpt01@rcpt1.designet.co.jp address" > ${RCPTDBTXT}
echo "rcpt02@rcpt2.designet.co.jp" >> ${RCPTDBTXT}
echo "!rcpt03@rcpt3.designet.co.jp" >> ${RCPTDBTXT}
echo "@rcpt4.designet.co.jp domain" >> ${RCPTDBTXT}
echo "@rcpt5.designet.co.jp" >> ${RCPTDBTXT}
echo "!@rcpt6.designet.co.jp" >> ${RCPTDBTXT}
echo "rcpt7.designet.co.jp sub" >> ${RCPTDBTXT}
echo "rcpt8.designet.co.jp" >> ${RCPTDBTXT}
echo "!rcpt9.designet.co.jp" >> ${RCPTDBTXT}
if [ -f ${RCPTDB} ];
then
    /bin/mv ${RCPTDB} ${RCPTDB}.bak
fi
/usr/sbin/makemap -e ${DBTYPE} ${RCPTDB} < ${RCPTDBTXT}
if [ $? -ne 0 ];
then
    echo "make rcpt db faild"
    exit 1
fi

if [ -f ${TMPLFILE} ];
then
    mv ${TMPLFILE} ${TMPLFILE}.bak
fi

which expect > /dev/null 2>&1
if [ $? -ne 0 ];
then
    echo "Cannot found expect"
    exit 1
fi

echo "PassWord: <@@PASSWORD@@>" > ${TMPLFILE}
./reload.expect > /dev/null 2>&1
sleep 1

if [ ! -d ${TMPDIR} ];
then
    /bin/mkdir -p ${TMPDIR}
fi
if [ ! -d ${TMPDIR2} ];
then
    /bin/mkdir -p ${TMPDIR2}
fi

##########################################################################
# main
##########################################################################
cat $PTNFILE | while read P S R1 R2 R3 F1 F2 F3 RS RR1 RR2 RR3
do
    echo $P $S $R1 $R2 $R3 $F1 $F2 $F3 $RS $RR1 $RR2 $RR3

    # set sender and recipient
    set_sender ${S}
    set_rcpt ${R1}
    RCPT1=${TMPRCPT}
    RUSER1=${TMPRUSER}
    set_rcpt ${R2}
    RCPT2=${TMPRCPT}
    RUSER2=${TMPRUSER}
    set_rcpt ${R3}
    RCPT3=${TMPRCPT}
    RUSER3=${TMPRUSER}

    # make mail
    make_mail ${F1} ${F2} ${F3}

    # set mail
    cp ${TMPFILE} ${HOMEDIR}/virus.txt

    # remove mail
    /bin/rm -f /home/*/Maildir/new/*
    # remove attach file
    /bin/rm -rf ${TMPDIR}/*
    /bin/rm -rf ${TMPDIR2}/*

    # send mail
    ${HOMEDIR}/rlytest -f ${SENDER} -p ${PORT} ${HOST} ${RCPT1} ${RCPT2} ${RCPT3} > /dev/null 2>&1
    debug "${HOMEDIR}/rlytest -f ${SENDER} -p ${PORT} ${HOST} ${RCPT1} ${RCPT2} ${RCPT3}"

    if [ $? -ne 0 ];
    then
        echo "send mail error"
    fi

    sleep 1

    ######################################################################
    # check
    ######################################################################
    debug "---------- sender check ---------"
    sender_check_mail $RS $SUSER
    debug "----------  sender end  ---------"
    debug "---------- rcpt1 check ---------"
    rcpt_check_mail $RR1 $RUSER1 ${F1} ${F2} ${F3}
    debug "---------- rcpt1 check ---------"
    debug "---------- rcpt2 check ---------"
    rcpt_check_mail $RR2 $RUSER2 ${F1} ${F2} ${F3}
    debug "---------- rcpt2 check ---------"
    debug "---------- rcpt3 check ---------"
    rcpt_check_mail $RR3 $RUSER3 ${F1} ${F2} ${F3} 
    debug "---------- rcpt3 check ---------"
done

######################################################################
# shutdown
######################################################################
/bin/mv ${TMPLFILE}.bak ${TMPLFILE}
/bin/mv ${RCPTDB}.bak ${RCPTDB}
/bin/mv ${SENDDB}.bak ${SENDDB}
/bin/rm -rf ${TMPDIR}
/bin/rm -rf ${TMPDIR2}
