<?php

	require('dbutil.php');	
	
	define('DEFENCE_AREA', 600);
	define('MAP_MAX', 3600);
	define('MAP_UP', -60);
	define('MAP_DOWN', 60);
	define('MAP_LEFT', -1);
	define('MAP_RIGHT', +1);
	define('MAP_LEFTUP', -61);
	define('MAP_RIGHTUP', -59);
	define('MAP_LEFTDOWN', 59);
	define('MAP_RIGHTDOWN', 61);
	
	function aiAction($roomid){
	
		$db = new DBConnection();
		$session = new DBSession($db);
		$db->AssignDBConnection($session);
		
		// 処理対象AI取得
		$sql = 'select userID, countryID, mapChipNo, charKbn from t_battle where roomID=:roomID and charKbn<>:charKbn and exclusionKbn=0';
		$param = array(":roomID" => "$roomid", ":charKbn" => 'U');
		
		$result = $session->query_select($sql, $param);
		
		// 総大将位置取得
		$sql = 'select countryID, mapChipNo from t_battle where roomID=:roomID and charKbn:=charKbn';
		$param = array(":roomID" => "$roomID", ":charKbn" => "S");
		$king = $session->query_select($sql, $param);
				
		foreach($result as $row) {
		
			$userID = $result[0];
			$countryID = $result[1];
			$mapChipNo = $result[2];
			$charKgn = $result[3];
			
			// 近くに敵がいた場合、攻撃
			$sql = 'select mapChipNo from t_battle where roomID=:roomID and countryID<>:countryID and mapChipNo in (:map1, :map2, map3, map4, map5, map6, map7, map8) order by power';
			$param = array(":roomID" => "$roomID", ":countryID" => "$countryID",
						":map1" => $mapChipNo + MAP_LEFTUP, ":map2" => $mapChipNo + MAP_UP, ":map3" => $mapChipNo + MAP_RIGHTUP,
						 ":map4" => $mapChipNo + MAP_LEFT, ":map5" => $mapChipNo + MAP_RIGHT, ":map6" => $mapChipNo + MAP_LEFTDOWN,
						 ":map7" => $mapChipNo + MAP_DOWN, ":map8" => $mapChipNo + MAP_RIGHTDOWN);
		
			$result = $session->query_select($sql, $param);
		
			if (!empty($result)){
					
				$battleCommandID = 1;
						
				$sql_insert_uaction = 'insert into t_userAction (userID, roomID, battleCommandID, battleMapChipNo, lastUpdateDate) values (:userID, :roomID, :battleCommandID, :battleMapChipNo, now())';
				$param_insert_uaction = array(":userID" => "$userID", ":roomID" => "$roomid", ":battleCommandID" => "$battleCommandID", ":battleMapChipNo" => " $result[0][0]");
						
				$result_insert_uaction = $session->query_update($sql_insert_uaction, $param_insert_uaction);
					
			} elseif ($charKgn == 'B') {
				// 武将のみの行動 とりあえず、IDが奇数が攻撃型、偶数が守備型に
				if(($useID % 2) == 1){
					// 攻撃型
					// 敵国の総大将のマップチップNo取得
					if($king[0][0] <> $countryID){
					
						$targetmapchipno = $king[0][1];
						
					} else {
					
						$targetmapchipno = $king[1][1];
					
					}
				} else {
				
					// 守備型
					// 自国の総大将のマップチップNo取得
					if($king[0][0] == $countryID){
					
						$kingmapchipno = $king[0][1];
					
					} else {
					
						$kingmapchipno = $king[1][1];
					
					}
					
					// 自国の防衛範囲の最深部にいる敵マップチップを取得
					if($kingmapchipno < (MAP_MAX / 2)){
					
						$defencearea = DEFENCE_AREA;
						$sql_search_enemy = 'select mapChipNo from t_battle where roomID=:roomID and countryID<>:countryID and mapChipNo < :mapChipNo order by mapChipNo';
					
					} else {

						$defencearea = MAP_MAX - DEFENCE_AREA;
						$sql_search_enemy = 'select mapChipNo from t_battle where roomID=:roomID and countryID<>:countryID and mapChipNo > :mapChipNo order by mapChipNo desc';
					
					}
					
					$param_search_enemy = array(":userID" => "$userID", ":roomID" => "$roomID", ":countryID" => "$countryID", ":mapChipNo" => "$defencearea");
					$result_search_enemy = $session->query_select($sql_search_enemy, $param_search_enemy);
					
					if (!empty($result_search_enemy)){
					
						$targetmapchipno = $result_search_enemy[0][0];
					
					} else {
					
						$targetmapchipno = '';
					
					}
				
				}
				
				// 移動先マップチップ設定
				if (!empty($targetmapchipno)) {
					// マップ縦位置比較
					$mapChipRow = floor($mapChipNo / 60);
					$targetmapchiprow = floor($targetmapchipno / 60);
					
					if ($mapChipRow < $targetmapchiprow) {
					
						$moveMapChipNo = $mapChipRow + MAP_UP;
					
					} elseif ($mapChipRow > $targetmapchiprow){
					
						$moveMapChipNo = $mapChipRow + MAP_DOWN;
					
					} else {
					
						// マップ横位置比較
						if($mapChipNo < $targetmapchipno) {
						
							$moveMapChipNo = $mapChipNo + MAP_RIGHT;
							
						} elseif ($mapChipNo > $targetmapchipno) {
						
							$moveMapChipNo = $mapChipNo + MAP_LEFT;
						
						}
					}
				} else {
				
					$moveMapChipNo = $mapChipNo;
				
				}
				
				$sql_insert_uaction = 'insert into t_userAction (userID, roomID, moveMapChipNo, lastUpdateDate) values (:userID, :roomID, :moveMapChipNo, now())';
				$param_insert_uaction = array(":userID" => "$userID", ":roomID" => "$roomid", ":moveMapChipNo" => "$moveMapChipNo");
						
				$result_insert_uaction = $session->query_update($sql_insert_uaction, $param_insert_uaction);
				
			}
		
		}
	
	}
