<?php

	function userIDCheck($uid) {


		if (strlen($uid) <> USERID_CNT) {
			throw new Exception('00100', SYSTEM_ERROR);
		}

		if (substr($uid, 0, 1) <> USERID_PREFIX) {
			throw new Exception('00101', SYSTEM_ERROR);
		}
		
		return $uid;

	}

	function roomIDCheck($rid) {

		if (! is_numeric($rid)) {
			throw new Exception('00200', SYSTEM_ERROR);
		}

		return $rid;

	}
	
	function sessionCheck($cmd, $uid, $sid) {
		
		require('sessionException.php');

		switch($cmd) {
		
			case 'xxxxx':
				$db = new DBConnection();
				$session = new DBSession($db);
				$db->AssignDBConnection($session);
	
				$uid = userIDCheck($uid);
		
				$sql = 'select userID from t_login where userID = :userID and sessionID = :sessionID';
				$param = array(":userID" => "$uid",
						":sessionID" => "$sid");
		
				$result = $session->query_select($sql, $param);
		
				if (empty($result)) {
		
					throw new sessionException('セッション違い', SESSION_ERROR);
		
				}
		}
	
	}

