<?php

	require('checkLib.php');
	require('sysparam.inc');
	require('dbutil.php');	
	
	try {

		$comNo = substr($_POST['data'], 0, 6);
//		$comNo = substr($_GET['data'], 0, 6);

		$userID = $_POST['userid'];
		$sessionID = $_POST['sessionid'];

		switch ($comNo) {
		
			// 新規ユーザ登録
			case 'U01001':
				require('entryNewUser.php');
				$result = commandExecute($sessionID);
				break;
				
			// 既存ユーザログイン
			case 'U01002':
				require('login.php');
				$result = commandExecute($sessionID);
				break;
			
			// 所属国設定要求
			case 'C01001':
				require('');
				break;

			// 所属国の一覧要求
			case 'C01002':
				sessionCheck($comNo, $userID, $sessionID);
				
				require('getcountry.php');
				$result = commandExecute();
				break;

			// ユーザの初期パラメータ要求
			case 'U01003':
				sessionCheck($comNo,$userID, $sessionID);
			
				require('getIniUserParam.php');
				$result = commandExecute();
				break;

			// ユーザの初期MAP位置設定要求
			case 'U01004':
				require('');
				break;

			// ユーザステータス要求
			case 'U01005':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('getUserStatus.php');
				$result = commandExecute();
				break;

			// AI武将パラメータ要求
			case 'A01001':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('getAICharParam.php');
				$result = commandExecute();
				break;

			// ルーム情報要求
			case 'R01001':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('getRoomInfo.php');
				$result = commandExecute();
				break;

			// ルーム入室要求
			case 'R01003':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('setUserEntryRoom.php');
				commandExecute();
				break;

			// ルーム退室要求
			case 'R01004':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('setUserExitRoom.php');
				commandExecute();
				break;

			// ルームターンカウント要求
			case 'R01005':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('getRoomTurnCount.php');
				$result = commandExecute();
				break;

			// マップ情報要求
			case 'M01001':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('getMapInfo.php');
				$result = commandExecute();
				break;

			// 戦闘情報送信
			case 'B01001':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('setBattleInfo.php');
				commandExecute();
				break;

			// 戦闘結果要求
			case 'B01002':
				sessionCheck($comNo, $userID, $sessionID);
			
				require('getBattleResult.php');
				$result = commandExecute();
				break;

			// コマンドエラー(対応コマンドがない)
			default:
				throw new Exception('0000001', SYSTEM_ERROR);

		}

		echo $comNo . SP . CMD_OK . SP . $sessionID .($result ? RLF . $result : "");
		
	} catch (sessionException $e) {
		echo $comNo . SP . CMD_ERR . RLF . SESSION_ERROR;
	} catch (Exception $e) {
		if ($e->getCode() == SYSTEM_ERROR) {
			echo $comNo . SP . CMD_ERR . RLF . $e->getMessage();
		} else {
			// 不明なエラー扱い
			echo $comNo . SP . CMD_ERR . RLF . UNKNOWN_ERROR;
		}
	}

?>
