<?php

	function commandExecute() {

		try {

			$uid = userIDCheck($_POST['userid']);
			$rid = roomIDCheck($_POST['roomid']);

//			$uid = userIDCheck($_GET['userid']);
//			$rid = roomIDCheck($_GET['roomid']);


			$db = new DBConnection();
			$session = new DBSession($db);
			$db->AssignDBConnection($session);

			$sql = 'select exclusionKbn from t_battle where userID = :userID and roomID = :roomID';
			$pa = array(":userID" => "$uid", ":roomID" => "$rid");
			$result = $session->query_select($sql, $pa);

			if (! empty($result)) {
				throw new Exception('0080001', SYSTEM_ERROR);
			}

			//ユーザ情報を取ってくる

			$sql = 'select u.userName, u.country, d.power, d.mobility from t_defaultParam d, t_user u where u.userID = :userID and u.paramID = d.paramID';
			$pa = array(":userID" => "$uid");
			$result = $session->query_select($sql, $pa);

			if (empty($result)) {
				throw new Exception('0080002', SYSTEM_ERROR);
			} else {
				foreach($result as $row) {
					$userName =  $row['userName'];
					$countryID =  $row['country'];
					$power = $row['power'];
					$mobility =  $row['mobility'];
				}
			}
 
			$umapNo = getUserMapNo(getUserType($session, $rid, $countryID));

 			// 乱数なので同じ値にならないことを前提→後で直す
			$bid = makeBattleID();

			$sql = "insert into t_battle values (:bid, :rid, :uid, :userName, :countryID, :userKbn, :umapNo, :power, :mobility, :exclusionKbn, now())";
			$pa = array(
						":bid" => "$bid", 
						":rid" => "$rid", 
						":uid" => "$uid", 
						":userName" => "$userName", 
						":countryID" => "$countryID", 
						":userKbn" => USER_KBN, 
						":umapNo" => "$umapNo", 
						":power" => "$power", 
						":mobility" => "$mobility", 
						":exclusionKbn" => "0");

			$result = $session->query_update($sql, $pa);

			if ($result == 0) {
				throw new Exception('0080003', SYSTEM_ERROR);
			}

		} catch(PDOException $e){
			throw new Exception('50000', SYSTEM_ERROR);
		} catch (Exception $e){ 
			if ($e->getCode() == SYSTEM_ERROR) {
				throw $e;
			} else {
				throw new Exception('00002', SYSTEM_ERROR);
			}
		}
	}


	function makeBattleID() {

		$bid = 0;

		for ($i = 0 ; $i < 8 ; $i++){
			$bid = $bid . mt_rand(0, 9);
		}

		return $bid;
	
	}


	function getUserType($s, $roomID, $countryID) {
	
		$sql = 'select offenseCountry, defenseCountry from t_room where roomID = :roomID';
		$pa = array(":roomID" => "$roomID");
		$result = $s->query_select($sql, $pa);

		if (empty($result)) {
			throw new Exception('0080004', SYSTEM_ERROR);
		} else {
			foreach($result as $row) {
				$offense =  $row['offenseCountry'];
				$defense =  $row['defenseCountry'];
			}
		}
		
		switch ($countryID) {
			case $offense:
				$utype = OFF_TYPE;
				break;
			case $defense:
				$utype = DEF_TYPE;
				break;
			default :
				throw new Exception('0080005', SYSTEM_ERROR);
		}
		
		return $utype;
		
	}


	function getUserMapNo($utype) {

		$initMap = ($utype == OFF_TYPE) ? unserialize(OFF_INIT) : unserialize(DEF_INIT);
		return $initMap[mt_rand(0, count($initMap))];

	}

