<?php

	require('dbutil.php');
	require('sysparam.inc');

	try {

		$db = new DBConnection();
		$session = new DBSession($db);
		$db->AssignDBConnection($session);

		$sql = 'select roomID, receiptTime, turnInterval, gameInterval, timerStatus, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > turnInterval, 1, 0) as timeover, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > gameInterval, 1, 0) as gamestart from t_turnTimer where roomID = 1';
		$sql .= ' union select roomID, receiptTime, turnInterval, gameInterval, timerStatus, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > turnInterval, 1, 0) as timeover, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > gameInterval, 1, 0) as gamestart from t_turnTimer where roomID = 2';
		$sql .= ' union select roomID, receiptTime, turnInterval, gameInterval, timerStatus, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > turnInterval, 1, 0) as timeover, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > gameInterval, 1, 0) as gamestart from t_turnTimer where roomID = 3';
		$sql .= ' union select roomID, receiptTime, turnInterval, gameInterval, timerStatus, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > turnInterval, 1, 0) as timeover, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > gameInterval, 1, 0) as gamestart from t_turnTimer where roomID = 4';
		$sql .= ' union select roomID, receiptTime, turnInterval, gameInterval, timerStatus, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > turnInterval, 1, 0) as timeover, if(sum(unix_timestamp(now())-unix_timestamp(receiptTime)) > gameInterval, 1, 0) as gamestart from t_turnTimer where roomID = 5';

		$result = $session->query_select($sql, $pa);

		if (empty($result)) {
			throw new Exception('00502', SYSTEM_ERROR);
		} else {
			foreach($result as $row) {
				$rid =  $row['roomID'];
				$rtime =  $row['receiptTime'];
				$tinterval =  $row['turnInterval'];
				$ginterval =  $row['gameInterval'];
				$tstatus = $row['timerStatus'];
				$tover = $row['timeover'];
				$gstart = $row['gamestart'];

				switch($tstatus){
					case 0 :
//						if ($gstart == OVERTIME) {
							if (checkUser($session, $rid)){

//								setNewGameReset($session, $rid);
//								setNewTurnReset($session, $rid);
//								setNewReceipt($session, 0, $rid);
//								clsRoomTurnCount($session,$rid);
//								roomRrecruit($session, $rid, 2);
								// 次のAIを決める
//								setAIchar($session, $rid);
							} else {
								setNewReceipt($session, 3, $rid);
							}
//						}
						break;
					case 1 :
						// 受付
						if ($tover == OVERTIME) {

							// 受付を終了フラグをたてる
							changeStatus($session, 2, $rid);

							// 更新中のデータがあるかもしれないので念のため少し待機
							sleep(5);

							// 計算ロジックを実行する 
							if (battlecalculate($session, $rid)) {
								// 次のゲーム開始状態にする
								setNewTurnReset($session, $rid);
								setNewReceipt($session, 4, $rid);

								// 一旦募集はやらない
								roomRrecruit($session, $rid, 1);
							} else {
								setNewTurnReset($session,$rid);

//								require('AI.php');
//								aiAction($rid);

								addRoomTurnCount($session,$rid);
								// 新しい時間をセットする 受付中にする
								setNewReceipt($session, 1, $rid);
							}
						}
						break;
					case 3 :
						if ($gstart == OVERTIME) {
							setNewReceipt($session, 1, $rid);
						}

						break;
					case 4 :
						if ($gstart == OVERTIME) {
							setNewGameReset($session, $rid);
							setNewTurnReset($session, $rid);
							roomRrecruit($session, $rid, 2);
							clsRoomTurnCount($session,$rid);
							setAIchar($session, $rid);

							setNewReceipt($session, 0, $rid);
						}
						break;

					default:
				
				}

			}
		}


	} catch(PDOException $e){
		throw new Exception('50000', SYSTEM_ERROR);
	} catch (Exception $e){ 
		throw new Exception('00002', SYSTEM_ERROR);
	}

	function checkUser($session, $rid) {

		$sql = "select battleID from t_battle where roomID = :roomID and charKbn = '" . USER_KBN ."'";
		$pa = array(":roomID" => $rid);
		$result = $session->query_update($sql, $pa);

		return empty($result);

	}

	function changeStatus($session, $status, $rid) {

		$sql = "update t_turnTimer set timerStatus = :status where roomID = :roomID";
		$pa = array(":status" => $status, ":roomID" => $rid);

		$result = $session->query_update($sql, $pa);

		if ($result == 0) {
			throw new Exception('0090001', SYSTEM_ERROR);
		}

	}

	function setNewReceipt($session, $status, $rid) {

		$sql = "update t_turnTimer set receiptTime = now(), timerStatus = :status where roomID = :roomID";
		$pa = array(":status" => $status, ":roomID" => $rid);

		$result = $session->query_update($sql, $pa);

		if ($result == 0) {
			throw new Exception('0090002', SYSTEM_ERROR);
		}

	}

	function setNewTurnReset($session, $rid) {

		$sql = "delete from t_userAction where roomID = :roomID";
		$pa = array(":roomID" => "$rid");

		$result = $session->query_update($sql, $pa);

	}

	function setNewGameReset($session, $rid) {

		$sql = "delete from t_battle where roomID = :roomID";
		$pa = array(":roomID" => "$rid" );

		$result = $session->query_update($sql, $pa);

	}

	function roomRrecruit($session, $rid, $recruit) {

		$sql = 'update t_room set roomStatus = :roomStatus, lastUpdateDate = now() where roomID = :roomID';
		$pa = array( ":roomStatus" => $recruit, ":roomID" => $rid);
		$result_uid = $session->query_select($sql, $pa);

	}

	function addRoomTurnCount($session, $rid) {

		$sql = 'update t_room set turnCount = turnCount + 1, lastUpdateDate = now() where roomID = :roomID';
		$pa = array(":roomID" => $rid);
		$result_uid = $session->query_select($sql, $pa);

	}

	function clsRoomTurnCount($session, $rid) {

		$sql = 'update t_room set turnCount = 0, lastUpdateDate = now() where roomID = :roomID';
		$pa = array(":roomID" => $rid);
		$result_uid = $session->query_select($sql, $pa);

	}

	function battlecalculate($session, $rid) {

		$gameOver = false;

		$sql = 'select userID, roomID, moveMapChipNo, battleCommandID, battleMapChipNo from t_userAction where roomId = :roomID';
		$pa = array(":roomID" =>  $rid);
		$result = $session->query_select($sql, $pa);

		if (! empty($result)) {
			foreach($result as $row) {
				if (! empty($row['battleMapChipNo'])) {
					$sql = 'update t_battle set power=power - :dp where mapChipNo = :bMapchip and roomID = :roomID';
					$pa = array( ":dp" => DEC_POWER, ":bMapchip" => $row['battleMapChipNo'], ":roomID" => $rid);

					$result_uid = $session->query_select($sql, $pa);
				}
			}

			foreach($result as $row) {
				if (! empty($row['moveMapChipNo'])) {
					$sql = 'update t_battle set mapChipNo = :mapChipNo where userID = :userID and roomID = :roomID';
					$pa = array( ":mapChipNo" => $row['moveMapChipNo'], ":userID" => $row['userID'], ":roomID" => $rid);
					$result_uid = $session->query_select($sql, $pa);
				}
			}

			//終了確認(全部をunion結合して判定は一回でもいいような)

			// 総大将やられた
			$sql = 'select battleID from t_battle where charKbn = :soudaisyo and roomID = :roomID and power = 0';
			$pa = array( ":soudaisyo" => SOUDAISYO_KBN, ":roomID" => $rid);

			$result = $session->query_select($sql, $pa);
			if (! empty($result)) {
				$gameOver = true;
			}

			//兵力0
			$sql = 'select power_a from (select countryID, sum(power) as power_a from t_battle where roomID = :roomID group by countryID) a where power_a = 0';
			$pa = array(":roomID" => $rid);

			$result = $session->query_select($sql, $pa);
			if (! empty($result)) {
				$gameOver = true;
			}
		}

		// ルームテーブルのカウンター値
		$sql = 'select roomID from t_room where roomID = :roomID and maxTurnCount < turnCount';
		$pa = array(":roomID" => $rid);

		$result = $session->query_select($sql, $pa);
		if (! empty($result)) {
			$gameOver = true;
		}

		return $gameOver;

	}


	function setAiChar($session, $rid) {
	

		$sql = 'select offenseCountry, defenseCountry from t_room where roomID = :roomID';
		$pa = array(":roomID" => $rid);

		$result = $session->query_select($sql, $pa);
		foreach($result as $row) {
			setAiBattle($session, $row['offenseCountry'], OFF_TYPE, $rid);
			setAiBattle($session, $row['defenseCountry'], DEF_TYPE, $rid);
		}
	}


	function setAiBattle($session, $countryID, $type, $rid){

		$sql = 'select a.charID, a.charName, a.countryID, a.charType, d.power, d.mobility from t_defaultParam d, t_AICharacter a where a.countryID = :countryID and a.paramID = d.paramID';
		$pa = array(":countryID" => $countryID);

		$result = $session->query_select($sql, $pa);
		$randkey = range(0, count($result) - 1);
		shuffle($randkey);

		$numOfChars = max(array(3, count($result)));
		
		$ctype = false;
		$cnt = 0;
		for ($c = 0; $c < $numOfChars; $c++ ) {
			$row = $result[$randkey[$c]];
			$cnt++;

			if ($row['charType'] == SOUDAISYO_KBN) {
				$ctype = true;
			}

			if ($cnt == $numOfChars and $ctype == false) {
				$row['charType'] = SOUDAISYO_KBN;
			}

			$umapNo = getUserMapNo($type);
	
 			// 乱数なので同じ値にならないことを前提→後で直す
			$bid = makeBattleID();

			$sql = "insert into t_battle values (:bid, :rid, :uid, :userName, :countryID, :userKbn, :umapNo, :power, :mobility, :exclusionKbn, now())";
			$pa = array(
						":bid" => "$bid", 
						":rid" => "$rid", 
						":uid" => $row['charID'], 
						":userName" => $row['charName'], 
						":countryID" => $row['countryID'], 
						":userKbn" => $row['charType'], 
						":umapNo" => "$umapNo", 
						":power" => $row['power'], 
						":mobility" => $row['mobility'], 
						":exclusionKbn" => "0");

			$result_inc = $session->query_update($sql, $pa);

			if ($result_inc == 0) {
				throw new Exception('0080003', SYSTEM_ERROR);
			}
		}
	}

	function makeBattleID() {

		$bid = 0;

		for ($i = 0 ; $i < 8 ; $i++){
			$bid = $bid . mt_rand(0, 9);
		}

		return $bid;
	
	}

	function getUserMapNo($utype) {

		$initMap = ($utype == OFF_TYPE) ? unserialize(OFF_INIT) : unserialize(DEF_INIT);
		return $initMap[mt_rand(0, count($initMap))];
	}


