﻿// //////////////////////////////////////////////////////////////////////////
//
// control.cs
//              Sarbo Project
//          Powerd by CACTUS SOFTWARE <http://www.cactussoft.co.jp/>
//
//                                              ver 1.0  2009/08/15
// This file is part of Sarbo.
//
// Sarbo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Sarbo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Sarbo.  If not, see <http://www.gnu.org/licenses/>.
//
// //////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace DShowCAC
{
	// //////////////////////////////////////////////////////////////////////
	// IAMCollection
	// DShowNET support
	// QuartzTypeLib support

	#region "IAMCollection C++ version"
	//MIDL_INTERFACE("56a868b9-0ad4-11ce-b03a-0020af0ba770")
	//IAMCollection : public IDispatch
	//{
	//public:
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Count( 
	//        /* [retval][out] */ LONG *plCount) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Item( 
	//        /* [in] */ long lItem,
	//        /* [out] */ IUnknown **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get__NewEnum( 
	//        /* [retval][out] */ IUnknown **ppUnk) = 0;
	//};
	#endregion

	/// <summary>
	/// VBでの利用を目的とし、QuartzTypeLib.FilgraphManagerから利用されている。
	/// </summary>
	[ComVisible(true), ComImport]
	[Guid("56a868b9-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IAMCollection
	{
		[PreserveSig]
		int get_Count([Out] out int plCount);

		[PreserveSig]
		int Item(int lItem, [Out, MarshalAs(UnmanagedType.IUnknown)] out object ppUnk);

		[PreserveSig]
		int get__NewEnum([Out, MarshalAs(UnmanagedType.IUnknown)] out object ppUnk);
	}

	// //////////////////////////////////////////////////////////////////////
	// IMediaControl
	// DShowNET support
	// QuartzTypeLib support

	#region "IMediaControl C++ version"
	//MIDL_INTERFACE("56a868b1-0ad4-11ce-b03a-0020af0ba770")
	//IMediaControl : public IDispatch
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Run( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Pause( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Stop( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetState( 
	//        /* [in] */ LONG msTimeout,
	//        /* [out] */ OAFilterState *pfs) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE RenderFile( 
	//        /* [in] */ BSTR strFilename) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE AddSourceFilter( 
	//        /* [in] */ BSTR strFilename,
	//        /* [out] */ IDispatch **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_FilterCollection( 
	//        /* [retval][out] */ IDispatch **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_RegFilterCollection( 
	//        /* [retval][out] */ IDispatch **ppUnk) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE StopWhenReady( void) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868b1-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IMediaControl
	{
		[PreserveSig]
		int Run();

		[PreserveSig]
		int Pause();

		[PreserveSig]
		int Stop();

		[PreserveSig]
		int GetState(int msTimeout, [Out] out FilterState pfs);

		[PreserveSig]
		int RenderFile(string strFilename);

		[PreserveSig]
		int AddSourceFilter(
			string strFilename,
			[Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int get_FilterCollection(
			[Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int get_RegFilterCollection(
			[Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int StopWhenReady();
	}

	// //////////////////////////////////////////////////////////////////////
	// IMediaEvent
	// DShowNET support
	// QuartzTypeLib support

	#region "IMediaEvent C++ version"
	//MIDL_INTERFACE("56a868b6-0ad4-11ce-b03a-0020af0ba770")
	//IMediaEvent : public IDispatch
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE GetEventHandle( 
	//        /* [out] */ OAEVENT *hEvent) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetEvent( 
	//        /* [out] */ long *lEventCode,
	//        /* [out] */ LONG_PTR *lParam1,
	//        /* [out] */ LONG_PTR *lParam2,
	//        /* [in] */ long msTimeout) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE WaitForCompletion( 
	//        /* [in] */ long msTimeout,
	//        /* [out] */ long *pEvCode) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE CancelDefaultHandling( 
	//        /* [in] */ long lEvCode) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE RestoreDefaultHandling( 
	//        /* [in] */ long lEvCode) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE FreeEventParams( 
	//        /* [in] */ long lEvCode,
	//        /* [in] */ LONG_PTR lParam1,
	//        /* [in] */ LONG_PTR lParam2) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868b6-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IMediaEvent
	{
		[PreserveSig]
		int GetEventHandle([Out] out IntPtr hEvent);

		[PreserveSig]
		int GetEvent(
			[Out] out EvCode	lEventCode,
			[Out] out int		lParam1,
			[Out] out int		lParam2,
			int					msTimeout);

		[PreserveSig]
		int WaitForCompletion(int msTimeout, [Out] out EvCode pEvCode);

		[PreserveSig]
		int CancelDefaultHandling(EvCode lEvCode);

		[PreserveSig]
		int RestoreDefaultHandling(EvCode lEvCode);

		[PreserveSig]
		int FreeEventParams(EvCode lEvCode, int lParam1, int lParam2);
	}

	// //////////////////////////////////////////////////////////////////////
	// IMediaEventEx
	// DShowNET support
	// QuartzTypeLib support

	#region "IMediaEventEx C++ version"
	//MIDL_INTERFACE("56a868c0-0ad4-11ce-b03a-0020af0ba770")
	//IMediaEventEx : public IMediaEvent
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE SetNotifyWindow( 
	//        /* [in] */ OAHWND hwnd,
	//        /* [in] */ long lMsg,
	//        /* [in] */ LONG_PTR lInstanceData) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetNotifyFlags( 
	//        /* [in] */ long lNoNotifyFlags) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetNotifyFlags( 
	//        /* [out] */ long *lplNoNotifyFlags) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868c0-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IMediaEventEx
    {
		#region "IMediaEvent Methods"
		[PreserveSig]
		int GetEventHandle([Out] out IntPtr hEvent);

		[PreserveSig]
		int GetEvent([Out] out EvCode lEventCode, [Out] out int lParam1, [Out] out int lParam2, int msTimeout);

		[PreserveSig]
		int WaitForCompletion(int msTimeout, [Out] out EvCode pEvCode);

		[PreserveSig]
		int CancelDefaultHandling(EvCode lEvCode);

		[PreserveSig]
		int RestoreDefaultHandling(EvCode lEvCode);

		[PreserveSig]
		int FreeEventParams(EvCode lEvCode, int lParam1, int lParam2);
		#endregion

		[PreserveSig]
		int SetNotifyWindow(IntPtr hwnd, int lMsg, int lInstanceData);

		[PreserveSig]
		int SetNotifyFlags(int lNoNotifyFlags);

		[PreserveSig]
		int GetNotifyFlags([Out] out int lplNoNotifyFlags);
	}

	// //////////////////////////////////////////////////////////////////////
	// IMediaPosition
	// DShowNET support
	// QuartzTypeLib support

	#region "IMediaPosition C++ version"
	//MIDL_INTERFACE("56a868b2-0ad4-11ce-b03a-0020af0ba770")
	//IMediaPosition : public IDispatch
	//{
	//public:
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Duration( 
	//        /* [retval][out] */ REFTIME *plength) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_CurrentPosition( 
	//        /* [in] */ REFTIME llTime) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_CurrentPosition( 
	//        /* [retval][out] */ REFTIME *pllTime) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_StopTime( 
	//        /* [retval][out] */ REFTIME *pllTime) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_StopTime( 
	//        /* [in] */ REFTIME llTime) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_PrerollTime( 
	//        /* [retval][out] */ REFTIME *pllTime) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_PrerollTime( 
	//        /* [in] */ REFTIME llTime) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Rate( 
	//        /* [in] */ double dRate) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Rate( 
	//        /* [retval][out] */ double *pdRate) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE CanSeekForward( 
	//        /* [retval][out] */ LONG *pCanSeekForward) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE CanSeekBackward( 
	//        /* [retval][out] */ LONG *pCanSeekBackward) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868b2-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IMediaPosition
	{
		[PreserveSig]
		int get_Duration([Out] out double pLength);

		[PreserveSig]
		int put_CurrentPosition(double llTime);

		[PreserveSig]
		int get_CurrentPosition([Out] out double pllTime);

		[PreserveSig]
		int get_StopTime([Out] out double pllTime);

		[PreserveSig]
		int put_StopTime(double llTime);

		[PreserveSig]
		int get_PrerollTime([Out] out double pllTime);

		[PreserveSig]
		int put_PrerollTime(double llTime);

		[PreserveSig]
		int put_Rate(double dRate);

		[PreserveSig]
		int get_Rate([Out] out double pdRate);

		[PreserveSig]
		int CanSeekForward([Out] out int pCanSeekForward);

		[PreserveSig]
		int CanSeekBackward([Out] out int pCanSeekBackward);
	}

	// //////////////////////////////////////////////////////////////////////
	// IBasicAudio
	// DShowNET support
	// QuartzTypeLib support

	#region "IBasicAudio C++ version"
	//MIDL_INTERFACE("56a868b3-0ad4-11ce-b03a-0020af0ba770")
	//IBasicAudio : public IDispatch
	//{
	//public:
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Volume( 
	//        /* [in] */ long lVolume) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Volume( 
	//        /* [retval][out] */ long *plVolume) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Balance( 
	//        /* [in] */ long lBalance) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Balance( 
	//        /* [retval][out] */ long *plBalance) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868b3-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IBasicAudio
    {
		[PreserveSig]
		int put_Volume(int lVolume);

		[PreserveSig]
		int get_Volume([Out] out int plVolume);

		[PreserveSig]
		int put_Balance(int lBalance);

		[PreserveSig]
		int get_Balance([Out] out int plBalance);
	}

	// //////////////////////////////////////////////////////////////////////
	// IVideoWindow
	// DShowNET support
	// QuartzTypeLib support

	#region "IVideoWindow C++ version"
	//MIDL_INTERFACE("56a868b4-0ad4-11ce-b03a-0020af0ba770")
	//IVideoWindow : public IDispatch
	//{
	//public:
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Caption( 
	//        /* [in] */ BSTR strCaption) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Caption( 
	//        /* [retval][out] */ BSTR *strCaption) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_WindowStyle( 
	//        /* [in] */ long WindowStyle) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_WindowStyle( 
	//        /* [retval][out] */ long *WindowStyle) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_WindowStyleEx( 
	//        /* [in] */ long WindowStyleEx) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_WindowStyleEx( 
	//        /* [retval][out] */ long *WindowStyleEx) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_AutoShow( 
	//        /* [in] */ long AutoShow) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_AutoShow( 
	//        /* [retval][out] */ long *AutoShow) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_WindowState( 
	//        /* [in] */ long WindowState) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_WindowState( 
	//        /* [retval][out] */ long *WindowState) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_BackgroundPalette( 
	//        /* [in] */ long BackgroundPalette) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_BackgroundPalette( 
	//        /* [retval][out] */ long *pBackgroundPalette) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Visible( 
	//        /* [in] */ long Visible) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Visible( 
	//        /* [retval][out] */ long *pVisible) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Left( 
	//        /* [in] */ long Left) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Left( 
	//        /* [retval][out] */ long *pLeft) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Width( 
	//        /* [in] */ long Width) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Width( 
	//        /* [retval][out] */ long *pWidth) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Top( 
	//        /* [in] */ long Top) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Top( 
	//        /* [retval][out] */ long *pTop) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Height( 
	//        /* [in] */ long Height) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Height( 
	//        /* [retval][out] */ long *pHeight) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Owner( 
	//        /* [in] */ OAHWND Owner) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Owner( 
	//        /* [retval][out] */ OAHWND *Owner) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_MessageDrain( 
	//        /* [in] */ OAHWND Drain) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_MessageDrain( 
	//        /* [retval][out] */ OAHWND *Drain) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_BorderColor( 
	//        /* [retval][out] */ long *Color) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_BorderColor( 
	//        /* [in] */ long Color) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_FullScreenMode( 
	//        /* [retval][out] */ long *FullScreenMode) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_FullScreenMode( 
	//        /* [in] */ long FullScreenMode) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetWindowForeground( 
	//        /* [in] */ long Focus) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE NotifyOwnerMessage( 
	//        /* [in] */ OAHWND hwnd,
	//        /* [in] */ long uMsg,
	//        /* [in] */ LONG_PTR wParam,
	//        /* [in] */ LONG_PTR lParam) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetWindowPosition( 
	//        /* [in] */ long Left,
	//        /* [in] */ long Top,
	//        /* [in] */ long Width,
	//        /* [in] */ long Height) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetWindowPosition( 
	//        /* [out] */ long *pLeft,
	//        /* [out] */ long *pTop,
	//        /* [out] */ long *pWidth,
	//        /* [out] */ long *pHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetMinIdealImageSize( 
	//        /* [out] */ long *pWidth,
	//        /* [out] */ long *pHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetMaxIdealImageSize( 
	//        /* [out] */ long *pWidth,
	//        /* [out] */ long *pHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetRestorePosition( 
	//        /* [out] */ long *pLeft,
	//        /* [out] */ long *pTop,
	//        /* [out] */ long *pWidth,
	//        /* [out] */ long *pHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE HideCursor( 
	//        /* [in] */ long HideCursor) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsCursorHidden( 
	//        /* [out] */ long *CursorHidden) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868b4-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IVideoWindow
	{
		[PreserveSig]
		int put_Caption(string caption);

		[PreserveSig]
		int get_Caption([Out] out string caption);

		[PreserveSig]
		int put_WindowStyle(int windowStyle);

		[PreserveSig]
		int get_WindowStyle([Out] out int windowStyle);

		[PreserveSig]
		int put_WindowStyleEx(int windowStyleEx);

		[PreserveSig]
		int get_WindowStyleEx([Out] out int windowStyleEx);

		[PreserveSig]
		int put_AutoShow(int autoShow);

		[PreserveSig]
		int get_AutoShow([Out] out int autoShow);

		[PreserveSig]
		int put_WindowState(int windowState);

		[PreserveSig]
		int get_WindowState([Out] out int windowState);

		[PreserveSig]
		int put_BackgroundPalette(int backgroundPalette);

		[PreserveSig]
		int get_BackgroundPalette([Out] out int backgroundPalette);

		[PreserveSig]
		int put_Visible(int visible);

		[PreserveSig]
		int get_Visible([Out] out int visible);

		[PreserveSig]
		int put_Left(int left);

		[PreserveSig]
		int get_Left([Out] out int left);

		[PreserveSig]
		int put_Width(int width);

		[PreserveSig]
		int get_Width([Out] out int width);

		[PreserveSig]
		int put_Top(int top);

		[PreserveSig]
		int get_Top([Out] out int top);

		[PreserveSig]
		int put_Height(int height);

		[PreserveSig]
		int get_Height([Out] out int height);

		[PreserveSig]
		int put_Owner(IntPtr owner);

		[PreserveSig]
		int get_Owner([Out] out IntPtr owner);

		[PreserveSig]
		int put_MessageDrain(IntPtr drain);

		[PreserveSig]
		int get_MessageDrain([Out] out IntPtr drain);

		[PreserveSig]
		int get_BorderColor([Out] out int color);

		[PreserveSig]
		int put_BorderColor(int color);

		[PreserveSig]
		int get_FullScreenMode([Out] out int fullScreenMode);

		[PreserveSig]
		int put_FullScreenMode(int fullScreenMode);

		[PreserveSig]
		int SetWindowForeground(int focus);

		[PreserveSig]
		int NotifyOwnerMessage(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam);

		[PreserveSig]
		int SetWindowPosition(int left, int top, int width, int height);

		[PreserveSig]
		int GetWindowPosition([Out] out int left, [Out] out int top, [Out] out int width, [Out] out int height);

		[PreserveSig]
		int GetMinIdealImageSize([Out] out int width, [Out] out int height);

		[PreserveSig]
		int GetMaxIdealImageSize([Out] out int width, [Out] out int height);

		[PreserveSig]
		int GetRestorePosition([Out] out int left, [Out] out int top, [Out] out int width, [Out] out int height);

		[PreserveSig]
		int HideCursor(int hideCursor);

		[PreserveSig]
		int IsCursorHidden([Out] out int hideCursor);
	}

	// //////////////////////////////////////////////////////////////////////
	// IBasicVideo
	// QuartzTypeLib support

	#region "IBasicVideo C++ version"
	//MIDL_INTERFACE("56a868b5-0ad4-11ce-b03a-0020af0ba770")
	//IBasicVideo : public IDispatch
	//{
	//public:
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_AvgTimePerFrame( 
	//        /* [retval][out] */ REFTIME *pAvgTimePerFrame) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_BitRate( 
	//        /* [retval][out] */ long *pBitRate) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_BitErrorRate( 
	//        /* [retval][out] */ long *pBitErrorRate) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_VideoWidth( 
	//        /* [retval][out] */ long *pVideoWidth) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_VideoHeight( 
	//        /* [retval][out] */ long *pVideoHeight) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_SourceLeft( 
	//        /* [in] */ long SourceLeft) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_SourceLeft( 
	//        /* [retval][out] */ long *pSourceLeft) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_SourceWidth( 
	//        /* [in] */ long SourceWidth) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_SourceWidth( 
	//        /* [retval][out] */ long *pSourceWidth) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_SourceTop( 
	//        /* [in] */ long SourceTop) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_SourceTop( 
	//        /* [retval][out] */ long *pSourceTop) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_SourceHeight( 
	//        /* [in] */ long SourceHeight) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_SourceHeight( 
	//        /* [retval][out] */ long *pSourceHeight) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_DestinationLeft( 
	//        /* [in] */ long DestinationLeft) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_DestinationLeft( 
	//        /* [retval][out] */ long *pDestinationLeft) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_DestinationWidth( 
	//        /* [in] */ long DestinationWidth) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_DestinationWidth( 
	//        /* [retval][out] */ long *pDestinationWidth) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_DestinationTop( 
	//        /* [in] */ long DestinationTop) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_DestinationTop( 
	//        /* [retval][out] */ long *pDestinationTop) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_DestinationHeight( 
	//        /* [in] */ long DestinationHeight) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_DestinationHeight( 
	//        /* [retval][out] */ long *pDestinationHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetSourcePosition( 
	//        /* [in] */ long Left,
	//        /* [in] */ long Top,
	//        /* [in] */ long Width,
	//        /* [in] */ long Height) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetSourcePosition( 
	//        /* [out] */ long *pLeft,
	//        /* [out] */ long *pTop,
	//        /* [out] */ long *pWidth,
	//        /* [out] */ long *pHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetDefaultSourcePosition( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetDestinationPosition( 
	//        /* [in] */ long Left,
	//        /* [in] */ long Top,
	//        /* [in] */ long Width,
	//        /* [in] */ long Height) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetDestinationPosition( 
	//        /* [out] */ long *pLeft,
	//        /* [out] */ long *pTop,
	//        /* [out] */ long *pWidth,
	//        /* [out] */ long *pHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE SetDefaultDestinationPosition( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetVideoSize( 
	//        /* [out] */ long *pWidth,
	//        /* [out] */ long *pHeight) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetVideoPaletteEntries( 
	//        /* [in] */ long StartIndex,
	//        /* [in] */ long Entries,
	//        /* [out] */ long *pRetrieved,
	//        /* [out] */ long *pPalette) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetCurrentImage( 
	//        /* [out][in] */ long *pBufferSize,
	//        /* [out] */ long *pDIBImage) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsUsingDefaultSource( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE IsUsingDefaultDestination( void) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("56a868b5-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IBasicVideo
	{
		[PreserveSig]
		int get_AvgTimePerFrame([Out] out double pAvgTimePerFrame);

		[PreserveSig]
		int get_BitRate([Out] out int pBitRate);

		[PreserveSig]
		int get_BitErrorRate([Out] out int pBitErrorRate);

		[PreserveSig]
		int get_VideoWidth([Out] out int pVideoWidth);

		[PreserveSig]
		int get_VideoHeight([Out] out int pVideoHeight);

		[PreserveSig]
		int put_SourceLeft(int SourceLeft);

		[PreserveSig]
		int get_SourceLeft([Out] out int pSourceLeft);

		[PreserveSig]
		int put_SourceWidth(int SourceWidth);

		[PreserveSig]
		int get_SourceWidth([Out] out int pSourceWidth);

		[PreserveSig]
		int put_SourceTop(int SourceTop);

		[PreserveSig]
		int get_SourceTop([Out] out int pSourceTop);

		[PreserveSig]
		int put_SourceHeight(int SourceHeight);

		[PreserveSig]
		int get_SourceHeight([Out] out int pSourceHeight);

		[PreserveSig]
		int put_DestinationLeft(int DestinationLeft);

		[PreserveSig]
		int get_DestinationLeft([Out] out int pDestinationLeft);

		[PreserveSig]
		int put_DestinationWidth(int DestinationWidth);

		[PreserveSig]
		int get_DestinationWidth([Out] out int pDestinationWidth);

		[PreserveSig]
		int put_DestinationTop(int DestinationTop);

		[PreserveSig]
		int get_DestinationTop([Out] out int pDestinationTop);

		[PreserveSig]
		int put_DestinationHeight(int DestinationHeight);

		[PreserveSig]
		int get_DestinationHeight([Out] out int pDestinationHeight);

		[PreserveSig]
		int SetSourcePosition(int Left, int Top, int Width, int Height);

		[PreserveSig]
		int GetSourcePosition([Out] out int pLeft, [Out] out int pTop, [Out] out int pWidth, [Out] out int pHeight);

		[PreserveSig]
		int SetDefaultSourcePosition();

		[PreserveSig]
		int SetDestinationPosition(int Left, int Top, int Width, int Height);

		[PreserveSig]
		int GetDestinationPosition([Out] out int pLeft, [Out] out int pTop, [Out] out int pWidth, [Out] out int pHeight);

		[PreserveSig]
		int SetDefaultDestinationPosition();

		[PreserveSig]
		int GetVideoSize([Out] out int pWidth, [Out] out int pHeight);

		[PreserveSig]
		int GetVideoPaletteEntries(int StartIndex, int Entries, [Out] out int pRetrieved, [Out] out int pPalette);

		[PreserveSig]
		int GetCurrentImage([In, Out] ref int pBufferSize, [Out] out int pDIBImage);

		[PreserveSig]
		int IsUsingDefaultSource();

		[PreserveSig]
		int IsUsingDefaultDestination();
	}

	// //////////////////////////////////////////////////////////////////////
	// IBasicVideo2
	// DShowNET support
	// QuartzTypeLib support

	#region "IBasicVideo2 C++ version"
	//MIDL_INTERFACE("329bb360-f6ea-11d1-9038-00a0c9697298")
	//IBasicVideo2 : public IBasicVideo
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE GetPreferredAspectRatio( 
	//        /* [out] */ long *plAspectX,
	//        /* [out] */ long *plAspectY) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("329bb360-f6ea-11d1-9038-00a0c9697298")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IBasicVideo2
	{
		#region "IBasicVideo Methods"
		[PreserveSig]
		int get_AvgTimePerFrame([Out] out double pAvgTimePerFrame);

		[PreserveSig]
		int get_BitRate([Out] out int pBitRate);

		[PreserveSig]
		int get_BitErrorRate([Out] out int pBitErrorRate);

		[PreserveSig]
		int get_VideoWidth([Out] out int pVideoWidth);

		[PreserveSig]
		int get_VideoHeight([Out] out int pVideoHeight);

		[PreserveSig]
		int put_SourceLeft(int SourceLeft);

		[PreserveSig]
		int get_SourceLeft([Out] out int pSourceLeft);

		[PreserveSig]
		int put_SourceWidth(int SourceWidth);

		[PreserveSig]
		int get_SourceWidth([Out] out int pSourceWidth);

		[PreserveSig]
		int put_SourceTop(int SourceTop);

		[PreserveSig]
		int get_SourceTop([Out] out int pSourceTop);

		[PreserveSig]
		int put_SourceHeight(int SourceHeight);

		[PreserveSig]
		int get_SourceHeight([Out] out int pSourceHeight);

		[PreserveSig]
		int put_DestinationLeft(int DestinationLeft);

		[PreserveSig]
		int get_DestinationLeft([Out] out int pDestinationLeft);

		[PreserveSig]
		int put_DestinationWidth(int DestinationWidth);

		[PreserveSig]
		int get_DestinationWidth([Out] out int pDestinationWidth);

		[PreserveSig]
		int put_DestinationTop(int DestinationTop);

		[PreserveSig]
		int get_DestinationTop([Out] out int pDestinationTop);

		[PreserveSig]
		int put_DestinationHeight(int DestinationHeight);

		[PreserveSig]
		int get_DestinationHeight([Out] out int pDestinationHeight);

		[PreserveSig]
		int SetSourcePosition(int Left, int Top, int Width, int Height);

		[PreserveSig]
		int GetSourcePosition([Out] out int pLeft, [Out] out int pTop, [Out] out int pWidth, [Out] out int pHeight);

		[PreserveSig]
		int SetDefaultSourcePosition();

		[PreserveSig]
		int SetDestinationPosition(int Left, int Top, int Width, int Height);

		[PreserveSig]
		int GetDestinationPosition([Out] out int pLeft, [Out] out int pTop, [Out] out int pWidth, [Out] out int pHeight);

		[PreserveSig]
		int SetDefaultDestinationPosition();

		[PreserveSig]
		int GetVideoSize([Out] out int pWidth, [Out] out int pHeight);

		[PreserveSig]
		int GetVideoPaletteEntries(int StartIndex, int Entries, [Out] out int pRetrieved, [Out] out int pPalette);

		[PreserveSig]
		int GetCurrentImage(ref int pBufferSize, [Out] out int pDIBImage);

		[PreserveSig]
		int IsUsingDefaultSource();

		[PreserveSig]
		int IsUsingDefaultDestination();
		#endregion

		[PreserveSig]
		int GetPreferredAspectRatio([Out] out int plAspectX, [Out] out int plAspectY);
	}

	// //////////////////////////////////////////////////////////////////////
	// IDeferredCommand
	// QuartzTypeLib support

	// //////////////////////////////////////////////////////////////////////
	// IQueueCommand
	// QuartzTypeLib support

	// //////////////////////////////////////////////////////////////////////
	// IFilterInfo
	// QuartzTypeLib support

	#region "IFilterInfo C++ version"
	//MIDL_INTERFACE("56a868ba-0ad4-11ce-b03a-0020af0ba770")
	//IFilterInfo : public IDispatch
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE FindPin( 
	//        /* [in] */ BSTR strPinID,
	//        /* [out] */ IDispatch **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Name( 
	//        /* [retval][out] */ BSTR *strName) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_VendorInfo( 
	//        /* [retval][out] */ BSTR *strVendorInfo) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Filter( 
	//        /* [retval][out] */ IUnknown **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Pins( 
	//        /* [retval][out] */ IDispatch **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_IsFileSource( 
	//        /* [retval][out] */ LONG *pbIsSource) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Filename( 
	//        /* [retval][out] */ BSTR *pstrFilename) = 0;
        
	//    virtual /* [propput] */ HRESULT STDMETHODCALLTYPE put_Filename( 
	//        /* [in] */ BSTR strFilename) = 0;
	//};
	#endregion

	/// <summary>
	/// VBでの利用を目的とし、QuartzTypeLib.FilgraphManagerから利用されている。
	/// </summary>
	[ComVisible(true), ComImport]
	[Guid("56a868ba-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IFilterInfo
	{
		[PreserveSig]
		int FindPin(
			string strPinID,
			[Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int get_Name([Out] out string strName);

		[PreserveSig]
		int get_VendorInfo([Out] out string strVendorInfo);

		[PreserveSig]
		int get_Filter([Out, MarshalAs(UnmanagedType.IUnknown)] out object ppUnk);

		[PreserveSig]
		int get_Pins([Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int get_IsFileSource([Out] out int pbIsSource);

		[PreserveSig]
		int get_Filename([Out] out string pstrFilename);

		[PreserveSig]
		int put_Filename(string strFilename);
	}

	// //////////////////////////////////////////////////////////////////////
	// IRegFilterInfo
	// QuartzTypeLib support

	#region "IRegFilterInfo C++ version"
	//MIDL_INTERFACE("56a868bb-0ad4-11ce-b03a-0020af0ba770")
	//IRegFilterInfo : public IDispatch
	//{
	//public:
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Name( 
	//        /* [retval][out] */ BSTR *strName) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Filter( 
	//        /* [out] */ IDispatch **ppUnk) = 0;
	//};
	#endregion

	/// <summary>
	/// VBでの利用を目的とし、QuartzTypeLib.FilgraphManagerから利用されている。
	/// </summary>
	[ComVisible(true), ComImport]
	[Guid("56a868bb-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IRegFilterInfo
	{
		[PreserveSig]
		int get_Name([Out] out string strName);

		[PreserveSig]
		int Filter([Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);
	}

	// //////////////////////////////////////////////////////////////////////
	// IMediaTypeInfo
	// QuartzTypeLib support

	#region "IMediaTypeInfo C++ version"
	//MIDL_INTERFACE("56a868bc-0ad4-11ce-b03a-0020af0ba770")
	//IMediaTypeInfo : public IDispatch
	//{
	//public:
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Type( 
	//        /* [retval][out] */ BSTR *strType) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Subtype( 
	//        /* [retval][out] */ BSTR *strType) = 0;
	//};
	#endregion

	/// <summary>
	/// VBでの利用を目的とし、QuartzTypeLib.FilgraphManagerから利用されている。
	/// </summary>
	[ComVisible(true), ComImport]
	[Guid("56a868bc-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IMediaTypeInfo
	{
		[PreserveSig]
		int get_Type([Out] out string strType);

		[PreserveSig]
		int get_Subtype([Out] out string strType);
	}

	// //////////////////////////////////////////////////////////////////////
	// IPinInfo
	// QuartzTypeLib support

	#region "IPinInfo C++ version"
	//MIDL_INTERFACE("56a868bd-0ad4-11ce-b03a-0020af0ba770")
	//IPinInfo : public IDispatch
	//{
	//public:
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Pin( 
	//        /* [retval][out] */ IUnknown **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_ConnectedTo( 
	//        /* [retval][out] */ IDispatch **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_ConnectionMediaType( 
	//        /* [retval][out] */ IDispatch **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_FilterInfo( 
	//        /* [retval][out] */ IDispatch **ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Name( 
	//        /* [retval][out] */ BSTR *ppUnk) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Direction( 
	//        /* [retval][out] */ LONG *ppDirection) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_PinID( 
	//        /* [retval][out] */ BSTR *strPinID) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_MediaTypes( 
	//        /* [retval][out] */ IDispatch **ppUnk) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Connect( 
	//        /* [in] */ IUnknown *pPin) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ConnectDirect( 
	//        /* [in] */ IUnknown *pPin) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE ConnectWithType( 
	//        /* [in] */ IUnknown *pPin,
	//        /* [in] */ IDispatch *pMediaType) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Disconnect( void) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE Render( void) = 0;
	//};
	#endregion

	/// <summary>
	/// VBでの利用を目的とし、QuartzTypeLib.FilgraphManagerから利用されている。
	/// </summary>
	[ComVisible(true), ComImport]
	[Guid("56a868bd-0ad4-11ce-b03a-0020af0ba770")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IPinInfo
	{
		[PreserveSig]
		int get_Pin([Out, MarshalAs(UnmanagedType.IUnknown)] out object ppUnk);

		[PreserveSig]
		int get_ConnectedTo([Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int get_ConnectionMediaType([Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int get_FilterInfo([Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int get_Name([Out] out string ppUnk);

		[PreserveSig]
		int get_Direction([Out] out PinDirection ppDirection);

		[PreserveSig]
		int get_PinID([Out] out string strPinID);

		[PreserveSig]
		int get_MediaTypes([Out, MarshalAs(UnmanagedType.IDispatch)] out object ppUnk);

		[PreserveSig]
		int Connect([MarshalAs(UnmanagedType.IUnknown)] object pPin);

		[PreserveSig]
		int ConnectDirect([MarshalAs(UnmanagedType.IUnknown)] object pPin);

		[PreserveSig]
		int ConnectWithType(
			[MarshalAs(UnmanagedType.IUnknown)] object pPin,
			[MarshalAs(UnmanagedType.IDispatch)] object pMediaType);

		[PreserveSig]
		int Disconnect();

		[PreserveSig]
		int Render();
	}

	// //////////////////////////////////////////////////////////////////////
	// IAMStats
	// QuartzTypeLib support

	#region "IAMStats C++ version"
	//MIDL_INTERFACE("bc9bcf80-dcd2-11d2-abf6-00a0c905f375")
	//IAMStats : public IDispatch
	//{
	//public:
	//    virtual HRESULT STDMETHODCALLTYPE Reset( void) = 0;
        
	//    virtual /* [propget] */ HRESULT STDMETHODCALLTYPE get_Count( 
	//        /* [retval][out] */ LONG *plCount) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetValueByIndex( 
	//        /* [in] */ long lIndex,
	//        /* [out] */ BSTR *szName,
	//        /* [out] */ long *lCount,
	//        /* [out] */ double *dLast,
	//        /* [out] */ double *dAverage,
	//        /* [out] */ double *dStdDev,
	//        /* [out] */ double *dMin,
	//        /* [out] */ double *dMax) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetValueByName( 
	//        /* [in] */ BSTR szName,
	//        /* [out] */ long *lIndex,
	//        /* [out] */ long *lCount,
	//        /* [out] */ double *dLast,
	//        /* [out] */ double *dAverage,
	//        /* [out] */ double *dStdDev,
	//        /* [out] */ double *dMin,
	//        /* [out] */ double *dMax) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE GetIndex( 
	//        /* [in] */ BSTR szName,
	//        /* [in] */ long lCreate,
	//        /* [out] */ long *plIndex) = 0;
        
	//    virtual HRESULT STDMETHODCALLTYPE AddValue( 
	//        /* [in] */ long lIndex,
	//        /* [in] */ double dValue) = 0;
	//};
	#endregion

	[ComVisible(true), ComImport]
	[Guid("bc9bcf80-dcd2-11d2-abf6-00a0c905f375")]
	[InterfaceType(ComInterfaceType.InterfaceIsDual)]
	public interface IAMStats
	{
		[PreserveSig]
		int Reset();

		[PreserveSig]
		int get_Count([Out] out int plCount);

		[PreserveSig]
		int GetValueByIndex(
			int					lIndex,
			[Out] out string	szName,
			[Out] out int		lCount,
			[Out] out double	dLast,
			[Out] out double	dAverage,
			[Out] out double	dStdDev,
			[Out] out double	dMin,
			[Out] out double	dMax);

		[PreserveSig]
		int GetValueByName(
			string				szName,
			[Out] out int		lIndex,
			[Out] out int		lCount,
			[Out] out double	dLast,
			[Out] out double	dAverage,
			[Out] out double	dStdDev,
			[Out] out double	dMin,
			[Out] out double	dMax);

		[PreserveSig]
		int GetIndex(string szName, int lCreate, [Out] out int plIndex);

		[PreserveSig]
		int AddValue(int lIndex, double dValue);
	}
}

// //////////////////////////////////////////////////////////////////////////
