﻿// //////////////////////////////////////////////////////////////////////////
//
// ComboDeviceOut.cs
//              Sarbo Project
//          Powerd by CACTUS SOFTWARE <http://www.cactussoft.co.jp/>
//
//                                              ver 1.0  2009/08/13
// This file is part of Sarbo.
//
// Sarbo is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Sarbo is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Sarbo.  If not, see <http://www.gnu.org/licenses/>.
//
// //////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using System.Windows.Forms;
using DShowCAC;

namespace DShowPlay
{
	public partial class ComboDeviceOut : UserControl
	{
		private List<IMoniker>		_iMonikerList = new List<IMoniker>();
		private List<string>		_deviceList = new List<string>();

		public ComboDeviceOut()
		{
			InitializeComponent();
		}

		// //////////////////////////////////////////////////////////////////
		// Property

		public List<IMoniker> IMonikerList
		{
			get		{		return _iMonikerList;			}
		}

		public List<string> DeviceList
		{
			get		{		return _deviceList;				}
		}

		public int NumDevs
		{
			get		{		return DeviceList.Count;		}
		}

		// //////////////////////////////////////////////////////////////////
		// Index/CurMoniker

		public int Index
		{
			get
			{
				return comboDevice.SelectedIndex;
			}
			set
			{
				if ((0 <= value)&&(value < NumDevs))
					comboDevice.SelectedIndex = value;
				else
					comboDevice.SelectedIndex = -1;
			}
		}

		public IMoniker CurMoniker
		{
			get
			{
				if (Index < 0)		return null;
				else				return IMonikerList[Index];
			}
		}

		// //////////////////////////////////////////////////////////////////
		// InitComboBox

		public void InitComboBox()
		{
			GetRenderList();
			comboDevice.DataSource = DeviceList;

			for (int i=0; i<NumDevs; i++)
			{
				if (DeviceList[i] == "Default DirectSound Device")
				{
					Index = i;		break;
				}
			}
		}

		public void ExitComboBox()
		{
			for (int i=0; i<NumDevs; i++)
			{
				Marshal.ReleaseComObject(IMonikerList[i]);
			}
			IMonikerList.Clear();
		}

		// //////////////////////////////////////////////////////////////////
		// GetRenderList

		public void GetRenderList()
		{
			object			objPropBag = null;
			IEnumMoniker	iEnumMoniker = null;
			int				result;

			try
			{
				Type comType = Type.GetTypeFromCLSID(CLSID.SystemDeviceEnum);

				if (comType == null)
					throw new NotImplementedException("System Device Enumerator");

				object comObj = Activator.CreateInstance(comType);
				ICreateDevEnum iSysDevEnum = (ICreateDevEnum)comObj; comObj = null;

				Guid cat = CLSID.AudioRendererCategory;
				result = iSysDevEnum.CreateClassEnumerator(
					ref cat,
					out iEnumMoniker,
					0);

				if (HResult.Failed(result))
					Marshal.ThrowExceptionForHR(result);

				IMoniker[] rgelt = new IMoniker[1];
				IntPtr pceltFetched = IntPtr.Zero;
				Guid iidIPropertyBag = typeof(IPropertyBag).GUID;

				while(true)
				{
					result = iEnumMoniker.Next(1, rgelt, pceltFetched);
					if (result != HResult.OK)		break;
					if (rgelt[0] == null)			break;

					rgelt[0].BindToStorage(null, null, ref iidIPropertyBag, out objPropBag);
					IPropertyBag iPropBag = (IPropertyBag)objPropBag;

					object varName = null;
					result = iPropBag.Read("FriendlyName", ref varName, null);
					if (result != 0)
						Marshal.ThrowExceptionForHR(result);

					string strName = varName as string;
					if ((strName == null)||(strName.Length < 1))
						throw new NotImplementedException("FriendlyName");

					IMonikerList.Add(rgelt[0]);
					DeviceList.Add(strName);

					Marshal.ReleaseComObject(objPropBag); objPropBag = null;
				}
			}
			catch (Exception)
			{
			}
			finally
			{
				if (objPropBag != null)
					Marshal.ReleaseComObject(objPropBag); objPropBag = null;
				if (iEnumMoniker != null)
					Marshal.ReleaseComObject(iEnumMoniker); iEnumMoniker = null;
			}
		}
	}
}

// //////////////////////////////////////////////////////////////////////////
