#include "config.h"
#include "saphire_extra.h"
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <limits.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#include <limits.h>

#if defined(__DARWIN__)
#include <sys/syslimits.h>
#endif

//////////////////////////////////////////////////////////////////////
// ?g???q?????Ԃ?
//////////////////////////////////////////////////////////////////////
void extname(SPACE char* result, char* name)
{
    char* p;
    
    for(p = name + strlen(name); p != name; p--) {
        if(*p == '.' && p == name + strlen(name)) {
            strcpy(result, "");
            return;
        }
        else if(*p == '/') {
            strcpy(result, "");
            return;
        }
        else if(*p == '.') {
            strcpy(result, p+1);
            return;
        }
    }

    strcpy(result, "");
}

//////////////////////////////////////////////////////////////////////
// ?g???q???ȊO???Ԃ?
//////////////////////////////////////////////////////////////////////
void noextname(SPACE char* result, char* name)
{
    char* max;
    char* p;
    
    max = name + strlen(name);
    for(p = name; p < max; p++) {
        if(*p == '.') {
            memcpy(result, name, p - name);
            result[p - name] = 0;
            return;
        }
    }

    strcpy(result, name);
}

//////////////////////////////////////////////////////////////////////
// ?e?f?B???N?g???????Ԃ?
//////////////////////////////////////////////////////////////////////
void parentname(SPACE char* result, char* path)
{
    char* p;

    if(*path == 0) {
        strcpy(result, "");
        return;
    }
    
    if(strcmp(path, "/") == 0) {
        strcpy(result, "/");
        return;
    }

    for(p=path + strlen(path)-2; p != path-1; p--) {
        if(*p == '/' ) {
            memcpy(result, path, p-path);
            result[p-path] = '/';
            result[p-path+1] = 0;
            
            return;
        }
    }

    strcpy(result, "");
}

//////////////////////////////////////////////////////////////////////
// ?J?????g?f?B???N?g?????Ԃ?
//////////////////////////////////////////////////////////////////////
void mygetcwd(SPACE char* result)
{
    int l;
    
    l = 50;
    while(!getcwd(result, l)) {
         l += 50;
    }
}


//////////////////////////////////////////////////////////////////////
// ?????????????Ԃ?
//////////////////////////////////////////////////////////////////////
char* mystrcasestr(const char *haystack, const char *needle)
{
    char* p;
    p = (char*)haystack;

    while(*p) {
        char* p2;
        char* p3;
        BOOL match;

        p2 = p;
        p3 = (char*)needle;
        
        match = TRUE;
        while(*p3) {
            if(*p2 == 0) {
                match = FALSE;
                break;
            }
            
            if(tolower(*p2) != tolower(*p3)) {
                match = FALSE;
                break;
            }
            
            p2++;
            p3++;
        }
        
        if(match) {
            return p;
        }
        
        p++;
    }
    
    return NULL;
}

//////////////////////////////////////////////////////////////////////
// ?????????S?????????ɂ???
//////////////////////////////////////////////////////////////////////
void mystrtolower(char* result)
{
    int i;

    const int len = strlen(result);
    for(i=0; i<len; i++) {
        result[i] = tolower(result[i]);
    }
}

//////////////////////////////////////////////////////////////////////
// パスを絶対パスにする
//////////////////////////////////////////////////////////////////////
int correct_path(char* current_path, char* path, char* path2)
{
    char tmp[PATH_MAX];
    char tmp2[PATH_MAX];
    char tmp3[PATH_MAX];
    char tmp4[PATH_MAX];

    /// 先頭にカレントパスを加える ///
    {
        if(path[0] == '/' || path[0] == '~' || path[0] == '$') {
            strcpy(tmp, path);
        }
        else {
            if(current_path == NULL) {
                char cwd[PATH_MAX];
                mygetcwd(cwd);
                
                strcpy(tmp, cwd);
                strcat(tmp, "/");
                strcat(tmp, path);
            }
            else {
                strcpy(tmp, current_path);
                if(current_path[strlen(current_path)-1] != '/') {
                    strcat(tmp, "/");
                }
                strcat(tmp, path);
            }
        }

    }

    /// ~と環境変数を展開する ///
    {
        char* home = getenv("HOME");

        if(home == NULL) {
            fprintf(stderr, "$HOME is not setted");
            exit(1);
        }
        
        if(tmp[0] == '~' && strlen(tmp) == 1) {
            strcpy(tmp2, home);
        }
        else if(tmp[0] == '~' && tmp[1] == '/') {
            strcpy(tmp2, home);
            strcat(tmp2, "/");
            strcat(tmp2, tmp + 2);
        }
        else if(tmp[0] == '$') {
            char* p;
            char* p2;
            char env[256];
            char* env_value;

            p = tmp + 1;
            p2 = env;
            while(*p != '/' && *p) {
                *p2++ = *p++;
            }
            *p2 = 0;

            env_value = getenv(env);
            if(env_value == NULL) {
                strcpy(tmp2, p);
            }
            else {
                if(*p == '/') {
                    strcpy(tmp2, env_value);
                    strcat(tmp2, p);
                }
                else {
                    strcpy(tmp2, env_value);
                }
            }
        }
        else {
            strcpy(tmp2, tmp);
        }

    }

   
    /// .を削除する ///
    {
        char* p;
        char* p2;
        int i;

        p = tmp3;
        p2 = tmp2;
        while(*p2) {
            if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) != '.' && ((*p2+3)=='/' || *(p2+3)==0)) {
                p2+=2;
            }
            else {
                *p++ = *p2++;
            }
        }
        *p = 0;

        if(*tmp3 == 0) {
            *tmp3 = '/';
            *(tmp3+1) = 0;
        }

    }

    /// ..を削除する ///
    {
        char* p;
        char* p2;

        p = tmp4;
        p2 = tmp3;

        while(*p2) {
            if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) == '.' 
                && *(p2+3) == '/')
            {
                p2 += 3;

                do {
                    p--;

                    if(p < tmp4) {
                        strcpy(path2, "/");
                        return FALSE;
                    }
                } while(*p != '/');

                *p = 0;
            }
            else if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) == '.' 
                && *(p2+3) == 0) 
            {
                do {
                    p--;

                    if(p < tmp4) {
                        strcpy(path2, "/");
                        return FALSE;
                    }
                } while(*p != '/');

                *p = 0;
                break;
            }
            else {
                *p++ = *p2++;
            }
        }
        *p = 0;
    }

    if(*tmp4 == 0) {
        strcpy(path2, "/");
    }
    else {
        strcpy(path2, tmp4);
    }

    return TRUE;
}

