/*
 * 文字列ライブラリ
 */

#ifndef MINATO_STRING_H
#define MINATO_STRING_H

#include "saphire_kanji.h"

/* 文字列オブジェクト */
typedef struct
{
    char* mStr;
    int mLen;

    int mMallocLen;
} string_obj;

//////////////////////////////////////////////////////////////////////
// 関数定義
//////////////////////////////////////////////////////////////////////

// 初期化
#ifdef MDEBUG

string_obj* string_new_debug(char* str, const char* fname, int line, const char* func_name);
#define STRING_NEW(str) string_new_debug(str, __FILE__, __LINE__, __FUNCTION__)

#else

string_obj* string_new(char* str);
#define STRING_NEW(str) string_new(str)

#endif


void string_delete(string_obj* str);                    // 解放

#define string_length(o) ((string_obj*)o)->mLen
#define string_size(o) ((string_obj*)o)->mLen

//int string_length(string_obj* obj);                     // 文字列数を返す
//int string_size(string_obj* obj);                       // 文字列数を返す
/*
//////////////////////////////////////////////////////////////////////
// 文字列数を返す
//////////////////////////////////////////////////////////////////////
int string_length(string_obj* obj)
{
    return obj->mLen;
}
*/
char* string_c_str(string_obj* obj);                    // c文字列のポインタを返す

#define string_c_str(o) ((string_obj*)o)->mStr

/*
//////////////////////////////////////////////////////////////////////
// 文字列数を返す
//////////////////////////////////////////////////////////////////////
char* string_c_str(string_obj* obj)
{
    return obj->mStr;
}
*/

void string_push_back(string_obj* self, char* key);     // 後ろから文字列を追加
void string_push_back2(string_obj* self, char key);     // 後ろから文字を追加
void string_push_back3(string_obj* self, char* str, int n);
                                                        // 後ろから文字を追加
                                                        // strのnバイトだけ
void string_put(string_obj* self, char* str);           // 文字列を代入

void string_put2(string_obj* self, char c);             // 文字を代入

void string_trunc(string_obj* self, int n);             // 文字列を短くする
// n文字列までが有効になる

void string_insert(string_obj* obj, int pos, char* str);    // 文字列をposの位置に追加
void string_erase(string_obj* obj, int pos, int len);       // 文字列をposの位置からlenだけ削除

void string_toupper(string_obj* self);                  // 大文字にする
void string_tolower(string_obj* self);                  // 小文字にする

#endif
