/*
 * XgReiCu
 */

#ifndef MINATO__LIST_H
#define MINATO__LIST_H

#define BOOL int
#define TRUE 1
#define FALSE 0

/* XgIuWFNg */
typedef struct _list_it {
   void* mItem;
   
   struct _list_it* mPrevIt;
   struct _list_it* mNextIt;
} list_it;

typedef struct {
   list_it* mEntryIt;
   list_it* mLastIt;
   int mCount;
} list_obj;

///////////////////////////////////////////////////////////////////////
// ֐錾
///////////////////////////////////////////////////////////////////////
// 
#ifdef MDEBUG

list_obj* list_new_debug(const char* fname, int line, const char* func_name);
#define LIST_NEW() list_new_debug(__FILE__, __LINE__, __FUNCTION__)

#else

list_obj* list_new();
#define LIST_NEW() list_new()

#endif

void list_delete(list_obj* self);       // 

int list_size(list_obj* self);                      // TCY
BOOL list_empty(list_obj* self);                    // 󂩂ǂ
int list_index_of(list_obj* self, void* item);      // ACẽCfbNX
void list_push_front(list_obj* self, void* item);   // ACeOǉ
void list_push_back(list_obj* self, void* item);    // ACe납ǉ
void* list_pop_front(list_obj* self);               // OACeo
void* list_pop_back(list_obj* self);                // 납ACeo
void list_clear(list_obj* self);                    // ACeNA

list_it* list_begin(list_obj* self);                // 擪̃XgCe[^[o
list_it* list_last(list_obj* self);                 // Ō̃XgCe[^[o
list_it* list_at(list_obj* self, int index);        // Cӂ̏ꏊ̃XgCe[^[肾
list_it* list_find(list_obj* self, void* item);     // ̃ACẽCe[^[o
void* list_item(list_it* self);                     // Ce[^[ACeo
list_it* list_next(list_it* self);                  // Ce[^[玟̃Ce[^[o
list_it* list_prev(list_it* self);                  // Ce[^[ÕCe[^[o
void list_replace(list_it* self, void* item);       // Ce[^[̃ACeu
void list_erase(list_it* self, list_obj* owner);    // Ce[^[̃ACe폜
void list_insert_front(list_it* self, void* item, list_obj* owner);     // Ce[^[̑OɃACeǉ
void list_insert_back(list_it* self, void* item, list_obj* owner);      // Ce[^[̌ɃACeǉ

/*
    S
    
    for(list_it* i=list_begin(gList); i; i=list_next(i)) {
        sItem* item = (sItem*)list_item(i);
    }
*/

#endif
