/*
 * $Id: commons.h,v 1.6 2004/06/28 09:51:09 jklein Exp $
 * $Author: jklein $
 * $Log: commons.h,v $
 * Revision 1.6  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.5  2004/06/26 06:58:13  jklein
 * small fix in each header files.
 *
 * Revision 1.4  2004/06/24 15:16:50  jklein
 * sxarray_t was added for abstruction of collection structure.
 *
 * Revision 1.3  2004/06/24 00:08:35  jklein
 * added s_buffer_compare()
 *
 * Revision 1.2  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 * Revision 1.1  2004/06/21 11:28:00  jklein
 * Changed source tree.
 *
 * Revision 1.1.1.1  2004/06/21 09:29:33  jklein
 * import scale
 *
 */

/**
   <p>Scale$B%i%$%V%i%j6&DL$N%G!<%?7?$dHFMQ4X?t$rDj5A$7$F$$$^$9!#FC$K(B
   $BJ#;($J$b$N$OL5$$$,!"%V!<%j%"%s7?$rI=$9(Bsboolean$B$H$$$&7?$,$"$k$3$H$O(B
   $BCN$C$F$*$$$?J}$,NI$$$G$7$g$&!#$3$l$O(Btrue$B$H(Bfalse$B$H$$$&??56CM$r07$&(B
   $B7?$G$9!#(B</p>

   <p>$B$"$H$O(Bsint32$BEy$N%S%C%H?t;XDj$N3F<o(Bint$B7?$d(Bchar$B7?$,Dj5A$5$l$F$$$^$9!#(B</p>
*/

#ifndef _SCALE_COMMONS_H_
#define _SCALE_COMMONS_H_

#include "scale/config.h"
#include <stdlib.h>


#if HAVE_STRING_H
#  include <string.h>
#else
#  include <strings.h>
#endif


/** all of primitive types for SC libraries. */
typedef void * spointer;

#if HAVE_STDBOOL_H
enum {
	false = 0,
	true = 1
};

typedef bool sboolean
#else
typedef enum {
	false = 0,
	true = 1
} sboolean;
#endif


#if ! HAVE_STDINT_H

typedef signed char	int8_t;
typedef short int   int16_t;
typedef int         int32_t;

typedef unsigned char      uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned int       uint32_t;

#else
#  include <stdint.h>
#endif

typedef int		sint;
typedef int8_t  sint8;
typedef int16_t sint16;
typedef int32_t sint32;

typedef unsigned int	suint;
typedef uint8_t			suint8;
typedef uint16_t		suint16;
typedef uint32_t		suint32;

typedef char			schar;
typedef unsigned char	suchar;

typedef short			sshort;
typedef unsigned short	sushort;

typedef long			slong;
typedef unsigned		sulong;

typedef float	sfloat;
typedef double  sdouble;


/**
 * Scale$B%i%$%V%i%jCf$G;HMQ$5$l$kHf3S4X?t!#(B
 * $BJV$jCM$O(Bp1$B$NJ}$,Bg$-$$$H$-$O@5$N?t!"Ey$7$$$H$-$O(B0$B!"(Bp2$B$NJ}$,Bg$-$$$H$-$O(B
 * $BIi$N?t$rJV$7$^$9!#(B
 */
typedef sint8 (*sc_compf_t)(const spointer p1, const spointer p2);


/** (char *)$B$I$&$7$NHf3S$r9T$J$&!#(B */
sint8 s_string_compare(const spointer, const spointer);

/** (char *)$B$I$&$7$NHf3S$r9T$J$&$,!"JV$jCM$ODL>o$N5U$K$J$k!#(B */
sint8 s_string_rcompare(const spointer, const spointer);

/** sbuffer_t$B$I$&$7$NHf3S$r9T$J$&!#(B */
sint8 s_buffer_compare(const spointer, const spointer);

/** sbuffer_t$B$I$&$7$NHf3S$r9T$J$&$,!"JV$jCM$O5U$K$J$k!#(B */
sint8 s_buffer_rcompare(const spointer, const spointer);

/** $B%]%$%s%?$I$&$7$NHf3S$r9T$J$&!#(B */
sint8 s_pointer_compare(const spointer, const spointer);

#endif /* _SCALE_COMMONS_H_ */
