﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;

namespace SCFiler2.Action {
	public class CopyToClipboard : Action {
		public override string DisplayString {
			get { return "クリップボードへコピー"; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				FileView view = main_form.getLastFocusedFileView();
				if (view.SelectedFilerItems.Count == 0) {
					SCFiler2System.showTempMessage("ファイルが選択されていません");
					return;
				}

				ClipboardManager.sendToClipboard(ClipboardManager.EffectType.Copy, view.SelectedFilerItems);
				SCFiler2System.showTempMessage("選択アイテムをクリップボードにコピーしました");
				main_form.checkUpdateAllView();
			} else {
				//何もしない
			}
		}
	}
}
