using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace SCFiler2 {
	/// <summary>
	/// t@Cr[ŎgReLXgj[BVOg
	/// </summary>
	public class FileViewContextMenu {
		static private FileViewContextMenu instance = new FileViewContextMenu();
		static public FileViewContextMenu Instance {
			get { return instance; }
		}

		private ContextMenu context_menu = new ContextMenu();
		public ContextMenu ContextMenu {
			get { return context_menu; }
		}

		private FileViewContextMenu() {
			constructContextMenu();
		}

		private void constructContextMenu() {
			string sendto_folder = Environment.GetFolderPath(Environment.SpecialFolder.SendTo);
			string[] files = System.IO.Directory.GetFiles(sendto_folder);
			MenuItem sendto_items = new MenuItem("SendTo(&S)");
			foreach (string file in files) {
				MenuItem item = new MenuItem(System.IO.Path.GetFileNameWithoutExtension(file));
				item.Tag = file;
				sendto_items.MenuItems.Add(item);
			}
			context_menu.MenuItems.Add(sendto_items);
		}
	}
}
