package Section::Detail;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;

sub new{
    shift;
    return bless Section::base->new(@_);
}
sub out{
  my $oS = shift;
  $oS->setHistoryStack('detail');
  $oS->oOut->setSubtitle('Detail');
  my @asIDs = $oS->oCGI->param('id');
  my $sRes = $oS->oOut->sectionBegin('DETAIL','detail');
  if(scalar(@asIDs) == 0){
    $sRes .= '<p>'.$oS->getEncLng('DETAIL_NOTHING_TO_SHOW').'</p>';
  }else{
    $sRes .= '<form method="POST" action="index.cgi"><input type="hidden" name="mode" value="edit"><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'" />';
    my $isOnlyOne = scalar(@asIDs)==1;
    my $nEditableSches = 0;
    my $oGF = Section->new('GlobalFormat::1',$oS->env);
    foreach(@asIDs){
      my $oSche = $oS->oDat->getScheByID($_);
      next if !defined $oSche or !defined $oSche->changeables->[0];
      my $sCheck;
      if($oS->oLgi->isLoggedIn and !defined $oS->oDat->getScheByIDFrom($_,'imported')){
	if($isOnlyOne){
	  $sCheck .= qq|<input type="hidden" name="id" value="$_" />|;
	}else{
	  $sCheck = qq|<input type="checkbox" name="id" value="$_" checked="checked" />|;
	}
	$nEditableSches++;
      }else{
	if(!$isOnlyOne){
	  $sCheck = qq|<input type="checkbox" disabled="disabled" />|;
	}
      }
      $sRes .= qq|<h3>$sCheck$_</h3>|;
      $sRes .= '<div class="sche2"><a href="index.cgi?mode=xsche&id='.$_.'"><span class="xsche">'.$oS->getEncLng('XSCHE').'</span></a></div>';
      $sRes .= $oGF->out($oSche->changeables->[0]);
      $sRes .= '<h4>'.$oS->getEncLng('REVISIONS').'</h4>';
      $sRes .= '<ol class="revisions">';
      foreach(@{$oSche->changeables}){
	my $sTime = $_->modified->ISO8601;
	my @aoAuthors = @{$_->authors};
	my @asAuthors = ();
	foreach(@aoAuthors){
	  my ($sMail,$sURI);
	  $sMail = $_->email;
	  $sURI = $_->uri;
	  my $sName = $oS->oOut->encoded($_->name);
	  $sName = '<a href="mailto:'.$sMail.'">'.$sName.'</a>' if defined $sMail;
	  $sName .= ' <a href="'.$sURI.'">['.$sURI.']</a>' if defined $sURI;
	  push(@asAuthors,$sName);
	}
	$sRes .= '<li>'.$sTime.' : '.join(',',@asAuthors).'</li>';
      }
      $sRes .= '</ol>';
    }
    if($nEditableSches){
      my $sButtonMessage = $nEditableSches==1
	?$oS->getEncLng('EDIT_THIS_SCHEDULE')
	  :$oS->getEncLng('EDIT_THE_SCHEDULES_CHECKED');
      $sRes .= qq|<input type="submit" value="$sButtonMessage" /></form>|;
    }
  }
  return $sRes.$oS->oOut->sectionEnd;
}

1;
