package Scheduler::Data::XML::Sche;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Sche;
use Scheduler::Data::XML::base;
use Scheduler::Data::XML::Generator;
use Scheduler::Data::XML::Sche::Changeable;

sub obj($$){
  shift;
  my $oSche = new Scheduler::Sche;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'id'){
      $oSche->setId($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'generator'){
      $oSche->setGenerator(Scheduler::Data::XML::Generator->obj($_,$oDocument));
    }
  }
  my @aoURIs = $oRoot->getChildrenByTagName('link');
  foreach(@aoURIs){
    $oSche->addURI($_->getAttribute('href'));
  }
  my @aoChangeables = $oRoot->getChildrenByTagName('changeable');
  foreach(@aoChangeables){
    $oSche->addChangeable(Scheduler::Data::XML::Sche::Changeable->obj($_,$oDocument));
  }
  return $oSche;
}
sub element($$){
  shift;
  my $oSche = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement("sche");
  $oRoot->setAttribute('version','2');
  my $oID = $oDocument->createElement("id");
  $oID->appendText($oSche->id);
  $oRoot->appendChild($oID);
  $oRoot->appendChild(Scheduler::Data::XML::Generator->element($oSche->generator,$oDocument));
  foreach(@{$oSche->uris}){
    my $oURI = $oDocument->createElement("link");
    $oURI->setAttribute("href",$_);
    $oRoot->appendChild($oURI);
  }
  foreach(@{$oSche->changeables}){
    $oRoot->addChild(Scheduler::Data::XML::Sche::Changeable->element($_,$oDocument));
  }
  $oRoot->setNamespace('http://www.w3.org/2007/sche');
  return $oRoot;
}

1;
