package Scheduler::Data::XML::Sche::Location;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Data::XML::Sche::Location::GPX;
use Scheduler::Data::XML::Sche::Location::Name;

sub obj($$){
  shift;
  my $oRoot = shift;
  my $oDocument = shift;
  my $oLocation;
  my $oElement = $oRoot->firstChild;
  if($oElement->localname eq 'gpx'){
    $oLocation = Scheduler::Data::XML::Sche::Location::GPX->obj($oElement,$oDocument);
  }elsif($oElement->localname eq 'name'){
    $oLocation = Scheduler::Data::XML::Sche::Location::Name->obj($oElement,$oDocument);
  }
  return $oLocation;
}
sub element($$){
  shift;
  my $oLocation = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('location');
  if($oLocation->type eq 'gpx'){
    $oRoot->addChild(Scheduler::Data::XML::Sche::Location::GPX->element($oLocation,$oDocument));
  }elsif($oLocation->type eq 'name'){
    $oRoot->addChild(Scheduler::Data::XML::Sche::Location::Name->element($oLocation,$oDocument));
  }
  return $oRoot;
}

1;
