package Login;

use strict;
use warnings;
use Carp;

use CGI::Session qw|-ip_match|;

use Digest;

{
  my $isLoggedIn;

  sub new{
    shift;
    my %hE = @_;
    if(!-e $hE{sessionIDDir} || !-d $hE{sessionIDDir}){
      unlink($hE{sessionIDDir});
      mkdir($hE{sessionIDDir});
      chmod(0777,$hE{sessionIDDir});
    }
    my $oS = bless {
		    oCGI => $hE{oCGI},
		    sessionIdDir => $hE{sessionIDDir},
		    userName => $hE{userName},
		    userPass => $hE{userPass},
		    userPassDigest => $hE{userPassDigest},
		    userPassDigestAlgo => $hE{userPassDigestAlgo},
		    sessionCookies => [],
		    sessionId => undef,
		    identifier => $hE{identifier},
		   };
    $oS->isLoggedIn;
    return $oS;
  }
  sub oCGI{$_[0]->{oCGI};}
  sub isUserValid{
    my $oS = shift;
    my ($sUser,$sPass) = @_;
    return 0 if !defined $sUser or !defined $sPass;
    if(defined $oS->{userName}){
      if(defined $oS->{userPass}){
	return ($sUser eq $oS->{userName} && $sPass eq $oS->{userPass});
      }else{
	return ($sUser eq $oS->{userName} && lc($oS->digest($sPass)) eq lc($oS->{userPassDigest}));
      }
    }else{
      return 1;
    }
  }
  sub digest{
    my $oS = shift;
    my $sTarget = shift;
    my $oDigester = new Digest(uc($oS->{userPassDigestAlgo}));
    $oDigester->add($sTarget);
    return $oDigester->hexdigest;
  }
  sub isLoggedIn{
    my $oS = shift;
    if(!defined $oS->{userName}){
      $isLoggedIn = 1;
    }
    if(!defined $isLoggedIn){
      $isLoggedIn = 0;
      my $sSID = $oS->oCGI->cookie('CGISESSID'.$oS->{identifier}) || $oS->oCGI->param('sid') || undef;
      if(defined $sSID){
	$sSID = undef if $sSID eq '';
      }
      my $oSession = new CGI::Session(undef,$sSID,{Directory => $oS->{sessionIDDir}});
      if(defined $sSID && $sSID eq $oSession->id){
	$isLoggedIn = 1;
	$oS->{sessionId} = $oSession->id;
      }elsif(defined $sSID && $sSID ne $oSession->id){
	$oSession->close;
	$oSession->delete;
	$oS->{sessionId} = '';
      }
    }
    my $oCookie = $oS->oCGI->cookie(-name => 'CGISESSID'.$oS->{identifier},
				    -value => $oS->{sessionId},
				    -expires => '+1h',
				   );
    push(@{$oS->{sessionCookies}},$oCookie);
    return $isLoggedIn || 0;
  }
  sub killCookie{
    my $oS = shift;
    my $oCookie = $oS->oCGI->cookie(-name => 'CGISESSID'.$oS->{identifier},
				    -value => '',
				    -expires => '+0h',
				   );
    push(@{$oS->{sessionCookies}},$oCookie);
    $isLoggedIn = 0;
  }
  sub killSession{
    my $oS = shift; 
    if($isLoggedIn){
      my $oSession = new CGI::Session(undef,$oS->{sessionId},{Directory => $oS->{sessionIDDir}});
      $oSession->close;
      $oSession->delete;
    }
    $isLoggedIn = 0;
  }
  sub login{
    my $oS = shift;
    if(!$isLoggedIn){
      my $oSession = new CGI::Session(undef,undef,{Directory=>$oS->{sessionIDDir}});
      $oSession->expire('+1h');
      my $oCookie = $oS->oCGI->cookie(-name => 'CGISESSID'.$oS->{identifier},
				      -value => $oSession->id,
				      -expires => '+1h',
				     );
      push(@{$oS->{sessionCookies}},$oCookie);
      $oS->{sessionId} = $oSession->id;
    }
  }
  sub sessionCookies{
    my $oS = shift;
    return @{$oS->{sessionCookies}};
  }
  sub sessionId{
    $_[0]->{sessionId};
  }
}

1;
