package Section::Duplicate;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;
use Scheduler::Schema::TimeOptimized;
use Date::Calc qw|Add_Delta_Days Add_Delta_YM Days_in_Month Day_of_Week Today Delta_YMDHMS Add_Delta_YMDHMS|;

use constant NUMBERS_OF_YEAR_AS_ERROR => 5;

sub new{
  shift;
  return bless Section::base->new(@_);
}
sub out{
  my $oS = shift;
  my $sMode = $oS->oCGI->param('duplicate');
  my $sRes = $oS->oOut->sectionBegin('DUPLICATE','duplicate');
  if(!defined $sMode){
    $sRes .= $oS->outSetting;
  }elsif($sMode eq 'preview'){
    $sRes .= $oS->outPreview;
  }elsif($sMode eq 'generate'){
    $sRes .= $oS->outGenerate;
  }
  return $sRes.$oS->oOut->sectionEnd;
}
sub outSetting{
  my $oS = shift;
  $oS->setHistoryStack('duplicate:setting');
  $oS->oOut->isUsingPrototypeJS;
  my $sHeader = '<script type="text/javascript">
//<![CDATA[
';
  $sHeader .= $_ while <DATA>;
  $sHeader .= '//]]></script>';
  $oS->oOut->addHeaderEx($sHeader);undef $sHeader;
  $oS->oOut->appendBodyTagAttribute('onload','load();');
  $oS->oOut->setSubtitle('Duplicate');
  my $sRes = '';
  my $sID = $oS->oCGI->param('id');
  my $oSche = $oS->oDat->getScheByID($sID);

  # These works are for new sches(set the time NOW for time_begin and time_end)
  my @hnYearNow;
  my %hTime;
  my $isBegin;
  if(defined $oSche->changeables->[0]->time->begin){
    $isBegin = 1;
    @hTime{qw|year month day hour minute second|} = $oSche->changeables->[0]->time->begin->YMDHMS;
  }else{
    $isBegin = 0;
    @hTime{qw|year month day hour minute second|} = $oSche->changeables->[0]->time->end->YMDHMS;
  }
  $hnYearNow[0] = $hTime{year};
    
  # The years are choosable from plusminus NUMBERS_OF_YEAR_AS_ERROR years from today
  my $nBaseYear = $hnYearNow[0];
  foreach(1..NUMBERS_OF_YEAR_AS_ERROR){
    push(@hnYearNow,$nBaseYear+$_);
    unshift(@hnYearNow,$nBaseYear-$_);
  }
  my $oGF = Section->new('GlobalFormat::1',$oS->env);
  $sRes .= '<p>'.$oS->getEncLng('DUPLICATE_TARGET_IS_SHOWN_BELOW').'</p>'.$oGF->out($oSche->changeables->[0]).'<form method="post" action="index.cgi"><input type="hidden" name="mode" value="duplicate" /><input type="hidden" name="duplicate" value="preview" /><input type="hidden" name="id_target" value="'.$sID.'" /><input type="radio" name="selection_type" value="calendar" checked="checked" onclick="setSelectionType(\'calendar\');" />'.$oS->getEncLng('DUPLICATE_SELECTION_TYPE_CALENDAR').'<input type="radio" name="selection_type" value="cycle" onclick="setSelectionType(\'cycle\');" />'.$oS->getEncLng('DUPLICATE_SELECTION_TYPE_CYCLE').'<div name="duplicate_type_cycle" id="duplicate_type_cycle"><fieldset><legend>'.$oS->getEncLng('DUPLICATE_SET_PARAMS').'</legend>
';
  $sRes .= '<input type="hidden" name="is_begin" value="1" />' if $isBegin;
  $sRes .= '<p>'.$oS->getEncLng('DUPLICATE_TIMES').'<input type="text" name="times" value="1" /></p>
<p>'.$oS->getEncLng('DUPLICATE_BEGIN_TIME').'</p>';

  # Year
  $sRes .= q|<select name="point_time_year">|;
  foreach(@hnYearNow){
    $sRes .= qq|<option value="$_"|;
    $sRes .= q| selected="selected"| if $nBaseYear == $_;
    $sRes .= qq|>$_</option>|;
  }
  
  # Month
  $sRes .= q|</select>/<select name="point_time_month">|;
  foreach(1..12){
    $sRes .= qq|<option value="$_"|;
    $sRes .= q| selected="selected"| if $hTime{month} == $_;
    $sRes .= qq|>$_</option>|;
  }
  
  # Day
  $sRes .= q|</select>/<select name="point_time_day">|;
  foreach(1..31){
    $sRes .= qq|<option value="$_"|;
    $sRes .= q| selected="selected"| if $hTime{day} == $_;
    $sRes .= qq|>$_</option>|;
  }
  
  # Hour
  $sRes .= q|</select><select name="point_time_hour">|;
  foreach(0..23){
    $sRes .= qq|<option value="$_"|;
    $sRes .= q| selected="selected"| if $hTime{hour} == $_;
    $sRes .= qq|>$_</option>|;
  }
  
  # Minute and second
  $sRes .= q|</select>:<input type="text" name="point_time_minute" size="2" maxlength="2" value="|
    .$hTime{minute}
      .q|" />:<input type="text" name="point_time_second" size="2" maxlength="2" value="|.
	$hTime{second}
	  .q|" /></p>|;

  $sRes .= '<p>'.$oS->getEncLng('DUPLICATE_CYCLE').'</p><p>';

  # Day
  $sRes .= q|<input type="type" name="cycle_time_day" value="1"/>|.$oS->getEncLng('DUPLICATE_CYCLE_DAYS');
  my $sCalendar = '';
  my ($nYe,$nMo) = &Today;
  foreach(0..12){
    my ($nYeA,$nMoA) = &Add_Delta_YM($nYe,$nMo,1,0,$_);
    $sCalendar .= $oS->generateCalendarFor($nYeA,$nMoA);
  }
  return $sRes.'</p></fieldset></div><div name="duplicate_type_calendar" id="duplicate_type_calendar">'.$sCalendar.'</div><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'"><input type="submit" value="'.$oS->getEncLng('DUPLICATE_GENERATE').'" /></form>';
}
sub outPreview{
  my $oS = shift;
  $oS->setHistoryStack('duplicate:preview');
  my $sRes = '';
  my $oGF = new Section('GlobalFormat::1',$oS->env);
  my $oSche = $oS->oDat->getScheByID($oS->oCGI->param('id_target'));
  $sRes .= $oGF->out($oSche->changeables->[0]);
  $sRes .= '<p>'.$oS->getEncLng('DUPLICATE_IS_THIS_PARAM_OK').'</p>
<table><thead><th>'.$oS->getEncLng('TIME_BEGIN').'</th><th>'.$oS->getEncLng('TIME_END').'</th></thead><tbody>';
  foreach(@{[$oS->getDuplicated]}){
    $sRes .= '<tr><td>'.$oS->timeDisp($_->time->begin)
     .'</td><td>'.$oS->timeDisp($_->time->end).'</td></tr>';
  }
  $sRes .= '</tbody></table><form method="post" action="index.cgi"><input type="hidden" name="mode" value="duplicate" /><input type="hidden" name="duplicate" value="generate" /><input type="submit" value="'.$oS->getEncLng('DUPLICATE_GENERATE').'" /><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'">';
  $sRes .= '<input type="hidden" name="'.$_.'" value="'.$oS->oCGI->param($_).'" />'
    foreach qw|id_target is_begin times cycle_time_day point_time_year point_time_month point_time_day point_time_hour point_time_minute point_time_second selection_type|;
  foreach($oS->oCGI->param){
    if($_ =~ m|^n_check_\d\d\d\d-\d\d-\d\d$|){
      $sRes .= '<input type="hidden" name="'.$_.'" value="'.$oS->oCGI->param($_).'" />';
    }
  }
  return $sRes.'</form>';
}
sub outGenerate{
  my $oS = shift;
  my $sRes = '';
  $oS->setHistoryStack('duplicate:updated');
  $sRes .= '<p>'.$oS->getEncLng('DUPLICATE_UPDATED').'</p>';
  foreach(@{[$oS->getDuplicated]}){
    my $oSche = new Scheduler::Schema::Sche;
    $_->setGenerator($oS->getGenerator);
    $oSche->addChangeable($_);
    $oS->oDat->setSche($oSche,0,$oS->oEnv->storageURI.'?mode=xsche&amp;id=');
  }
  return $sRes.'<a href="javascript:history.go(-'.$oS->distanceToList.')">'.$oS->getEncLng('BACK_TO_LIST').'</a>';
}
sub getDuplicated{
  my $oS = shift;
  my $oSche = $oS->oDat->getScheByID($oS->oCGI->param('id_target'));
  my $sUsingSelectionType = $oS->oCGI->param('selection_type');
  my ($oTime1,$oTime2,$oBTime1,$oBTime2);
  # Included in "$oTime*","$oBTime*"
  # - both begin,end is defined : 1=begin 2=end
  # - only begin is defined     : 1=begin 2=undef
  # - only end is defined       : 1=end   2=undef
  ($oBTime1,$oBTime2) = (
			 $oSche->changeables->[0]->time->begin,
			 $oSche->changeables->[0]->time->end,
			);
  my $isBegin = $oS->oCGI->param('is_begin') || 1;
  if(!$isBegin){
    ($oBTime1,$oBTime2) = ($oBTime2,$oBTime1);
  }
  if($sUsingSelectionType eq 'cycle'){
    my $nTimes = $oS->oCGI->param('times');
    my $nDeltaDays = $oS->oCGI->param('cycle_time_day');
    $oTime1 = new Scheduler::Schema::TimeOptimized;
    $oTime1->setYMDHMS(
		       $oS->oCGI->param('point_time_year'),
		       $oS->oCGI->param('point_time_month'),
		       $oS->oCGI->param('point_time_day'),
		       $oS->oCGI->param('point_time_hour'),
		       $oS->oCGI->param('point_time_minute'),
		       $oS->oCGI->param('point_time_second'),
		      );
    if($isBegin && defined $oBTime2){
      $oTime2 = new Scheduler::Schema::TimeOptimized;
      $oTime2->setTime($oTime1->time + $oBTime2->time - $oBTime1->time);
    }
    if($oBTime1->time == $oTime1->time){
      $oS->addDeltaDaysTo($oTime1,$oTime2,$nDeltaDays);
    }
    my @aoChangeables = ();
    for(1..$nTimes){
      my $oDChangeable = $oSche->changeables->[0]->clone;
      my ($oFTime1,$oFTime2) = ($oTime1,$oTime2);
      ($oFTime1,$oFTime2) = ($oFTime2,$oFTime1) if !$isBegin;
      $oDChangeable->time->setBegin($oFTime1->clone) if defined $oFTime1;
      $oDChangeable->time->setEnd($oFTime2->clone) if defined $oFTime2;
      $oDChangeable->time->killEnd if($isBegin && !defined $oFTime2);
      $oDChangeable->time->killBegin if(!$isBegin);
      push(@aoChangeables,$oDChangeable);
      $oS->addDeltaDaysTo($oTime1,$oTime2,$nDeltaDays);
    }
    return @aoChangeables;
  }else{
    my @anDeltaTime;
    if($isBegin and defined $oBTime1 and defined $oBTime2){
      @anDeltaTime = &Delta_YMDHMS($oBTime1->YMDHMS,$oBTime2->YMDHMS);
    }
    my ($nHo,$nMi,$nSe);
    (undef,undef,undef,$nHo,$nMi,$nSe) = $oBTime1->YMDHMS;
    my @asDates = grep{$_ =~ m|^n_check_\d\d\d\d-\d\d-\d\d$|} $oS->oCGI->param;
    foreach(@asDates){
      $_ =~ m|(\d\d\d\d)-(\d\d)-(\d\d)$|;
      my ($nYe,$nMo,$nDa) = ($1,$2,$3);
      my $oDChangeable = $oSche->changeables->[0]->clone;
      if(!$isBegin){
	$oDChangeable->time->end->setYMDHMS($nYe,$nMo,$nDa,$nHo,$nMi,$nSe);
	$oDChangeable->time->killBegin;
      }else{
	$oDChangeable->time->begin->setYMDHMS($nYe,$nMo,$nDa,$nHo,$nMi,$nSe);
	if(defined $oBTime2){
	  my @anAddedTime = &Add_Delta_YMDHMS($nYe,$nMo,$nDa,$nHo,$nMi,$nSe,@anDeltaTime);
	  $oDChangeable->time->end->setYMDHMS(@anAddedTime);
	}else{
	  $oDChangeable->time->killEnd;
	}
      }
      $_ = $oDChangeable;
    }
    return @asDates;
  }
}
sub addDeltaDaysTo($$$){
  my $oS = shift;
  $_[0] = $oS->addDeltaDays($_[0],$_[2]);
  $_[1] = $oS->addDeltaDays($_[1],$_[2]) if defined $_[1];
}
sub addDeltaDays($$){
  shift;
  my ($oTime,$nDeltaDays) = @_;
  my ($ye,$mo,$da,$ho,$mi,$se) = $oTime->YMDHMS;
  ($ye,$mo,$da) = &Add_Delta_Days($ye,$mo,$da,$nDeltaDays);
  $oTime->setYMDHMS($ye,$mo,$da,$ho,$mi,$se);
  return $oTime;
}
sub generateCalendarFor($$){
  my $oS = shift;
  my ($nYe,$nMo) = @_;
  my $nTotalDays = &Days_in_Month($nYe,$nMo);
  my $nCyclePos = &Day_of_Week($nYe,$nMo,1) % 7;
  my $sRes = '<table class="calendar"><thead><tr><th colspan="7">'.$nYe.'/'.$nMo.'</th></tr><tr><th>S</th><th>M</th><th>T</th><th>W</th><th>T</th><th>F</th><th>S</th></tr></thead><tbody>';
  my @anDays;
  push(@anDays,'') foreach(0..$nCyclePos-1);
  my $nDayTmp = 6-$nCyclePos;
  push(@anDays,$_) foreach(1..$nDayTmp+1);
  $sRes .= $oS->generateCalendarRowFor($nYe,$nMo,@anDays);
  @anDays = ();
  my $nDayPos;
  foreach($nDayTmp+2..$nTotalDays){
    $nDayPos = &Day_of_Week($nYe,$nMo,$_) % 7;
    $anDays[$nDayPos] = $_;
    if($nDayPos == 6){
      $sRes .= $oS->generateCalendarRowFor($nYe,$nMo,@anDays);
      @anDays = ();
    }
  }
  push(@anDays,'') foreach($nDayPos..6);
  $sRes .= $oS->generateCalendarRowFor($nYe,$nMo,@anDays);
  return $sRes.'</tbody></table>';
}
sub generateCalendarRowFor($$@){
  my $oS = shift;
  my ($nYe,$nMo,@anDays) = @_;
  my $sRes = '<tr>';
  foreach(@anDays){
    if($_ ne ''){
      $sRes .= '<td><input type="checkbox" name="n_check_'.sprintf('%04d-%02d-%02d',$nYe,$nMo,$_).'" />'.$_.'</td>';
    }else{
      $sRes .= '<td></td>';
    }
  }
  return $sRes .= '</tr>';
}

1;

__DATA__

  function load(){
    setSelectionType("calendar");
  }
function setSelectionType(_sType){
  if(_sType == "cycle"){
    $("duplicate_type_cycle").show();
    $("duplicate_type_calendar").hide();
  }else{
    $("duplicate_type_cycle").hide();
    $("duplicate_type_calendar").show();
  }
}
