package Section::Edit;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;
use CGI::Cookie;
use Date::Calc qw|Today_and_Now|;

use Scheduler::Schema::Content;

use constant NUMBERS_OF_YEAR_AS_ERROR => 5;

sub new{
    shift;
    return bless Section::base->new(@_);
}
sub out($){
    my $oS = shift;
    $oS->oOut->setSubtitle('Edit');
    my @asEditIDs = $oS->oCGI->param('id');
    my $sRes = '';
    my %hsIDs;
    foreach(@asEditIDs){
	next if exists $hsIDs{$_};
	$hsIDs{$_} = $oS->oDat->getScheByID($_);
	delete $hsIDs{$_} if !defined $hsIDs{$_};
    }
    my $nNewScheNum = $oS->oCGI->param('edit_new_sche_num') || 0;
    my $sMultiEditingMethod = $oS->oCGI->param('edit_multi_editing_method');
    if($nNewScheNum+scalar(keys %hsIDs) > 1 && !defined $sMultiEditingMethod){
	$sRes .= $oS->chooseMultiEditingMethod($nNewScheNum,%hsIDs);
    }else{
	if(defined $sMultiEditingMethod and $sMultiEditingMethod eq 'integrated'){
	    $sRes .= $oS->outIntegrated($nNewScheNum,%hsIDs);
	}else{
	    $sRes .= $oS->outSeparate($nNewScheNum,%hsIDs);
	}
    }
    return $sRes;
}
sub chooseMultiEditingMethod($%){
    my $oS = shift;
    $oS->setHistoryStack('edit:multi');
    my ($nMEM,%hsNEO) = @_;
    my $sRes = $oS->oOut->sectionBegin('EDIT','edit');
    $sRes .= '<table><thead><tr><th>ID</th><th>Title</th></tr></thead><tbody>';
    $sRes .= "<tr><th>(New sche)</th><td>$nMEM sche(s)</td></tr>" if $nMEM > 0;
    foreach(sort {$a cmp $b} keys %hsNEO){
      if(!defined $oS->oDat->getScheByIDFrom($_,'imported')){
	$sRes .= "<tr><th>$_</th><td>".$oS->oOut->encoded($hsNEO{$_}->changeable->title)."</td>";
      }else{
	$sRes .= qq|<tr><th><span class="undefined">$_</span></th><td><span class="undefined">|.$oS->oOut->encoded($hsNEO{$_}->changeable->title)."</span></td>";
      }
    }
    $sRes .= '</tbody></table><p>'.$oS->getEncLng('EDIT_HOW_TO').'</p>';
    $sRes .= '<form method="post" action="index.cgi"><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'"><input type="hidden" name="mode" value="edit" /><input type="radio" name="edit_multi_editing_method" value="separate" checked="checked" />'
      .$oS->getEncLng('EDIT_HOW_TO_SEPARATE').' <input type="radio" name="edit_multi_editing_method" value="integrated" disabled="disabled" />'
	.$oS->getEncLng('EDIT_HOW_TO_AT_ONCE').'<input type="submit" value="'.$oS->getEncLng('EDIT_HOW_TO_IT_IS_ALL_RIGHT').'" />';
    $sRes .= qq|<input type="hidden" name="edit_new_sche_num" value="$nMEM">| if $nMEM > 0;
    $sRes .= qq|<input type="hidden" name="id" value="$_">| foreach keys %hsNEO;
    return $sRes.'</form>'.$oS->oOut->sectionEnd;
}
sub outIntegrated{
    my $oS = shift;
    my ($nMEM,%hsNEO) = @_;
    my $sRes = $oS->oOut->sectionBegin('EDIT','edit');
    return $sRes.'</form>'.$oS->oOut->sectionEnd;
}
sub outSeparate{
    my $oS = shift;
    $oS->setHistoryStack('edit');
    my ($nMEM,%hsNEO) = @_;
    $oS->oOut->isUsingPrototypeJS;
    my $sHeader = '<script type="text/javascript">
//<![CDATA[
';
    $sHeader .= $_ while <DATA>;
    $sHeader .= '//]]></script>';
    $oS->oOut->addHeaderEx($sHeader);undef $sHeader;
    $oS->oOut->appendBodyTagAttribute('onload','load();');
    my $sRes = $oS->oOut->sectionBegin('EDIT','edit');
    $sRes .= q|<p>|.$oS->getEncLng('ASTERISK_FIELDS_ARE_REQUIRED').q|</p><form name="form" method="post" action="index.cgi"><input type="hidden" name="mode" value="preview" />|;

    # The unique numbers works as temporary IDs from 'edit' through 'update'
    my $nUniqNum = 0;
    while($nUniqNum < $nMEM){
	$sRes .= $oS->out1Sche(uniqNum => $nUniqNum++);
    }
    $sRes .= $oS->out1Sche(uniqNum => $nUniqNum++, sche=>$hsNEO{$_}) foreach sort keys %hsNEO;
    $sRes .= $oS->out1Sche(uniqNum => 0) if $nUniqNum == 0;
    my %hsAuthorName;
    @hsAuthorName{qw|name email uri|} = ($oS->getEncLng('NAME').'*',
					 $oS->getEncLng('EMAIL'),
					 $oS->getEncLng('URI'),
					);

    # Set forms for author information
    $sRes .= '<h3>'.$oS->getEncLng('AUTHOR_INFO')
      .'</h3><fieldset><legend>'.$oS->getEncLng('AUTHOR').'</legend>';
    my %hsCookies = fetch CGI::Cookie;
    my %hValues = ();
    if(exists $hsCookies{'SCHE_STORAGE_AUTHOR'}){
      %hValues = $hsCookies{'SCHE_STORAGE_AUTHOR'}->value;
    }
    foreach(qw|name email uri|){
      $hValues{$_} = '' if !defined $hValues{$_};
      $hsAuthorName{$_} = '' if !defined $hsAuthorName{$_};
      $sRes .= '<p>'.$hsAuthorName{$_}.' : <input type="text" name="n_author_'.$_.'" id="n_author_'.$_.'" onkeyup="canSubmit();" value="'.$hValues{$_}.'"></p>';
    }
    return $sRes.'<input type="checkbox" name="n_author_use_cookie" checked="checked" />'
      .$oS->getEncLng('USE_COOKIE').'</fieldset><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'"><input type="submit" name="submit_button" value="'.$oS->getEncLng('TO_PREVIEW').'" /></form>'.$oS->oOut->sectionEnd;
  }
sub out1Sche{
    my $oS = shift;
    my %hE = @_;
    my $oSche = $hE{sche};
    my $nUniqNum = $hE{uniqNum};
    return '' if !defined $nUniqNum;
    my %hsParams = ();
    my $sID;
    my @aoLocations;

    # Load sche if selected
    if(defined $oSche){
	$sID = $oSche->id;
	if(defined $oS->oDat->getScheByIDFrom($sID,'imported')){
	  return '';
	}
	my %hstTime;
	foreach my $sType(qw|begin end|){
	    $hstTime{$sType} = $oSche->changeable->time->{$sType};
	    $hsParams{'time_'.$sType.'_use'} = 0;
	    next if !defined $hstTime{$sType};
	    $hsParams{'time_'.$sType.'_use'} = 1;
	    my %hanTime;
	    @hanTime{qw|year month day hour minute second|} = $hstTime{$sType}->YMDHMS;
	    foreach(keys %hanTime){
		$hsParams{'time_'.$sType.'_'.$_} = $hanTime{$_};
	    }
	}
	$hsParams{title} = $oSche->changeable->title;
	$hsParams{subtitle} = $oSche->changeable->subtitle;
	$hsParams{summary} = $oSche->changeable->summary;
	@aoLocations = @{$oSche->changeable->locations};
	$hsParams{class} = $oSche->changeable->class;
	$hsParams{content} = $oSche->changeable->content;
	$hsParams{reloadinterval} = $oSche->changeable->reloadinterval;
$hsParams{accuracy} = $oSche->changeable->time->accuracy;
	foreach(@hsParams{qw|author_email author_uri|}){
	    $_ = '' if defined $_ and $_ eq '0';
	}
    }

    # These works are for new sches(set the time NOW for time_begin and time_end)
    my @hnYearNow;
    my %hTime;
    @hTime{qw|year month day hour|} = Today_and_Now();
    if(defined $hsParams{time_begin_year}){
	$hnYearNow[0] = $hsParams{time_begin_year};
    }else{
	$hnYearNow[0] = $hTime{year};
    }

    # The years are choosable from plusminus NUMBERS_OF_YEARS_AS_ERROR years from today
    my $nBaseYear = $hnYearNow[0];
    foreach(1..NUMBERS_OF_YEAR_AS_ERROR){
	push(@hnYearNow,$nBaseYear+$_);
	unshift(@hnYearNow,$nBaseYear-$_);
    }
    
    # New content
    foreach(keys %hsParams){
      next if $_ eq 'content';
      $hsParams{$_} = '' if !defined $hsParams{$_};
      $hsParams{$_} = $oS->oOut->encoded($hsParams{$_});
    }
    if(!defined $hsParams{content}){
      $hsParams{content} = new Scheduler::Schema::Content('plaintext');
    }

    # Editing sche id
    my $sScheTitle = defined $sID
      ?$sID
	:$oS->getEncLng('NEW_SCHE').' #'.($nUniqNum+1);
    my $sRes = qq|<h3>$sScheTitle</h3><script type="text/javascript">
//<![CDATA[
setMaxUniqNum($nUniqNum);
//]]></script>|;
    $sRes .= '<fieldset><legend>'.$oS->getEncLng('MAIN_CONTENTS').'</legend>';
    
    # Get encoded strings to display
    my %sName;
    @sName{qw|title subtitle summary content time_begin time_end|} = ($oS->getEncLng('TITLE').'*',
								      $oS->getEncLng('SUBTITLE'),
								      $oS->getEncLng('SUMMARY'),
								      $oS->getEncLng('CONTENT'),
								      $oS->getEncLng('TIME_BEGIN'),
								      $oS->getEncLng('TIME_END'),
								     );
    # Display title, subtitle, summary
    $sRes .= '<p>'.$sName{title}.' : <input class="longinput" type="text" name="n_'.$nUniqNum.'_title" id="n_'.$nUniqNum.'_title" onchange="canSubmit();" onkeyup="canSubmit();" value="'.$hsParams{title}.'" /></p>';
    $sRes .= '<p>'.$sName{subtitle}.' : <input class="longinput" type="text" name="n_'.$nUniqNum.'_subtitle" value="'.$hsParams{subtitle}.'" /></p>';
    $sRes .= '<p>'.$sName{summary}.' : <textarea class="longinput" name="n_'.$nUniqNum.'_summary">'.$hsParams{summary}.'</textarea></p>';
    
    # Display content
    $oS->oOut->appendBodyTagAttribute('onload','setContentEditForm('."$nUniqNum,'".$hsParams{content}->type."'".');');
    {
      $sRes .= '<p>'.$sName{content}.' : </p>';
      my %hInside = ();
      if($hsParams{content}->type eq 'plaintext'){
	$hInside{plaintext} = $oS->oOut->encoded($hsParams{content}->plainText);
      }elsif($hsParams{content}->type eq 'link'){
	$hInside{link} = $hsParams{content}->plainText;
      }
      foreach(qw|plaintext link xhtml|){
	$hInside{$_} = '' if !exists $hInside{$_};
      }
      my %hInputs = (
		     plaintext => '<textarea class="longinput" name="n_'.$nUniqNum.'_content_plaintext">'.$hInside{plaintext}.'</textarea>',
		     link => 'URI:<input class="longinput" type="text" name="n_'.$nUniqNum.'_content_link" value="'.$hInside{link}.'"/>',
		     xhtml => '<input type="file" name="n_'.$nUniqNum.'_content_xhtml" value="'.$hInside{xhtml}.'" disabled="disabled" /><p>'.$oS->getEncLng('UNDER_CONSTRUCTION').'</p>',
		    );
      foreach(keys %hInputs){
	$hInputs{$_} = '<div id="div_form_'.$nUniqNum.'_content_'.$_.'">'.$hInputs{$_}.'</div>';
      }
      my %hCheckBoxes = ();
      foreach(qw|plaintext link xhtml|){
	if($hsParams{content}->type eq $_){
	  $hCheckBoxes{$_} = ' checked="checked"';
	}else{
	  $hCheckBoxes{$_} = '';
	}
	$hCheckBoxes{$_} = '<input type="radio" name="n_'.$nUniqNum.'_content_type" value="'.$_.'" onclick="setContentEditForm('."$nUniqNum,'$_'".');" '.$hCheckBoxes{$_}.' />'.$oS->getEncLng('EDIT_CONTENT_TYPE_'.uc($_));
      }
      $sRes .= '<p>'.join('',@hCheckBoxes{qw|plaintext link xhtml|}).'<p>'.join('',@hInputs{qw|plaintext link xhtml|}).'</p>';
    }
    $sRes .= '</fieldset>';

    # Display location
    $sRes .= '<fieldset><legend>'.$oS->getEncLng('LOCATION').'</legend><ul>';
    my $nLocationNumber = 0;
    if(!defined $aoLocations[0]){
      $sRes .= '<p>'.$oS->getEncLng('EDIT_THERE_ARE_NO_PREVIOUS_LOCATIONS').'</p>';
    }else{
      foreach(@aoLocations){
	if($_->type eq 'name'){
	  $sRes .= '<p>'.$oS->getEncLng('EDIT_PREVIOUS_LOCATION_NAME').':'.$oS->oOut->encoded($_->name).'</p>';
	}elsif($_->type eq 'gpx'){
	  $sRes .= '<p>'.$oS->getEncLng('EDIT_PREVIOUS_LOCATION_NAME').'</p>';
	}
	$nLocationNumber++;
      }
    }
    my @aoLocationList = $oS->oLDat->getLList;
    my $sLocationName;
    my $sPrevLocationType = '';
    if(defined $aoLocations[0] and $aoLocations[0]->type eq 'name'){
      $sLocationName = $oS->oOut->encoded($aoLocations[0]->name());
      $sPrevLocationType = 'name';
    }else{
      $sLocationName = '';
      $sPrevLocationType = 'location_library';
    }
    foreach(qw|name location_library|){
      my $sChecked = '';
      if($sPrevLocationType eq $_){
	$sChecked = 'checked="checked"';
      }
      $sRes .= '<input type="radio" name="n_'.$nUniqNum.'_location_type"  value="'.$_.'" onclick="setLocationEditForm('.$nUniqNum.',\''.$_.'\');" '.$sChecked.' />'.$oS->getEncLng('EDIT_'.uc($_));
    }
    $sRes .= '<input type="hidden" name="n_location_'.$nUniqNum.'_use" value="1" /><div id="div_form_'.$nUniqNum.'_location_location_library"><select name="n_'.$nUniqNum.'_location_id">';
    $sRes .= '<option value="">- none -</option>';
    $sRes .= '<option value="#" selected="selected">- no change('.$oS->oOut->encoded($aoLocations[0]->name).') -</option>' if defined $sID and defined $aoLocations[0];
    foreach(@aoLocationList){
      my $oLocation = $oS->oLDat->getLByHash($_);
      $sRes .= '<option value="'.$_.'">'.$oS->oOut->encoded($oLocation->name).'</option>';
    }
    $oS->oOut->appendBodyTagAttribute('onload','setLocationEditForm('.$nUniqNum.',\''.$sPrevLocationType.'\');');
    $sRes .= '</select></div><div id="div_form_'.$nUniqNum.'_location_name"><p>'.$oS->getEncLng('EDIT_LOCATION_NAME_NAME').':<input type="text" name="n_'.$nUniqNum.'_location_name" value="'.$sLocationName.'" /></p></div>';
    
    # Display time
    $sRes .= '</ul></fieldset><fieldset><legend>'.$oS->getEncLng('TIME').'</legend>';
    foreach my $sType(qw|begin end|){
      my $sChe = '';
      my $sT = $hsParams{'time_'.$sType.'_use'};
      $sChe = 'checked="checked" ' if (defined $sT && $sT == 1) || (!defined $sT && $sType eq 'begin');
      $sRes .= qq|<p>|.$sName{'time_'.$sType}.qq| : <input type="checkbox" name="n_|.$nUniqNum.q|_time_|.$sType.qq|_use" id="n_|.$nUniqNum.q|_time_|.$sType.qq|_use" onClick="timeOnOffChange('|.$sType.q|',|.$nUniqNum.qq|);" $sChe/>|;
      $oS->oOut->appendBodyTagAttribute('onload',q|timeOnOffChange('|.$sType.q|',|.$nUniqNum.q|);|);

      # Year
      $sRes .= q|<select onchange="timeDispSync('year',|.$nUniqNum.q|)" name="n_|.$nUniqNum.q|_time_|.$sType.q|_year" id="n_|.$nUniqNum.q|_time_|.$sType.q|_year">|;
      foreach(@hnYearNow){
	$sRes .= qq|<option value="$_"|;
	$sRes .= q| selected="selected"| if $nBaseYear == $_;
	$sRes .= qq|>$_</option>|;
      }

      # Month
      $sRes .= q|</select>|.$oS->getEncLng('TIME_YEAR').q|<select onchange="timeDispSync('month',|.$nUniqNum.q|)" name="n_|.$nUniqNum.q|_time_|.$sType.q|_month" id="n_|.$nUniqNum.q|_time_|.$sType.q|_month">|;
      $sT = $hsParams{'time_'.$sType.'_month'};
      foreach(1..12){
	$sRes .= qq|<option value="$_"|;
	$sRes .= q| selected="selected"| if (defined $sT && $sT == $_) || (!defined $sT && $hTime{month} == $_);
	$sRes .= qq|>$_</option>|;
      }

      # Day
      $sRes .= q|</select>|.$oS->getEncLng('TIME_MONTH').q|<select onchange="timeDispSync('day',|.$nUniqNum.q|)" name="n_|.$nUniqNum.q|_time_|.$sType.q|_day" id="n_|.$nUniqNum.q|_time_|.$sType.q|_day">|;
      $sT = $hsParams{'time_'.$sType.'_day'};
      foreach(1..31){
	$sRes .= qq|<option value="$_"|;
	$sRes .= q| selected="selected"| if (defined $sT && $sT == $_) || (!defined $sT && $hTime{day} == $_);
	$sRes .= qq|>$_</option>|;
      }

      # Hour
      $sRes .= q|</select>|.$oS->getEncLng('TIME_DAY').q|<select onchange="timeDispSync('hour',|.$nUniqNum.q|)" name="n_|.$nUniqNum.q|_time_|.$sType.q|_hour" id="n_|.$nUniqNum.q|_time_|.$sType.q|_hour">|;
      $sT = $hsParams{'time_'.$sType.'_hour'};
      foreach(0..23){
	$sRes .= qq|<option value="$_"|;
	$sRes .= q| selected="selected"| if (defined $sT && $sT == $_) || (!defined $sT && $hTime{hour} == $_);
	$sRes .= qq|>$_</option>|;
      }

      # Minute and second
      foreach(qw|minute second|){
	$hsParams{'time_'.$sType.'_'.$_} = 0 if !defined $hsParams{'time_'.$sType.'_'.$_} or $hsParams{'time_'.$sType.'_'.$_} eq '';
      }
      $sRes .= q|</select>|.$oS->getEncLng('TIME_HOUR').q|<input onchange="timeDispSync('minute',|.$nUniqNum.q|)" type="text" name="n_|.$nUniqNum.q|_time_|.$sType.q|_minute" id="n_|.$nUniqNum.q|_time_|.$sType.q|_minute" size="2" maxlength="2" |;
      $sRes .= q|value="|.$hsParams{'time_'.$sType.'_minute'}.q|"| if defined $hsParams{'time_'.$sType.'_minute'};
      $sRes .= q|/>|.$oS->getEncLng('TIME_MINUTE').q|<input onchange="timeDispSync('second',|.$nUniqNum.q|)" type="text" name="n_|.$nUniqNum.q|_time_|.$sType.q|_second" id="n_|.$nUniqNum.q|_time_|.$sType.q|_second" size="2" maxlength="2"|;
      $sRes .= q|value="|.$hsParams{'time_'.$sType.'_second'}.q|"| if defined $hsParams{'time_'.$sType.'_second'};
      $sRes .= q|/>|.$oS->getEncLng('TIME_SECOND').q|</p>|;
    }
    $sRes .= '<p><strong>'.$oS->getEncLng('EDIT_REMOVE_BOTH_CHECKS_TO_HALT').'</strong></p>';

    # Accuracy
    my $sAccuracy = defined $hsParams{accuracy}?$hsParams{accuracy}:'draft';
    foreach(qw|draft finalized|){
      $sRes .= '<input type="radio" name="n_'.$nUniqNum.'_accuracy" value="'.$_.'"';
      $sRes .= ' checked="checked"' if $_ eq $sAccuracy;
      $sRes .= '/>'.$oS->getEncLng('ACCURACY_'.uc($_));
    }
    
    # Access class
    $sRes .= '</fieldset><fieldset><legend>'.$oS->getEncLng('CLASS').'*</legend>';
    my %hsClassName;
    @hsClassName{qw|public confidential|} = ($oS->getEncLng('CLASS_PUBLIC'),
					     $oS->getEncLng('CLASS_CONFIDENTIAL'));
    foreach(qw|public confidential|){
      my $sChe = '';
      $sChe = 'checked="checked" ' if (defined $hsParams{class} && $hsParams{class} eq $_) || (!defined $hsParams{class} && $_ eq 'confidential');
      $sRes .= '<input type="radio" name="n_'.$nUniqNum.'_class" value="'.$_.'" '.$sChe.'/>'.$hsClassName{$_};
    }

    # ReloadInterval
    my $nInterval = defined $hsParams{reloadinterval}&&$hsParams{reloadinterval} ne ''?$hsParams{reloadinterval}:600;
    $sRes .= '</fieldset><fieldset><legend>'.$oS->getEncLng('RELOADINTERVAL').'</legend><input type="text" name="n_'.$nUniqNum.'_reload_interval" value="'.$nInterval.'" />'.$oS->getEncLng('TIME_SECOND');
    
    # Type of this sche(new sche, or editing existing sche)
    $sRes .= '</fieldset><input type="hidden" name="n_'.$nUniqNum.'_uniq_num" value="'.(defined $sID?$sID:'new').'"/>';
    return $sRes;
  }

1;

__DATA__
var m_nUniqNum = -1;

function setMaxUniqNum(_nMaxUniqNum){
  if(m_nUniqNum < _nMaxUniqNum){
    m_nUniqNum = _nMaxUniqNum;
  }
}
function load(){
  document.form.submit_button.disabled = "disabled";
  canSubmit();
}
function canSubmit(){
  var _i;
  var _isSubmittable = true;
  for(_i=0;_i<=m_nUniqNum;_i++){
    _isSubmittable = _isSubmittable && canSubmitNum(_i);
  }
  _isSubmittable = _isSubmittable && canSubmitGlobal();
  if(_isSubmittable == true){
    document.form.submit_button.disabled = "";
  }else{
    document.form.submit_button.disabled = "disabled";
  }
}
function canSubmitNum(_nUniqNum){
  var _sName = "n_"+_nUniqNum+"_title";
  if($F(_sName) == ""){
    $(_sName).style.backgroundColor = "red";
    return false;
  }else{
    $(_sName).style.backgroundColor = "";
  }
  return true;
}
function canSubmitGlobal(){
  if($F("n_author_name") == ""){
    $("n_author_name").style.backgroundColor = "red";
    return false;
  }else{
    $("n_author_name").style.backgroundColor = "";
  }
  return true;
}
  function setContentEditForm(_nUniqID,_sType){
    var asTypes = new Array('plaintext','link','xhtml');
    var _i;
    for(_i=0;_i<asTypes.length;_i++){
  var _div = $("div_form_"+_nUniqID+"_content_"+asTypes[_i]);
  if(asTypes[_i] == _sType){
    _div.show();
  }else{
    _div.hide();
  }
}
}
function setLocationEditForm(_nUniqID,_sType){
  var asTypes = new Array('location_library','name');
  var _i;
  for(_i=0;_i<asTypes.length;_i++){
    var _div = $("div_form_"+_nUniqID+"_location_"+asTypes[_i]);
  if(asTypes[_i] == _sType){
    _div.show();
  }else{
    _div.hide();
  }
}
}
function timeOnOffChange(_sType,_nUniqID){
  var _isC = document.getElementById("n_"+_nUniqID+"_time_"+_sType+"_use").checked;
  timeOnOffChangeForParam(_sType,_nUniqID,"year",_isC);
  timeOnOffChangeForParam(_sType,_nUniqID,"month",_isC);
  timeOnOffChangeForParam(_sType,_nUniqID,"day",_isC);
  timeOnOffChangeForParam(_sType,_nUniqID,"hour",_isC);
  timeOnOffChangeForParam(_sType,_nUniqID,"minute",_isC);
  timeOnOffChangeForParam(_sType,_nUniqID,"second",_isC);
}
function timeOnOffChangeForParam(_sType,_nUniqID,_sT,_isC){
  var _o = document.getElementById("n_"+_nUniqID+"_time_"+_sType+"_"+_sT);
  _o.disabled = !_isC;
}
function timeDispSync(_sT,_nUniqID){
  var _nBeginDiv = document.getElementById("n_"+_nUniqID+"_time_begin_"+_sT);
  var _nEndDiv = document.getElementById("n_"+_nUniqID+"_time_end_"+_sT);
  var _nBeginValue = _nBeginDiv.value;
  var _nEndValue = _nEndDiv.value;
  var _nBeginEnabled = !_nBeginDiv.disabled;
  var _nEndEnabled = !_nEndDiv.disabled;
  if((_nBeginEnabled && _nEndEnabled) || (!_nBeginEnabled && !_nEndEnabled)){
    return;
  }
  if(!_nBeginEnabled){
    _nBeginDiv.value = _nEndDiv.value;
  }else{
    _nEndDiv.value = _nBeginDiv.value;
  }
}
