package Scheduler::FileLock;

use strict;
use warnings;
use Carp;

use IO::File;

BEGIN{
  if(!-e './lockdir/'){
    mkdir('./lockdir/');
    chmod(0777,'./lockdir/');
  }
  if(!-e './lockdir/lockfile'){
    my $oIO = new IO::File('> ./lockdir/lockfile');
    undef $oIO;
    chmod(0666,'./lockdir/lockfile');
  }
}
sub my_flock {
  shift;
  my %lfh = (dir => './lockdir/', basename => 'lockfile',
	          timeout => 60, trytime => 10, @_);
  $lfh{path} = $lfh{dir} . $lfh{basename};

  for (my $i = 0; $i < $lfh{trytime}; $i++, sleep 1) {
    return \%lfh if (rename($lfh{path}, $lfh{current} = $lfh{path} . time));
  }
  opendir(LOCKDIR, $lfh{dir});
  my @filelist = readdir(LOCKDIR);
  closedir(LOCKDIR);
  foreach (@filelist) {
    if (/^$lfh{basename}(\d+)/) {
      return \%lfh if (time - $1 > $lfh{timeout} and
		       rename($lfh{dir} . $_, $lfh{current} = $lfh{path} . time));
      last;
    }
  }
  undef;
}

sub my_funlock {
  shift;
  rename($_[0]->{current}, $_[0]->{path});
}

1;
