package Scheduler::Filter;

use strict;
use warnings;
use Carp;

use Encode qw|encode|;

sub new{
  shift;
  return bless{
	       id => undef,
	       changeable => {
			      title => undef,
			      subtitle => undef,
			      summary => undef,
			      content => {
					  type => undef,
					  plaintext => undef,
					 },
			      time => {
				       begin => undef,
				       end => undef,
				      },
			      class => undef,
			      location => undef,
			      author => {
					 name => undef,
					 email => undef,
					 uri => undef,
					},
			      numbers => undef,
			     },
	       uri => {
		       href => undef,
		       numbers => undef,
		      },
	      };
}
sub addFilter{
  my $oS = shift;
  my @asIdent = @_;
  my $sValue = pop @asIdent;
  my $sKey = pop @asIdent;
#  return if $sKey !~ m/^n?(equals|includes|matches|over|overeq)$/;
  my $sKeyPref = '';
  if(substr($sKey,0,1) eq 'n'){
    $sKeyPref = substr($sKey,0,1);
    $sKey = substr($sKey,1);
  }
  if($sKey eq 'matches'){
    $sValue =~ s|\$|\\\$|g;
    $sValue =~ s|\@|\\\@|g;
    $sValue =~ s|\%|\\\%|g;
    $sValue =~ s|\&|\\\&|g;
    $sValue = qr|$sValue|;
  }
  my $oIt = $oS;
  foreach(@asIdent){
    $oIt = $oIt->{$_};
  }
  my $hNewQuery = [$sKeyPref.$sKey,$sValue];
  if(!defined $oIt){
    $oIt = [];
    my $oIt2 = $oS;
    foreach(@asIdent){
      if(!defined $oIt2->{$_}){
	$oIt2->{$_} = $oIt;
      }else{
	$oIt2 = $oIt2->{$_};
      }
    }
  }
  push(@{$oIt},$hNewQuery);
}
sub passes($){
  my $oS = shift;
  my $oSche = shift;
  return 0 unless $oS->passesForElement($oSche->id,$oS->{id});
  return 0 unless $oS->passesForElement($oSche->changeables->[0]->title,$oS->{changeable}{title});
  return 0 unless $oS->passesForElement($oSche->changeables->[0]->subtitle,$oS->{changeable}{subtitle});
  return 0 unless $oS->passesForElement($oSche->changeables->[0]->summary,$oS->{changeable}{summary});
  if(defined $oSche->changeables->[0]->content){
    return 0 unless $oS->passesForElement($oSche->changeables->[0]->content->type,$oS->{changeable}{content}{type});
    return 0 unless $oS->passesForElement($oSche->changeables->[0]->content->plainText,$oS->{changeable}{content}{plaintext});
  }
  return 0 unless $oS->passesForElement($oSche->changeables->[0]->class,$oS->{changeable}{class});
  return 1;
}
sub passesForElement($$){
  my $oS = shift;
  my $sElement = shift;
  my $rasQuery = shift;
  return 1 if !defined $rasQuery;
  foreach(@{$rasQuery}){
    my ($sKey,$sValue) = @{$_};
    my $isPassing = 0;
    if(substr($sKey,0,1) eq 'n'){
      $isPassing = 1;
      $sKey = substr($sKey,1);
    }
    if($sKey eq 'equals'){
      $isPassing = !$isPassing if $sElement eq $sValue;
    }elsif($sKey eq 'includes'){
      $isPassing = !$isPassing if index($sElement,$sValue) != -1;
    }
    return 0 if $isPassing == 0;
  }
  return 1;
}

1;
