package Scheduler::Parser::ContentPlainText;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::base;
use Scheduler::Schema::ContentPlainText;

sub obj($$){
  shift;
  my $oContent = new Scheduler::Schema::ContentPlainText;
  my $oRoot = shift;
  my $oDocument = shift;
  my $oT = $oRoot->firstChild;
  $oContent->set($oT->nodeValue);
  return $oContent;
}
sub element($$){
  shift;
  my $oContent = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('content');
  my $oCDATA = new XML::LibXML::CDATASection($oContent->get);
  $oRoot->addChild($oCDATA);
  $oRoot->setAttribute('type','plaintext');
  return $oRoot;
}

1;
