/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.dfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.morilib.automata.CharSequenceHead;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFA;
import net.morilib.automata.dfa.DFAState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DFAs {
    public static final DFAState<Object, Object, Object> DEAD_STATE = new DFAState<Object, Object, Object>(){

        @Override
        public Set<Object> getAccepted() {
            return Collections.emptySet();
        }

        @Override
        public DFAState<Object, Object, Object> go(Object a) {
            return this;
        }

        @Override
        public DFAState<Object, Object, Object> goBound(TextBound a) {
            return this;
        }

        @Override
        public boolean isInitialState() {
            return false;
        }

        @Override
        public boolean isDead() {
            return true;
        }
    };

    private DFAs() {
    }

    public static <T, A, B> DFAState<T, A, B> deadState() {
        return DEAD_STATE;
    }

    public static <A, B> Set<A> input(DFAState<Integer, A, B> st, CharSequenceHead seq) {
        DFAState<Integer, A, B> s3;
        DFAState<Integer, A, B> s2 = st;
        while (seq.hasNext()) {
            s3 = s2;
            EnumSet<TextBound> bs = seq.getBounds();
            int c = seq.readInt();
            while ((s2 = s2.go(c)).isDead()) {
                for (TextBound b : bs) {
                    s2 = s3.goBound(b);
                    if (s2.isDead()) continue;
                    s3 = s2;
                    break;
                }
                if (!s2.isDead()) continue;
                return Collections.emptySet();
            }
        }
        block3: while (true) {
            s3 = s2;
            for (TextBound b : seq.getBounds()) {
                s3 = s2.goBound(b);
                if (s3.isDead()) continue;
                s2 = s3;
                continue block3;
            }
            break;
        }
        return s2.getAccepted();
    }

    public static <A, B> Set<A> input(DFAState<Integer, A, B> st, CharSequence seq) {
        return DFAs.input(st, new CharSequenceHead(seq));
    }

    public static <A, B> Set<A> input(DFA<Integer, A, B> dfa, CharSequenceHead seq) {
        return DFAs.input(dfa.getInitialState(), seq);
    }

    public static <A, B> Set<A> input(DFA<Integer, A, B> dfa, CharSequence seq) {
        return DFAs.input(dfa, new CharSequenceHead(seq));
    }

    public static <A, B> Set<A> match(DFAState<Integer, A, B> st, CharSequenceHead seq) {
        DFAState<Integer, A, B> s3;
        DFAState<Integer, A, B> s2 = st;
        while (seq.hasNext()) {
            s3 = s2;
            EnumSet<TextBound> bs = seq.getBounds();
            int c = seq.readInt();
            while ((s2 = s2.go(c)).isDead()) {
                for (TextBound b : bs) {
                    s2 = s3.goBound(b);
                    if (s2.isDead()) continue;
                    s3 = s2;
                    break;
                }
                if (!s2.isDead()) continue;
                seq.unread();
                return s3.getAccepted();
            }
        }
        block3: while (true) {
            s3 = s2;
            for (TextBound b : seq.getBounds()) {
                s3 = s2.goBound(b);
                if (s3.isDead()) continue;
                s2 = s3;
                continue block3;
            }
            break;
        }
        return s2.getAccepted();
    }

    public static <A, B> Set<A> match(DFAState<Integer, A, B> st, CharSequence seq) {
        return DFAs.match(st, new CharSequenceHead(seq));
    }

    public static <A, B> Set<A> match(DFA<Integer, A, B> dfa, CharSequenceHead seq) {
        return DFAs.match(dfa.getInitialState(), seq);
    }

    public static <A, B> Set<A> match(DFA<Integer, A, B> dfa, CharSequence seq) {
        return DFAs.match(dfa, new CharSequenceHead(seq));
    }
}

