/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.grammar.lr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.grammar.lr.ContextFreeGrammar;
import net.morilib.grammar.lr.ContextFreeRule;
import net.morilib.grammar.lr.GrammarSymbol;
import net.morilib.grammar.lr.LALR1Items;
import net.morilib.grammar.lr.LR1Table;
import net.morilib.grammar.lr.Nonterminal;
import net.morilib.grammar.lr.Terminal;
import net.morilib.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LALR1Table
implements LR1Table {
    private LALR1Items goTo;
    List<Map<Terminal, LR1Table.Action>> actionTable;
    List<Map<Nonterminal, Integer>> goToTable;
    List<LR1Table.Conflict> conflicts;

    public LALR1Table(LALR1Items goTo) {
        this.goTo = goTo;
        this.computeTable();
    }

    private <T, S> List<Map<T, S>> allocateMap(int size) {
        ObjectArray<Map<T, S>> res = new ObjectArray<Map<T, S>>(size);
        int i = 0;
        while (i < size) {
            res.set(i, new HashMap());
            ++i;
        }
        return res;
    }

    void computeTable() {
        ContextFreeGrammar grammar = this.goTo.getGrammar();
        this.conflicts = new ArrayList<LR1Table.Conflict>();
        this.actionTable = this.allocateMap(this.goTo.getSizeOfStates());
        this.goToTable = this.allocateMap(this.goTo.getSizeOfStates());
        int i = 0;
        while (i < this.goTo.getSizeOfStates()) {
            Set<LALR1Items.Item> items = this.goTo.getItems(i);
            Map<Terminal, LR1Table.Action> ctable = this.actionTable.get(i);
            for (LALR1Items.Item item : items) {
                if (item.isReduceState()) {
                    ContextFreeRule rule = item.getRule();
                    if (rule.equals(grammar.getAugmentRule())) {
                        ctable.put(ContextFreeGrammar.ENDMARKER, LR1Table.Action.newAccept());
                        continue;
                    }
                    Set<Terminal> follow = item.getLookaheadSet();
                    for (Terminal k : follow) {
                        LR1Table.Conflict cnf;
                        LR1Table.Action act = ctable.get(k);
                        if (act == null) {
                            ctable.put(k, LR1Table.Action.newReduce(rule));
                            continue;
                        }
                        if (!act.isShift()) {
                            cnf = LR1Table.Conflict.newReduceReduce(rule, act.getReduceRule());
                            this.conflicts.add(cnf);
                            continue;
                        }
                        cnf = LR1Table.Conflict.newShiftReduce(k, rule);
                        this.conflicts.add(cnf);
                    }
                    continue;
                }
                GrammarSymbol symbol = item.getDirectedSymbol();
                int nextid = this.goTo.goToID(i, symbol);
                if (symbol instanceof Terminal) {
                    LR1Table.Action act = ctable.get(symbol);
                    if (act == null) {
                        ctable.put((Terminal)symbol, LR1Table.Action.newShift(nextid));
                        continue;
                    }
                    if (act.isShift()) continue;
                    LR1Table.Conflict cnf = LR1Table.Conflict.newShiftReduce(symbol, act.getReduceRule());
                    this.conflicts.add(cnf);
                    continue;
                }
                if (!(symbol instanceof Nonterminal)) continue;
                this.goToTable.get(i).put((Nonterminal)symbol, nextid);
            }
            ++i;
        }
    }

    @Override
    public LR1Table.Action action(int stateID, Terminal terminal) {
        return this.actionTable.get(stateID).get(terminal);
    }

    @Override
    public int goTo(int stateID, Nonterminal nonterminal) {
        return this.goToTable.get(stateID).get(nonterminal);
    }

    @Override
    public int getInitialStateID() {
        return this.goTo.getInitialStateID();
    }

    @Override
    public Collection<LR1Table.Conflict> getConflicts() {
        return Collections.unmodifiableCollection(this.conflicts);
    }
}

