/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispException;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.UserSyntax;

class SymbolScope
extends Datum
implements SymbolName {
    private Symbol symbol;
    private UserSyntax scope;

    SymbolScope(Symbol symbol, UserSyntax scope) {
        if (symbol == null || scope == null) {
            throw new NullPointerException();
        }
        this.symbol = symbol;
        this.scope = scope;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public UserSyntax getUserSyntax() {
        return this.scope;
    }

    public Environment getExecuteEnv() {
        if (this.scope.getExecuteEnv() == null) {
            throw new LispException("environment has not been initialized");
        }
        return this.scope.getExecuteEnv();
    }

    public String toString() {
        return this.symbol + ":" + this.scope;
    }

    public boolean isTypeSymbol() {
        return true;
    }

    public String getName() {
        return this.symbol.getName();
    }
}

