/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynDefineMacro
extends Syntax {
    private void defun(Datum bcar, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist, boolean toplevel) {
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Cons c = (Cons)bcar;
        Environment nenv = new Environment(env);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, c, true, mesg, new ArrayList<Cons>());
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(c.getCdr(), nbuild.getCodeRef());
        build.addPush(cl);
        build.addBindMacro(c.getCar());
        build.addPush(Undef.UNDEF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist) {
        if (!toplevel) {
            throw mesg.getError("err.nottoplevel");
        }
        if (!(body instanceof Cons)) throw mesg.getError("err.definemacro.malform");
        Datum bcar = ((Cons)body).getCar();
        Datum bcdr = ((Cons)body).getCdr();
        if (bcar instanceof Cons) {
            if (!(((Cons)bcar).getCar() instanceof Symbol)) {
                throw mesg.getError("err.definemacro.malform");
            }
            this.defun(bcar, bcdr, env, comp, build, callsym, mesg, symlist, toplevel);
            return;
        } else {
            if (!(bcar instanceof Symbol) && !(bcar instanceof SymbolScope)) throw mesg.getError("err.definemacro.malform");
            SyntaxUtils.compileBindMacro(bcar, bcdr, env, comp, build, callsym, mesg, "err.definemacro.malform", new ArrayList<Cons>());
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        throw mesg.getError("err.definemacro.definesyntax");
    }
}

