/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.format;

import java.util.Collections;
import java.util.List;
import net.morilib.lisp.format.ArgumentType;
import net.morilib.lisp.format.FormatArguments;
import net.morilib.lisp.format.FormatAtom;
import net.morilib.lisp.format.LispFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatCommand
implements FormatAtom {
    private List<ArgumentType> parameters;
    private boolean atmark;
    private boolean colon;

    protected FormatCommand(List<ArgumentType> parameters, boolean atmark, boolean colon) {
        this.parameters = Collections.unmodifiableList(parameters);
        this.atmark = atmark;
        this.colon = colon;
    }

    protected ArgumentType get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= this.parameters.size()) {
            return ArgumentType.DEFAULT_ARG;
        }
        return this.parameters.get(index);
    }

    protected int getInt(int index, FormatArguments args, int deflt) throws LispFormatException {
        ArgumentType a = this.get(index);
        return a.isDefault() ? deflt : (a.isVararg() ? args.shiftInt() : a.getInt());
    }

    protected char getChar(int index, FormatArguments args, char deflt) throws LispFormatException {
        ArgumentType a = this.get(index);
        return a.isDefault() ? deflt : (a.isVararg() ? args.shiftChar() : a.getChar());
    }

    protected boolean isAtmark() {
        return this.atmark;
    }

    protected boolean isColon() {
        return this.colon;
    }
}

