/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.subr.UnaryArgs;

public class Numerator
extends UnaryArgs {
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispNumber) {
            LispNumber n1 = (LispNumber)c1a;
            if (!n1.isReal()) {
                throw mesg.getError("err.require.real", n1);
            }
            if (n1.isExact()) {
                return LispInteger.valueOf(n1.getReal().getNumerator());
            }
            try {
                return new LispDouble(n1.getReal().getNumerator().doubleValue());
            }
            catch (LispNotSupportedException e) {
                throw mesg.getError(e.getMessage(), c1a);
            }
        }
        throw mesg.getError("err.require.real", c1a);
    }
}

