/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.grammar.lr;

import java.util.Collection;
import net.morilib.grammar.lr.ContextFreeRule;
import net.morilib.grammar.lr.Nonterminal;
import net.morilib.grammar.lr.Terminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface LR1Table {
    public Action action(int var1, Terminal var2);

    public int goTo(int var1, Nonterminal var2);

    public int getInitialStateID();

    public Collection<Conflict> getConflicts();

    public static final class Action {
        public static final int SHIFT = 1;
        public static final int REDUCE = 2;
        public static final int ACCEPT = 3;
        private int action;
        private int nextStateID;
        private ContextFreeRule reduceRule;

        private Action() {
        }

        protected static Action newShift(int id) {
            Action res = new Action();
            res.action = 1;
            res.nextStateID = id;
            return res;
        }

        protected static Action newReduce(ContextFreeRule rule) {
            Action res = new Action();
            res.action = 2;
            res.reduceRule = rule;
            return res;
        }

        protected static Action newAccept() {
            Action res = new Action();
            res.action = 3;
            return res;
        }

        public boolean isShift() {
            return this.action == 1;
        }

        public boolean isReduce() {
            return this.action == 2;
        }

        public boolean isAccept() {
            return this.action == 3;
        }

        public int getAction() {
            return this.action;
        }

        public int getNextStateID() {
            return this.nextStateID;
        }

        public ContextFreeRule getReduceRule() {
            return this.reduceRule;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.action == 1) {
                buf.append("shift: ").append(this.nextStateID);
            } else if (this.action == 2) {
                buf.append("reduce: ").append(this.reduceRule);
            } else if (this.action == 3) {
                buf.append("accept");
            }
            return buf.toString();
        }
    }

    public static final class Conflict {
        private boolean shiftReduce;
        private ContextFreeRule reduceRule;
        private ContextFreeRule reduceRule2;
        private Object shiftSymbol;

        private Conflict() {
        }

        protected static Conflict newShiftReduce(Object symbol, ContextFreeRule rule1) {
            Conflict res = new Conflict();
            res.shiftReduce = true;
            res.shiftSymbol = symbol;
            res.reduceRule = rule1;
            return res;
        }

        protected static Conflict newReduceReduce(ContextFreeRule rule1, ContextFreeRule rule2) {
            Conflict res = new Conflict();
            res.shiftReduce = false;
            res.reduceRule = rule1;
            res.reduceRule2 = rule2;
            return res;
        }

        public boolean isShiftReduce() {
            return this.shiftReduce;
        }

        public boolean isReduceReduce() {
            return !this.shiftReduce;
        }

        public Object getShiftSymbol() {
            return this.shiftSymbol;
        }

        public ContextFreeRule getReduceRule() {
            return this.reduceRule;
        }

        public ContextFreeRule getReduceRule2() {
            return this.reduceRule2;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.shiftReduce) {
                buf.append("shift/reduce conflict: shift ");
                buf.append(this.shiftSymbol).append(" vs reduce ");
                buf.append(this.reduceRule);
            } else {
                buf.append("reduce/reduce conflict: reduce ");
                buf.append(this.reduceRule).append(" vs reduce ");
                buf.append(this.reduceRule2);
            }
            return buf.toString();
        }
    }
}

