/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import net.morilib.lisp.Callable;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.ClosureClassMethod;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.CompilerFactory;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Continuation;
import net.morilib.lisp.Datum;
import net.morilib.lisp.EOFObject;
import net.morilib.lisp.Environment;
import net.morilib.lisp.EnvironmentObject;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntPrmNotFoundException;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.JavaClass;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.JavaTargetException;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispGeneric;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNextMethod;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Macro;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.NamableDatum;
import net.morilib.lisp.Nil;
import net.morilib.lisp.PatternMatch;
import net.morilib.lisp.Promise;
import net.morilib.lisp.Settable;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.SynDefineMethod;
import net.morilib.lisp.Undef;
import net.morilib.lisp.UserSyntax;
import net.morilib.lisp.sos.LispClass;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.sos.LispTypeList;
import net.morilib.lisp.util.LogEnv;
import net.morilib.util.ArrayListStack;
import net.morilib.util.Stack2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CodeExecutorImpl
implements CodeExecutor {
    private static Logger _log = LogEnv.init("schlush.vm");
    private LispMessage message;

    CodeExecutorImpl(LispMessage msg) {
        this.message = msg;
    }

    private Datum evalLispMapValid(Datum body) {
        List<Datum> lst1 = LispUtils.consToList(body, this.message);
        if (lst1.size() < 2) {
            throw this.message.getError("err.argument");
        }
        return Undef.UNDEF;
    }

    private Datum evalLispMap(Datum body) {
        List<Datum> lst1 = LispUtils.consToList(body, this.message);
        ArrayList<Datum> lst2 = new ArrayList<Datum>(lst1);
        ArrayList<Datum> no2 = new ArrayList<Datum>();
        int i = 0;
        block0: while (true) {
            ArrayList<Datum> arg = new ArrayList<Datum>();
            int j = 0;
            while (j < lst1.size()) {
                Datum d = lst1.get(j);
                if (!(d instanceof Cons)) {
                    if (d == Nil.NIL) break block0;
                    throw this.message.getError("err.list", (Datum)lst2.get(j));
                }
                arg.add(((Cons)d).getCar());
                lst1.set(j, ((Cons)d).getCdr());
                ++j;
            }
            no2.add(LispUtils.listToCons(arg));
            ++i;
        }
        return LispUtils.listToCons(no2);
    }

    private Datum evalApplyValid(Datum body) {
        List<Datum> lst1 = LispUtils.consToList(body, this.message);
        if (lst1.size() < 2) {
            throw this.message.getError("err.argument");
        }
        return Undef.UNDEF;
    }

    private Datum evalApply(Datum body) {
        List<Datum> lst1 = LispUtils.consToList(body, this.message);
        ArrayList<Datum> arg = new ArrayList<Datum>();
        int i = 0;
        while (i < lst1.size() - 1) {
            arg.add(lst1.get(i));
            ++i;
        }
        List<Datum> elst = LispUtils.consToList(lst1.get(lst1.size() - 1), this.message);
        arg.addAll(elst);
        return LispUtils.listToCons(arg);
    }

    private void callSubr(Subr sub, int addr, Environment env, Datum d3d, Memento m, ExcHandler hndl, Datum callee) {
        m.addrStk.push(addr);
        m.codeStk.push(null);
        m.envStk.push(env);
        m.callerStk.push(callee);
        m.beforeStk.push(null);
        m.afterStk.push(null);
        m.memoStk.push(null);
        m.pushbkStk.push(null);
        m.stateStk.push(0);
        m.hndlStk.push(hndl);
        m.flgStk.push(Flags.INS);
        m.dataStk.push(sub.eval(d3d, env, this.message));
        m.addrStk.pop();
        m.codeStk.pop();
        m.envStk.pop();
        m.callerStk.pop();
        m.beforeStk.pop();
        m.afterStk.pop();
        m.memoStk.pop();
        m.pushbkStk.pop();
        m.stateStk.pop();
        m.hndlStk.pop();
        m.flgStk.pop();
    }

    private void setContinuationArgs(List<Datum> lst, Memento m) {
        m.dataStk.push(MultiValues.newValues(lst));
    }

    private ClosureClass makeLoad(InputPort ipt, Environment env, Memento memento) {
        Datum d;
        CompiledCode.Builder b = new CompiledCode.Builder();
        LispCompiler comp = CompilerFactory.getInstance(this.message);
        while ((d = ipt.read()) != EOFObject.EOF) {
            d = comp.expandMacro(d, env, this, memento);
            comp.compile(d, env, b, true, new Cons(), true, new LinkedList<Cons>(), this, memento);
        }
        b.addPop();
        b.addPush(Undef.UNDEF);
        b.addReturnOp();
        ClosureClass clc = new ClosureClass(Nil.NIL, b.getCodeRef());
        return clc;
    }

    private Closure makeEval(Datum sexp, Environment env, Memento memento) {
        Datum d = sexp;
        CompiledCode.Builder b = new CompiledCode.Builder();
        LispCompiler comp = CompilerFactory.getInstance(this.message);
        d = comp.expandMacro(d, env, this, memento);
        comp.compile(d, env, b, true, new Cons(), true, new LinkedList<Cons>(), this, memento);
        b.addReturnOp();
        ClosureClass clc = new ClosureClass(Nil.NIL, b.getCodeRef());
        Closure res = new Closure(clc, env);
        return res;
    }

    private Environment calltail0(CompiledCode.Code c, Memento m, ExcHandler hndl, Closure cl) {
        _log.finer("Remove " + c.getRewind() + " frame(s) for tail call");
        int i = 0;
        while (i < c.getRewind()) {
            m.envStk.pop();
            m.addrStk.pop();
            m.codeStk.pop();
            m.callerStk.pop();
            m.beforeStk.pop();
            m.afterStk.pop();
            m.memoStk.pop();
            m.pushbkStk.pop();
            m.stateStk.pop();
            hndl = (ExcHandler)m.hndlStk.pop();
            m.flgStk.pop();
            ++i;
        }
        Environment env = cl.getEnvironment().copyNotRoot();
        _log.finer("Tail jump top:" + cl.printName() + ":dtstk(" + m.dataStk.size() + "):cdstk(" + m.codeStk.size() + ")");
        return env;
    }

    private void bind0(Environment env, Symbol sym, Datum dest) {
        if (dest instanceof NamableDatum) {
            ((NamableDatum)dest).setName(sym.getName());
        }
        env.bindDatum(sym, dest);
    }

    private boolean set0(Environment env, Symbol sym, Datum dest) {
        if (dest instanceof NamableDatum) {
            ((NamableDatum)dest).setName(sym.getName());
        }
        return env.setDatum(sym, dest);
    }

    private void mbind0(Environment env, Symbol sym, Datum dest) {
        if (!(dest instanceof Closure)) {
            throw this.message.getError("err.require.closure");
        }
        Macro mc = new Macro((Closure)dest);
        env.bindDatum(sym, mc);
    }

    private Symbol getsym(Datum d) {
        if (d instanceof SymbolName) {
            return ((SymbolName)((Object)d)).getSymbol();
        }
        throw this.message.getError("err.require.symbol");
    }

    private void bind0m(Environment env, Symbol sym, Datum dest) {
        if (dest instanceof ClosureClassMethod) {
            LispGeneric lmth;
            ClosureClassMethod cm = (ClosureClassMethod)dest;
            Closure ncl = new Closure(cm, new Environment(env));
            Datum dtm = env.findDatum(sym);
            if (dtm instanceof LispGeneric) {
                lmth = (LispGeneric)dtm;
            } else {
                lmth = new LispGeneric(sym.getName());
                env.bindDatum(sym, lmth);
            }
            Datum pt = cm.getTypeList();
            ArrayList<LispType> lst = new ArrayList<LispType>();
            while (pt instanceof Cons) {
                Cons c0 = (Cons)pt;
                if (c0.getCar() == SynDefineMethod.TOPSYM) {
                    lst.add(LispType.TOP);
                } else {
                    Datum fd = env.findDatum(this.getsym(c0.getCar()));
                    if (!(fd instanceof LispClass)) {
                        throw this.message.getError("err.require.class");
                    }
                    lst.add(((LispClass)fd).getObjectType());
                }
                pt = c0.getCdr();
            }
            lmth.put(new LispTypeList(lst, pt != Nil.NIL), ncl);
            return;
        }
        throw new RuntimeException();
    }

    private Closure findm00(LispGeneric mth, Datum prm) {
        Datum pt = prm;
        ArrayList<LispType> lst = new ArrayList<LispType>();
        while (pt instanceof Cons) {
            Cons c0 = (Cons)pt;
            lst.add(c0.getCar().getType());
            pt = c0.getCdr();
        }
        if (pt == Nil.NIL) {
            return mth.get(new LispTypeList(lst));
        }
        throw this.message.getError("err.list");
    }

    private Closure findm(LispGeneric mth, Datum prm) {
        Closure cl = this.findm00(mth, prm);
        if (cl == null) {
            throw this.message.getError("err.method.notfound", mth.getName());
        }
        return cl;
    }

    private Datum consapl(LispGeneric mth, Datum prm) {
        return new Cons(mth, new Cons(prm, Nil.NIL));
    }

    private Closure findmapl(Environment env, LispGeneric mth, Datum prm) {
        Datum apl = env.findDatum(LispGeneric.APPLY_GENERIC);
        if (apl != null && apl instanceof LispGeneric) {
            return this.findm00((LispGeneric)apl, this.consapl(mth, prm));
        }
        return null;
    }

    private Datum findmnext(LispGeneric mth, Datum prm) {
        Datum pt = prm;
        ArrayList<LispType> lst = new ArrayList<LispType>();
        while (pt instanceof Cons) {
            Cons c0 = (Cons)pt;
            lst.add(c0.getCar().getType());
            pt = c0.getCdr();
        }
        if (pt == Nil.NIL) {
            LispNextMethod cl = mth.getNextMethod(new LispTypeList(lst), prm);
            return cl;
        }
        throw this.message.getError("err.list");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Datum exec(CompiledCode code1, Environment env1, IntStack memento, boolean useCont) {
        int addr = 0;
        Memento m = (Memento)memento;
        CompiledCode code = code1;
        Environment env = env1;
        Environment tenv = null;
        ExcHandler hndl = new ExcHandler();
        while (true) {
            try {
                while (true) {
                    CompiledCode.Code c = code.getCode(addr);
                    switch (c.getOp()) {
                        case PUSH: {
                            if (c.getDatum() instanceof ClosureClass) {
                                Closure ncl = new Closure((ClosureClass)c.getDatum(), env);
                                m.dataStk.push(ncl);
                            } else if (c.getDatum() instanceof UserSyntax) {
                                UserSyntax syn = (UserSyntax)c.getDatum();
                                if (env.getRootenv() != null) {
                                    syn.setExecuteEnv(env.getRootenv());
                                } else {
                                    syn.setExecuteEnv(env);
                                }
                                m.dataStk.push(syn);
                            } else {
                                m.dataStk.push(c.getDatum());
                            }
                            ++addr;
                            break;
                        }
                        case POP: {
                            m.dataStk.pop();
                            ++addr;
                            break;
                        }
                        case BEGIN_LIST: {
                            m.workStk.push(new ConsListBuilder());
                            ++addr;
                            break;
                        }
                        case APPEND_LIST: {
                            Datum d11 = (Datum)m.dataStk.pop();
                            ConsListBuilder d12 = (ConsListBuilder)m.workStk.peek();
                            d12.append(d11);
                            ++addr;
                            break;
                        }
                        case APPEND_LIST_SPLICING: {
                            Datum d13 = (Datum)m.dataStk.pop();
                            ConsListBuilder d14 = (ConsListBuilder)m.workStk.peek();
                            d14.appendAll(d13, this.message);
                            ++addr;
                            break;
                        }
                        case END_LIST_DOT: {
                            Datum d21 = (Datum)m.dataStk.pop();
                            ConsListBuilder d22 = (ConsListBuilder)m.workStk.pop();
                            m.dataStk.push(d22.get(d21));
                            ++addr;
                            break;
                        }
                        case END_LIST: {
                            ConsListBuilder d23 = (ConsListBuilder)m.workStk.pop();
                            m.dataStk.push(d23.get());
                            ++addr;
                            break;
                        }
                        case END_LIST_VECTOR: {
                            ConsListBuilder d24 = (ConsListBuilder)m.workStk.pop();
                            m.dataStk.push(new LispVector(LispUtils.consToList(d24.get(), this.message)));
                            ++addr;
                            break;
                        }
                        case CALL: 
                        case CALL_TAIL: {
                            Datum cl;
                            Datum d3d = (Datum)m.dataStk.pop();
                            Datum d3s = (Datum)m.dataStk.pop();
                            if (d3s instanceof Subr) {
                                Subr sub = (Subr)d3s;
                                cl = sub.getClosureClass(env.getGlobal());
                                if (cl == null) {
                                    this.callSubr(sub, addr, env, d3d, m, hndl, d3s);
                                    ++addr;
                                    break;
                                }
                                m.push(addr, code, env, hndl, d3s);
                                env = new Environment(env.getGlobal());
                                IntLispUtils.bindLocal(((ClosureClass)cl).getParameterList(), d3d, env, this.message);
                                code = ((ClosureClass)cl).getCode();
                                addr = 0;
                                break;
                            }
                            if (d3s instanceof Closure || d3s instanceof LispGeneric) {
                                Closure cl2;
                                if (d3s instanceof Closure) {
                                    cl2 = (Closure)d3s;
                                } else {
                                    cl2 = this.findmapl(env, (LispGeneric)d3s, d3d);
                                    if (cl2 == null) {
                                        cl2 = this.findm((LispGeneric)d3s, d3d);
                                    } else {
                                        d3d = this.consapl((LispGeneric)d3s, d3d);
                                        d3s = env.findDatum(LispGeneric.APPLY_GENERIC);
                                    }
                                }
                                if (c.getOp().equals((Object)CompiledCode.Oper.CALL_TAIL)) {
                                    env = this.calltail0(c, m, hndl, cl2);
                                } else if (c.getOp().equals((Object)CompiledCode.Oper.CALL)) {
                                    m.push(addr, code, env, hndl, d3s);
                                    env = new Environment(cl2.getEnvironment());
                                    _log.finer("Call:" + cl2.printName() + ":dtstk(" + m.dataStk.size() + "):cdstk(" + m.codeStk.size() + ")");
                                }
                                IntLispUtils.bindLocal(cl2.getParameterList(), d3d, env, this.message);
                                if (d3s instanceof LispGeneric) {
                                    env.bindDatum(Symbol.getSymbol("next-method"), this.findmnext((LispGeneric)d3s, d3d));
                                }
                                code = cl2.getCode();
                                addr = 0;
                                break;
                            }
                            if (d3s instanceof LispNextMethod) {
                                void var24_28;
                                LispNextMethod dzz = (LispNextMethod)d3s;
                                cl = dzz.get();
                                LispNextMethod lispNextMethod = dzz.getNextMethod();
                                if (d3d == Nil.NIL) {
                                    d3d = dzz.getDefaultParams();
                                }
                                if (cl == null && dzz.getMethod().isApplyGeneric()) {
                                    Datum da = IntLispUtils.car(d3d, this.message);
                                    Datum dd = IntLispUtils.cadr(d3d, this.message);
                                    if (!(da instanceof LispGeneric)) {
                                        throw this.message.getError("err.method.next.notfound");
                                    }
                                    cl = this.findm((LispGeneric)da, dd);
                                    Datum datum = this.findmnext((LispGeneric)da, dd);
                                    d3d = dd;
                                }
                                if (cl == null) {
                                    throw this.message.getError("err.method.next.notfound");
                                }
                                if (c.getOp().equals((Object)CompiledCode.Oper.CALL_TAIL)) {
                                    env = this.calltail0(c, m, hndl, (Closure)cl);
                                } else if (c.getOp().equals((Object)CompiledCode.Oper.CALL)) {
                                    m.push(addr, code, env, hndl, d3s);
                                    env = new Environment(((Closure)cl).getEnvironment());
                                    _log.finer("Call:" + ((NamableDatum)cl).printName() + ":dtstk(" + m.dataStk.size() + "):cdstk(" + m.codeStk.size() + ")");
                                }
                                IntLispUtils.bindLocal(((Closure)cl).getParameterList(), d3d, env, this.message);
                                env.bindDatum(Symbol.getSymbol("next-method"), (Datum)var24_28);
                                code = ((Closure)cl).getCode();
                                addr = 0;
                                break;
                            }
                            if (d3s instanceof Continuation) {
                                Continuation ct = (Continuation)d3s;
                                List<Datum> lst = LispUtils.consToList(d3d, this.message);
                                Memento k = (Memento)ct.getMemento();
                                m.overwrite(k.copy());
                                env = (Environment)m.envStk.pop();
                                code = (CompiledCode)m.codeStk.pop();
                                addr = (Integer)m.addrStk.pop();
                                m.callerStk.pop();
                                m.dataStk.pop();
                                m.workStk.pop();
                                m.beforeStk.pop();
                                m.afterStk.pop();
                                m.memoStk.pop();
                                Stack2 stack2 = (Stack2)m.pushbkStk.pop();
                                m.stateStk.pop();
                                hndl = (ExcHandler)m.hndlStk.pop();
                                m.flgStk.pop();
                                if (stack2 == null) {
                                    this.setContinuationArgs(lst, m);
                                    ++addr;
                                    break;
                                }
                                m.dataStk.addAll(stack2);
                                break;
                            }
                            if (!(d3s instanceof Undef)) throw this.message.getError("err.invalidap", d3s);
                            m.dataStk.push(Undef.UNDEF);
                            ++addr;
                            break;
                        }
                        case CALL_METHOD: {
                            Datum d3d1 = (Datum)m.dataStk.pop();
                            Datum d3s1 = (Datum)m.dataStk.pop();
                            if (!(d3s1 instanceof Symbol)) throw new RuntimeException();
                            String string = ((Symbol)d3s1).getName();
                            if ("aux-map".equals(string)) {
                                m.dataStk.push(this.evalLispMap(d3d1));
                            } else if ("aux-map-valid".equals(string)) {
                                m.dataStk.push(this.evalLispMapValid(d3d1));
                            } else if ("aux-apply".equals(string)) {
                                m.dataStk.push(this.evalApply(d3d1));
                            } else if ("aux-apply-valid".equals(string)) {
                                m.dataStk.push(this.evalApplyValid(d3d1));
                            }
                            ++addr;
                            break;
                        }
                        case JMP: {
                            addr = code.getAddress(c.getJmpLabel());
                            break;
                        }
                        case JMP_IF: {
                            if (!LispBoolean.FALSE.equals(m.dataStk.peek())) {
                                addr = code.getAddress(c.getJmpLabel());
                                break;
                            }
                            ++addr;
                            break;
                        }
                        case JMP_UNLESS: {
                            if (LispBoolean.FALSE.equals(m.dataStk.peek())) {
                                addr = code.getAddress(c.getJmpLabel());
                                break;
                            }
                            ++addr;
                            break;
                        }
                        case JMP_TOP: {
                            _log.finer("Jump to top:cdstk(" + m.codeStk.size() + ")");
                            addr = 0;
                            break;
                        }
                        case REFER_SYMBOL: 
                        case REFER_SETTER: {
                            void var24_33;
                            Environment e2;
                            SymbolScope ss;
                            if (c.getDatum() instanceof SymbolScope) {
                                ss = (SymbolScope)c.getDatum();
                                e2 = ss.getExecuteEnv();
                                Datum datum = e2.findDatum(ss.getSymbol());
                            } else {
                                Datum datum = env.findDatum(c.getDatum());
                            }
                            if (var24_33 == null) {
                                throw this.message.getError("err.unbound", c.getDatum());
                            }
                            if (!c.getOp().equals((Object)CompiledCode.Oper.REFER_SETTER)) {
                                m.dataStk.push(var24_33);
                            } else {
                                if (!(var24_33 instanceof Settable)) throw this.message.getError("err.srfi17.required.settable", (Datum)var24_33);
                                Datum st = ((Settable)var24_33).getSetter();
                                if (!(st instanceof Callable)) throw this.message.getError("err.srfi17.notdefined.setter", (Datum)var24_33);
                                m.dataStk.push(st);
                            }
                            ++addr;
                            break;
                        }
                        case REFER_DEFINED: {
                            void var24_36;
                            Environment e2;
                            SymbolScope ss;
                            if (c.getDatum() instanceof SymbolScope) {
                                ss = (SymbolScope)c.getDatum();
                                e2 = ss.getExecuteEnv();
                                Datum datum = e2.findDatum(ss.getSymbol());
                            } else {
                                Datum datum = env.findDatum(c.getDatum());
                            }
                            m.dataStk.push(LispBoolean.getInstance(var24_36 != null));
                            ++addr;
                            break;
                        }
                        case BIND: {
                            Symbol sym;
                            Environment e2;
                            SymbolScope ss;
                            if (c.getDatum() instanceof SymbolScope) {
                                ss = (SymbolScope)c.getDatum();
                                e2 = ss.getExecuteEnv();
                                this.bind0(e2, ss.getSymbol(), (Datum)m.dataStk.pop());
                            } else {
                                if (!(c.getDatum() instanceof Symbol)) throw this.message.getError("err.symbol", c.getDatum());
                                sym = (Symbol)c.getDatum();
                                if (tenv != null) {
                                    this.bind0(tenv, sym, (Datum)m.dataStk.pop());
                                } else {
                                    this.bind0(env, sym, (Datum)m.dataStk.pop());
                                }
                            }
                            ++addr;
                            break;
                        }
                        case BIND_MACRO: {
                            Symbol sym;
                            Environment e2;
                            SymbolScope ss;
                            if (c.getDatum() instanceof SymbolScope) {
                                ss = (SymbolScope)c.getDatum();
                                e2 = ss.getExecuteEnv();
                                this.mbind0(e2, ss.getSymbol(), (Datum)m.dataStk.pop());
                            } else {
                                if (!(c.getDatum() instanceof Symbol)) throw this.message.getError("err.symbol", c.getDatum());
                                sym = (Symbol)c.getDatum();
                                if (tenv != null) {
                                    this.mbind0(tenv, sym, (Datum)m.dataStk.pop());
                                } else {
                                    this.mbind0(env, sym, (Datum)m.dataStk.pop());
                                }
                            }
                            ++addr;
                            break;
                        }
                        case SET: {
                            Environment e2;
                            SymbolScope ss;
                            if (c.getDatum() instanceof SymbolScope) {
                                ss = (SymbolScope)c.getDatum();
                                e2 = ss.getExecuteEnv();
                                if (!this.set0(e2, ss.getSymbol(), (Datum)m.dataStk.peek())) {
                                    throw this.message.getError("err.unbound", ss.getSymbol());
                                }
                            } else if (c.getDatum() instanceof Symbol && !this.set0(env, (Symbol)c.getDatum(), (Datum)m.dataStk.peek())) {
                                throw this.message.getError("err.unbound", c.getDatum());
                            }
                            ++addr;
                            break;
                        }
                        case RETURN_OP: {
                            if (m.callerStk.isEmpty()) {
                                return (Datum)m.dataStk.pop();
                            }
                            env = (Environment)m.envStk.pop();
                            code = (CompiledCode)m.codeStk.pop();
                            addr = (Integer)m.addrStk.pop();
                            m.callerStk.pop();
                            m.beforeStk.pop();
                            m.afterStk.pop();
                            Promise p = (Promise)m.memoStk.pop();
                            Stack2 pk = (Stack2)m.pushbkStk.pop();
                            m.stateStk.pop();
                            hndl = (ExcHandler)m.hndlStk.pop();
                            m.flgStk.pop();
                            _log.finer("Return:dtstk(" + m.dataStk.size() + "):cdstk(" + m.codeStk.size() + ")");
                            if (p != null) {
                                p.setMemo((Datum)m.dataStk.peek());
                            }
                            if (pk == null) {
                                ++addr;
                                break;
                            }
                            m.dataStk.pop();
                            m.dataStk.addAll(pk);
                            break;
                        }
                        case PUSH_CONTINUATION: {
                            Memento cm = m.copy();
                            Continuation rs0 = new Continuation(cm);
                            m.dataStk.push(rs0);
                            ++addr;
                            break;
                        }
                        case PUSH_USYN: {
                            m.envStk.push(env);
                            env = c.getUsyn().getExecuteEnv();
                            ++addr;
                            break;
                        }
                        case POP_USYN: {
                            env = (Environment)m.envStk.pop();
                            ++addr;
                            break;
                        }
                        case FORCE: {
                            Datum d61 = (Datum)m.dataStk.pop();
                            if (!(d61 instanceof Promise)) throw this.message.getError("err.force", "force");
                            Promise p = (Promise)d61;
                            if (p.getMemo() == null) {
                                m.push(addr, code, env, p, hndl);
                                env = new Environment(p.getEnvironment());
                                code = p.getCode();
                                addr = 0;
                                break;
                            }
                            m.dataStk.push(p.getMemo());
                            ++addr;
                            break;
                        }
                        case NEW_PROMISE: {
                            if (!(c.getDatum() instanceof Promise)) {
                                throw this.message.getError("err.force");
                            }
                            Promise p = (Promise)c.getDatum();
                            Promise np = new Promise(p.getCode());
                            np.setEnvironment(env);
                            m.dataStk.push(np);
                            ++addr;
                            break;
                        }
                        case APPEND_VALUES: {
                            Datum d71 = (Datum)m.dataStk.pop();
                            if (d71 instanceof MultiValues) {
                                MultiValues d = (MultiValues)d71;
                                m.dataStk.push(LispUtils.listToCons(d.getValues()));
                            } else if (d71 == Undef.UNDEF) {
                                m.dataStk.push(Nil.NIL);
                            } else {
                                Cons b = new Cons();
                                b.setCar(d71);
                                m.dataStk.push(b);
                            }
                            ++addr;
                            break;
                        }
                        case EVAL_CODE: {
                            Closure cl;
                            Datum d81 = (Datum)m.dataStk.pop();
                            Datum d82 = (Datum)m.dataStk.pop();
                            if (!(d81 instanceof EnvironmentObject)) {
                                throw this.message.getError("err.environment");
                            }
                            d82 = PatternMatch.removeScope(d82);
                            EnvironmentObject eo = (EnvironmentObject)d81;
                            if (eo.isInherit()) {
                                cl = this.makeEval(d82, eo.getEnvironment(), m);
                                m.push(addr, code, env, hndl, cl);
                                env = new Environment(cl.getEnvironment());
                                code = cl.getCode();
                                addr = 0;
                                break;
                            }
                            cl = this.makeEval(d82, eo.getEnvironment(), m);
                            m.dataStk.push(this.exec(cl.getCode(), eo.getEnvironment(), this.newMemento()));
                            ++addr;
                            break;
                        }
                        case LOAD_CODE: 
                        case OVERRIDE_LOAD_CODE: {
                            Datum d84 = (Datum)m.dataStk.pop();
                            if (!(d84 instanceof InputPort)) throw this.message.getError("err.require.iport");
                            InputPort ipt = (InputPort)d84;
                            ClosureClass clc = this.makeLoad(ipt, env, m);
                            if (c.getOp().equals((Object)CompiledCode.Oper.LOAD_CODE)) {
                                m.push(addr, code, env, hndl, clc, Flags.LOAD);
                            } else {
                                m.push(addr, code, env, hndl, clc, Flags.LOAD_OV);
                                env = (Environment)m.envStk.get(m.envStk.size() - 2);
                            }
                            code = clc.getCode();
                            addr = 0;
                            break;
                        }
                        case EXPAND_MACRO: {
                            Datum d85 = (Datum)m.dataStk.pop();
                            LispCompiler cp0 = CompilerFactory.getInstance(this.message);
                            m.dataStk.push(cp0.expandMacro(d85, env, this, new Memento()));
                            ++addr;
                            break;
                        }
                        case EXPAND_MACRO1: {
                            Datum d86 = (Datum)m.dataStk.pop();
                            LispCompiler cp1 = CompilerFactory.getInstance(this.message);
                            m.dataStk.push(cp1.expandMacro1(d86, env, this, new Memento()));
                            ++addr;
                            break;
                        }
                        case FIND_LIST: {
                            Datum d91lst = (Datum)m.dataStk.pop();
                            Datum d91k = (Datum)m.dataStk.peek();
                            m.dataStk.push(IntLispUtils.findListEqv(d91k, d91lst, this.message));
                            ++addr;
                            break;
                        }
                        case BIND_METHOD: {
                            if (c.getDatum() instanceof SymbolScope) {
                                SymbolScope ss = (SymbolScope)c.getDatum();
                                Environment e2 = ss.getExecuteEnv();
                                this.bind0m(e2, ss.getSymbol(), (Datum)m.dataStk.pop());
                            } else {
                                if (!(c.getDatum() instanceof Symbol)) throw this.message.getError("err.symbol", c.getDatum());
                                Symbol sym = (Symbol)c.getDatum();
                                if (tenv != null) {
                                    this.bind0m(tenv, sym, (Datum)m.dataStk.pop());
                                } else {
                                    this.bind0m(env, sym, (Datum)m.dataStk.pop());
                                }
                            }
                            ++addr;
                            break;
                        }
                        case JAVA_CALL: {
                            Class<?> d92c;
                            Object d92o;
                            Datum d921 = (Datum)m.dataStk.pop();
                            Datum d92k = (Datum)m.dataStk.pop();
                            if (d92k instanceof JavaInstance) {
                                d92o = ((JavaInstance)d92k).getJavaInstance();
                                d92c = d92o.getClass();
                            } else {
                                if (!(d92k instanceof JavaClass)) throw this.message.getError("err.require.java-callable", d92k);
                                d92o = null;
                                d92c = ((JavaClass)d92k).getJavaClass();
                            }
                            try {
                                Object d92r = IntLispUtils.invokeMethod(d92c, d92o, c.getMethod().getName(), LispUtils.consToList(d921, this.message));
                                m.dataStk.push(LispUtils.toDatum(d92r));
                            }
                            catch (IntPrmNotFoundException e) {
                                throw this.message.getError("err.java.method.notfound", c.getMethod().getName());
                            }
                            ++addr;
                            break;
                        }
                        case JAVA_GET: {
                            Datum d93k = (Datum)m.dataStk.pop();
                            if (!(d93k instanceof JavaInstance)) {
                                throw this.message.getError("err.require.java-instance", d93k);
                            }
                            Object d93o = ((JavaInstance)d93k).getJavaInstance();
                            try {
                                Object d93r = c.getBeanIndex() != null ? IntLispUtils.invokeGetter(d93o, c.getMethod().getName(), c.getBeanIndex().getExactSmallInt()) : IntLispUtils.invokeGetter(d93o, c.getMethod().getName());
                                m.dataStk.push(LispUtils.toDatum(d93r));
                            }
                            catch (IntPrmNotFoundException e) {
                                throw this.message.getError("err.java.getter.notfound", c.getMethod().getName());
                            }
                            catch (IntrospectionException e) {
                                throw this.message.getError("err.java.getter.notfound", c.getMethod().getName());
                            }
                            ++addr;
                            break;
                        }
                        case JAVA_SET: {
                            Datum d941 = (Datum)m.dataStk.pop();
                            Datum d94k = (Datum)m.dataStk.pop();
                            if (!(d94k instanceof JavaInstance)) {
                                throw this.message.getError("err.require.java-instance", d94k);
                            }
                            Object d94o = ((JavaInstance)d94k).getJavaInstance();
                            try {
                                if (c.getBeanIndex() != null) {
                                    IntLispUtils.invokeSetter(d94o, c.getMethod().getName(), c.getBeanIndex().getExactSmallInt(), d941);
                                } else {
                                    IntLispUtils.invokeSetter(d94o, c.getMethod().getName(), d941);
                                }
                                m.dataStk.push(Undef.UNDEF);
                            }
                            catch (IntPrmNotFoundException e) {
                                throw this.message.getError("err.java.setter.notfound", c.getMethod().getName());
                            }
                            catch (IntrospectionException e) {
                                throw this.message.getError("err.java.setter.notfound", c.getMethod().getName());
                            }
                            ++addr;
                            break;
                        }
                        case JAVA_FIELD_GET: {
                            Datum d95k = (Datum)m.dataStk.pop();
                            if (!(d95k instanceof JavaInstance)) {
                                throw this.message.getError("err.require.java-instance", d95k);
                            }
                            Object d95o = ((JavaInstance)d95k).getJavaInstance();
                            try {
                                Object d95r = IntLispUtils.getField(d95o, c.getMethod().getName());
                                m.dataStk.push(LispUtils.toDatum(d95r));
                            }
                            catch (NoSuchFieldException e) {
                                throw this.message.getError("err.java.field.notfound", c.getMethod().getName());
                            }
                            ++addr;
                            break;
                        }
                        case JAVA_FIELD_SET: {
                            Datum d961 = (Datum)m.dataStk.pop();
                            Datum d96k = (Datum)m.dataStk.pop();
                            if (!(d96k instanceof JavaInstance)) {
                                throw this.message.getError("err.require.java-instance", d96k);
                            }
                            Object d96o = ((JavaInstance)d96k).getJavaInstance();
                            try {
                                IntLispUtils.setField(d96o, c.getMethod().getName(), d961);
                                m.dataStk.push(Undef.UNDEF);
                            }
                            catch (IntPrmNotFoundException e) {
                                throw this.message.getError("err.java.field.notfound", c.getMethod().getName());
                            }
                            catch (NoSuchFieldException e) {
                                throw this.message.getError("err.java.field.notfound", c.getMethod().getName());
                            }
                            ++addr;
                            break;
                        }
                        case JAVA_INSTANCEOF: {
                            Datum d97k = (Datum)m.dataStk.pop();
                            if (d97k instanceof JavaInstance) {
                                Object d97o = ((JavaInstance)d97k).getJavaInstance();
                                try {
                                    Class<?> dn = Class.forName(c.getMethod().getName());
                                    boolean rs = dn.isAssignableFrom(d97o.getClass());
                                    m.dataStk.push(LispBoolean.getInstance(rs));
                                }
                                catch (ClassNotFoundException e) {
                                    m.dataStk.push(LispBoolean.FALSE);
                                }
                            } else {
                                m.dataStk.push(LispBoolean.FALSE);
                            }
                            ++addr;
                            break;
                        }
                        case JAVA_RAISE: {
                            Object d98o;
                            Datum d98e = (Datum)m.dataStk.pop();
                            if (!(d98e instanceof JavaInstance) || !((d98o = ((JavaInstance)d98e).getJavaInstance()) instanceof Throwable)) throw this.message.getError("err.require.java-exception", d98e);
                            throw new JavaTargetException((Throwable)d98o);
                        }
                        case JAVA_ENTER_EXCEPTION_HANDLER: {
                            hndl.lablStk.push(c.getJmpLabel());
                            hndl.hndlStk.push(c.getDatum());
                            hndl.codeStk.push(code);
                            hndl.envStk.push(env);
                            hndl.memStk.push(m.copy());
                            ++addr;
                            break;
                        }
                        case JAVA_LEAVE_EXCEPTION_HANDLER: {
                            hndl.lablStk.pop();
                            hndl.hndlStk.pop();
                            hndl.codeStk.pop();
                            hndl.envStk.pop();
                            hndl.memStk.pop();
                            ++addr;
                            break;
                        }
                        case REWIND_ENV: {
                            tenv = env;
                            int i = 0;
                            while (i < c.getRewind()) {
                                tenv = (Environment)m.envStk.pop();
                                ++i;
                            }
                            ++addr;
                            break;
                        }
                        case REWIND_CONT: {
                            _log.finer("Remove " + c.getRewind() + " frame(s)");
                            int i = 0;
                            while (i < c.getRewind()) {
                                addr = (Integer)m.addrStk.pop();
                                code = (CompiledCode)m.codeStk.pop();
                                m.callerStk.pop();
                                m.beforeStk.pop();
                                m.afterStk.pop();
                                m.memoStk.pop();
                                m.pushbkStk.pop();
                                m.stateStk.pop();
                                hndl = (ExcHandler)m.hndlStk.pop();
                                m.flgStk.pop();
                                ++i;
                            }
                            env = tenv;
                            tenv = null;
                            addr = 0;
                        }
                    }
                }
            }
            catch (JavaTargetException e) {
                if (hndl.hndlStk.isEmpty()) {
                    throw e;
                }
                Datum d3s = (Datum)hndl.hndlStk.pop();
                Cons d3d = new Cons(new JavaInstance(e.getCause()), Nil.NIL);
                addr = code.getAddress((Integer)hndl.lablStk.pop()) - 1;
                code = (CompiledCode)hndl.codeStk.pop();
                env = (Environment)hndl.envStk.pop();
                m.overwrite((Memento)hndl.memStk.pop());
                if (!(d3s instanceof ClosureClass)) throw this.message.getError("err.invalidap", d3s);
                ClosureClass cl = (ClosureClass)d3s;
                m.push(addr, code, env, hndl, d3s);
                env = new Environment(env);
                IntLispUtils.bindLocal(cl.getParameterList(), d3d, env, this.message);
                code = cl.getCode();
                addr = 0;
                continue;
            }
            break;
        }
    }

    @Override
    public Datum exec(CompiledCode code1, Environment env1, IntStack memento) {
        return this.exec(code1, env1, memento, true);
    }

    @Override
    public IntStack newMemento() {
        return new Memento();
    }

    private static class ExcHandler {
        private Stack<Integer> lablStk = new Stack();
        private Stack<Datum> hndlStk = new Stack();
        private Stack<CompiledCode> codeStk = new Stack();
        private Stack<Environment> envStk = new Stack();
        private Stack<Memento> memStk = new Stack();

        private ExcHandler() {
        }

        private ExcHandler copy() {
            ExcHandler res = new ExcHandler();
            res.lablStk.addAll(this.lablStk);
            res.hndlStk.addAll(this.hndlStk);
            res.codeStk.addAll(this.codeStk);
            res.envStk.addAll(this.envStk);
            res.memStk.addAll(this.memStk);
            return res;
        }
    }

    private static class Flags {
        private static final Flags INS = new Flags();
        private static final Flags LOAD = new Flags();
        private static final Flags LOAD_OV = new Flags();

        private Flags() {
        }
    }

    private class Memento
    implements IntStack {
        private Stack2<Integer> addrStk = new ArrayListStack<Integer>();
        private Stack2<CompiledCode> codeStk = new ArrayListStack<CompiledCode>();
        private Stack2<Environment> envStk = new ArrayListStack<Environment>();
        private Stack2<Datum> dataStk = new ArrayListStack<Datum>();
        private Stack2<ConsListBuilder> workStk = new ArrayListStack<ConsListBuilder>();
        private Stack2<Datum> callerStk = new ArrayListStack<Datum>();
        private Stack2<Flags> flgStk = new ArrayListStack<Flags>();
        private Stack2<PrRef> beforeStk = new ArrayListStack<PrRef>();
        private Stack2<PrRef> afterStk = new ArrayListStack<PrRef>();
        private Stack2<Stack2<Datum>> pushbkStk = new ArrayListStack<Stack2<Datum>>();
        private Stack2<Integer> stateStk = new ArrayListStack<Integer>();
        private List<PrRef> befLst = new ArrayList<PrRef>();
        private Stack2<Promise> memoStk = new ArrayListStack<Promise>();
        private Stack2<ExcHandler> hndlStk = new ArrayListStack<ExcHandler>();

        private Memento() {
        }

        public Memento copy() {
            Memento r = new Memento();
            r.addrStk.addAll(this.addrStk);
            r.codeStk.addAll(this.codeStk);
            r.dataStk.addAll(this.dataStk);
            r.callerStk.addAll(this.callerStk);
            r.beforeStk.addAll(this.beforeStk);
            r.afterStk.addAll(this.afterStk);
            r.memoStk.addAll(this.memoStk);
            r.pushbkStk.addAll(this.pushbkStk);
            r.stateStk.addAll(this.stateStk);
            for (ExcHandler h : this.hndlStk.toList()) {
                r.hndlStk.add(h.copy());
            }
            for (ConsListBuilder l : this.workStk.toList()) {
                r.workStk.add(new ConsListBuilder(l, CodeExecutorImpl.this.message));
            }
            for (Environment e : this.envStk.toList()) {
                r.envStk.add(e.copyNotRoot());
            }
            r.befLst.addAll(this.befLst);
            r.flgStk.addAll(this.flgStk);
            return r;
        }

        private void overwrite(Memento m) {
            this.addrStk = m.addrStk;
            this.codeStk = m.codeStk;
            this.envStk = m.envStk;
            this.dataStk = m.dataStk;
            this.workStk = m.workStk;
            this.callerStk = m.callerStk;
            this.beforeStk = m.beforeStk;
            this.afterStk = m.afterStk;
            this.memoStk = m.memoStk;
            this.pushbkStk = m.pushbkStk;
            this.stateStk = m.stateStk;
            this.hndlStk = m.hndlStk;
            this.flgStk = m.flgStk;
        }

        private void push(int addr, CompiledCode code, Environment env, ExcHandler hndl, Datum callee) {
            this.addrStk.push(addr);
            this.codeStk.push(code);
            this.envStk.push(env);
            this.callerStk.push(callee);
            this.beforeStk.push(null);
            this.afterStk.push(null);
            this.memoStk.push(null);
            this.pushbkStk.push(null);
            this.stateStk.push(0);
            this.hndlStk.push(hndl);
            this.flgStk.push(Flags.INS);
        }

        private void push(int addr, CompiledCode code, Environment env, ExcHandler hndl, Datum callee, Flags flgs) {
            this.addrStk.push(addr);
            this.codeStk.push(code);
            this.envStk.push(env);
            this.callerStk.push(callee);
            this.beforeStk.push(null);
            this.afterStk.push(null);
            this.memoStk.push(null);
            this.pushbkStk.push(null);
            this.stateStk.push(0);
            this.hndlStk.push(hndl);
            this.flgStk.push(flgs);
        }

        private void push(int addr, CompiledCode code, Environment env, Promise p, ExcHandler hndl) {
            this.addrStk.push(addr);
            this.codeStk.push(code);
            this.envStk.push(env);
            this.callerStk.push(p);
            this.beforeStk.push(null);
            this.afterStk.push(null);
            this.memoStk.push(p);
            this.pushbkStk.push(null);
            this.stateStk.push(0);
            this.hndlStk.push(hndl);
            this.flgStk.push(Flags.INS);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append(this.addrStk.size()).append(" , ");
            bld.append(this.codeStk.size()).append(" , ");
            bld.append(this.envStk.size()).append(" , ");
            bld.append(this.dataStk.size()).append(" , ");
            bld.append(this.workStk.size()).append(" , ");
            bld.append(this.callerStk.size()).append(" , ");
            bld.append(this.beforeStk.size()).append(" , ");
            bld.append(this.afterStk.size()).append(" , ");
            bld.append(this.memoStk.size()).append(" , ");
            bld.append(this.pushbkStk.size()).append(" , ");
            bld.append(this.stateStk.size()).append(" , ");
            bld.append(this.hndlStk.size()).append("\n");
            bld.append(this.addrStk).append("\n");
            bld.append(this.envStk).append("\n");
            bld.append(this.dataStk).append("\n");
            bld.append(this.workStk).append("\n");
            bld.append(this.callerStk).append("\n");
            bld.append(this.beforeStk).append("\n");
            bld.append(this.afterStk).append("\n");
            bld.append(this.memoStk).append("\n");
            return bld.toString();
        }

        private void desc(StringBuilder buf, Datum d) {
            if (d instanceof Subr) {
                Subr s = (Subr)d;
                if (s.symbolName != null) {
                    buf.append("  -");
                    buf.append(CodeExecutorImpl.this.message.get("err.stacktrace.subr"));
                    buf.append(" ");
                    buf.append(s.symbolName);
                    buf.append("\n");
                }
            } else if (d instanceof Closure) {
                Closure c = (Closure)d;
                if (c.getName() != null) {
                    buf.append("  -");
                    buf.append(CodeExecutorImpl.this.message.get("err.stacktrace.closure"));
                    buf.append(" ");
                    buf.append(c.getName());
                    buf.append("\n");
                }
            } else if (d instanceof Promise) {
                Promise p = (Promise)d;
                buf.append("  -");
                buf.append(CodeExecutorImpl.this.message.get("err.stacktrace.promise"));
                buf.append(" ");
                buf.append(Integer.toString(p.hashCode(), 16));
                buf.append("\n");
            } else {
                buf.append("  -");
                buf.append(LispUtils.print(d));
                buf.append("\n");
            }
        }

        public String getStackTrace() {
            StringBuilder buf = new StringBuilder();
            int i = this.callerStk.size() - 1;
            while (i >= 0) {
                this.desc(buf, this.callerStk.get(i));
                --i;
            }
            return buf.toString();
        }
    }

    private static class PrRef {
        private Datum proc;

        private PrRef() {
        }

        public String toString() {
            return "<" + this.proc + ">";
        }
    }
}

