/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Scheme;

class EnvironmentObject
extends Datum {
    private Environment environment;
    private boolean inherit = false;

    private EnvironmentObject(Environment environment, boolean inherit) {
        if (environment == null) {
            throw new NullPointerException();
        }
        this.environment = environment;
        this.inherit = inherit;
    }

    static EnvironmentObject newNullEnv(int ver) {
        return new EnvironmentObject(Scheme.newNullEnv(ver), false);
    }

    static EnvironmentObject newRnRSEnv(int ver) {
        return new EnvironmentObject(Scheme.newRnRSEnv(ver), false);
    }

    static EnvironmentObject newInteractionEnv(Environment e) {
        return new EnvironmentObject(e, true);
    }

    Environment getEnvironment() {
        return this.environment;
    }

    boolean isInherit() {
        return this.inherit;
    }
}

