/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHash
extends Datum
implements Map<Datum, Datum> {
    private Map<Datum, Datum> hash = new IdentityHashMap<Datum, Datum>();

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hash.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hash.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Datum, Datum>> entrySet() {
        return Collections.unmodifiableSet(this.hash.entrySet());
    }

    @Override
    public Datum get(Object key) {
        return this.hash.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.hash.isEmpty();
    }

    @Override
    public Set<Datum> keySet() {
        return Collections.unmodifiableSet(this.hash.keySet());
    }

    @Override
    public Datum put(Datum key, Datum value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Datum, ? extends Datum> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datum remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.hash.size();
    }

    @Override
    public Collection<Datum> values() {
        return Collections.unmodifiableCollection(this.hash.values());
    }

    public static class ClearS
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof IdentityHash) {
                ((IdentityHash)c1a).hash.clear();
                return Undef.UNDEF;
            }
            throw mesg.getError("err.identityhash.required", c1a);
        }
    }

    public static class DeleteS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof IdentityHash) {
                ((IdentityHash)c1a).hash.remove(c2a);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.identityhash.required", c1a);
        }
    }

    public static class Get
    extends Subr {
        private Datum exec(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (c1a instanceof IdentityHash) {
                IdentityHash hs = (IdentityHash)c1a;
                if (hs.hash.containsKey(c2a)) {
                    return (Datum)hs.hash.get(c2a);
                }
                if (c3a != null) {
                    return c3a;
                }
                throw mesg.getError("err.hash.valuenotfound", c2a);
            }
            throw mesg.getError("err.identityhash.required", c1a);
        }

        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            if (body instanceof Cons) {
                Cons c1 = (Cons)body;
                Datum c1a = c1.getCar();
                if (c1.getCdr() instanceof Cons) {
                    Cons c2 = (Cons)c1.getCdr();
                    Datum c2a = c2.getCar();
                    Datum c3a = null;
                    if (c2.getCdr() instanceof Cons) {
                        Cons c3 = (Cons)c2.getCdr();
                        c3a = c3.getCar();
                        if (c3.getCdr() != Nil.NIL) {
                            throw mesg.getError("err.argument", this.symbolName);
                        }
                    } else if (c2.getCdr() != Nil.NIL) {
                        throw mesg.getError("err.argument", this.symbolName);
                    }
                    return this.exec(c1a, c2a, c3a, env, mesg);
                }
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class IsExists
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof IdentityHash) {
                boolean res = ((IdentityHash)c1a).hash.containsKey(c2a);
                return LispBoolean.getInstance(res);
            }
            throw mesg.getError("err.identityhash.required", c1a);
        }
    }

    public static class Make
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            if (body == Nil.NIL) {
                return new IdentityHash();
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class PutS
    extends TernaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (c1a instanceof IdentityHash) {
                ((IdentityHash)c1a).hash.put(c2a, c3a);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.identityhash.required", c1a);
        }
    }
}

