/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import net.morilib.lisp.Datum;
import net.morilib.lisp.EOFObject;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Parser;

public class InputPort
extends Datum {
    private PushbackReader reader;
    private boolean standard;
    private Parser parser;
    private boolean reachedEOF = false;
    private boolean closed = false;
    private LispMessage msg;

    private InputPort(Reader rd, boolean std, LispMessage msg) {
        this.reader = new PushbackReader(rd);
        this.standard = std;
        this.msg = msg;
        this.parser = new Parser(this.reader, msg);
    }

    InputPort(Reader rd, LispMessage msg) {
        this(rd, false, msg);
    }

    InputPort(String fname, LispMessage msg) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(fname));
            this.reader = new PushbackReader(rd);
            this.standard = false;
            this.msg = msg;
            this.parser = new Parser(this.reader, msg);
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    static InputPort getStandard(LispMessage msg) {
        return new InputPort(new InputStreamReader(System.in), true, msg);
    }

    public Datum readChar() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return EOFObject.EOF;
        }
        try {
            int ch = this.reader.read();
            if (ch < 0) {
                this.reachedEOF = true;
                return EOFObject.EOF;
            }
            return new LispCharacter((char)ch);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public Datum peekChar() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return EOFObject.EOF;
        }
        try {
            int ch = this.reader.read();
            if (ch < 0) {
                this.reachedEOF = true;
                return EOFObject.EOF;
            }
            this.reader.unread(ch);
            return new LispCharacter((char)ch);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public Datum read() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return EOFObject.EOF;
        }
        try {
            this.parser.clear();
            if (this.parser.parse()) {
                Datum res = this.parser.getDatum();
                if (res != null) {
                    return res;
                }
                this.reachedEOF = true;
                return EOFObject.EOF;
            }
            this.reachedEOF = true;
            if (!this.parser.isReadBefore()) {
                return EOFObject.EOF;
            }
            throw this.msg.getReadError("err.read.eof");
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public void close() {
        try {
            if (!this.closed && !this.standard) {
                this.reader.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    public boolean isReachedEOF() {
        return this.reachedEOF;
    }

    public boolean isTypePort() {
        return true;
    }

    Parser getParser() {
        return this.parser;
    }
}

